package com.elitesland.fin.application.facade.dto.writeoff;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 收款单详情信息
 */
@Data
public class RecOrderExDtDTO implements Serializable {

    private static final long serialVersionUID = 2161244210813335471L;


    @ApiModelProperty(value = "id主键")
    private Long id;

    @ApiModelProperty("收款单明细Id")
    private Long recDId;

    @ApiModelProperty(value = "第三方收款单id(必填)")
    @NotBlank(message = "第三方应收款id不能为空")
    private String thirdOrderDtId;

    @ApiModelProperty(value = "客户编码(必填)")
    @NotBlank(message = "客户编码不能为空")
    private String custCode;

    @ApiModelProperty(value = "收款单明细表关联id(必填)")
    @NotNull(message = "收款单明细表关联id不能为空")
    private Long relateId;

    @ApiModelProperty("收款单ID")
    private Long recOrderId;

    @ApiModelProperty(value = "收款单编码")
    private String recOrderNo;

    @ApiModelProperty(value = "收款业务类型(必填)")
    @NotBlank(message = "收款业务类型不能为空")
    private String recKind;

    @ApiModelProperty(value = "收款性质(必填)")
    @NotBlank(message = "收款性质不能为空")
    private String naturePayment;

    @ApiModelProperty(value = "部门(必填)")
    @NotBlank(message = "部门不能为空")
    private String buCode;

    @ApiModelProperty(value = "业务员编码(必填)")
    @NotBlank(message = "业务员编码不能为空")
    private String businessCode;

    @ApiModelProperty(value = "币种(必填)")
    @NotBlank(message = "币种不能为空")
    private String currCode;

    @ApiModelProperty(value = "汇率(必填)")
    @NotBlank(message = "汇率不能为空")
    private String exchangeRate;

    @ApiModelProperty(value = "原币金额(必填)")
    @NotBlank(message = "原币金额不能为空")
    private String totalAmt;

    @ApiModelProperty(value = "本币金额(必填)")
    @NotBlank(message = "本币金额不能为空")
    private String totalCurAmt;

    @ApiModelProperty(value = "收款银行账户")
    private String recBank;

    @ApiModelProperty(value = "付款银行账户")
    private String payBank;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty("收款公司编码")
    private String recOuCode;

    @ApiModelProperty("收款公司名称")
    private String recOuName;

    @ApiModelProperty("已核销金额")
    private BigDecimal verAmt;

    @ApiModelProperty("未核销金额")
    private BigDecimal unVerAmt;

    @ApiModelProperty("核销申请中金额")
    private BigDecimal applyVerAmTing;

    @ApiModelProperty(value = "发票号")
    private String invoiceNumber;

    @ApiModelProperty(value = "单据日期")
    private LocalDateTime createTime;

    @ApiModelProperty("第三方收款单号")
    private String sourceNo;
}
