package com.elitesland.fin.application.facade.param.saobei.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class SaobeiTradeParamVO {
    /**
     * 版本号
     */
    @ApiModelProperty("版本号")
    private String api_ver;

    /**
     * 请求流水号
     */
    @ApiModelProperty("请求流水号")
    private String trace_no;

    /**
     * 机构号
     */
    @ApiModelProperty("机构号")
    private String inst_no;

    /**
     * CBK账号
     */
    @ApiModelProperty("CBK账号")
    private String account_no;

    @ApiModelProperty("查询开始日期，格式为yyyyMMdd")
    private String start_date;

    @ApiModelProperty("查询结束日期，格式为yyyyMMdd")
    private String end_date;

    @ApiModelProperty("页码")
    private String page;

    /**
     * 签名检验串,非空参数字典排序+令牌（机构令牌名称为key，拼接签名串参数不需要转义），32位md5加密转换
     */
    @ApiModelProperty("签名检验串")
    private String key_sign;

}
