package com.elitesland.fin.application.service.writeoff;

import cn.hutool.core.collection.CollectionUtil;
import com.elitesland.fin.application.convert.writeoff.FinArRecVerApplyRecConvert;
import com.elitesland.fin.application.facade.dto.writeoff.FinApPayVerApplyPaySaveDTO;
import com.elitesland.fin.application.facade.dto.writeoff.FinArRecVerApplyRecSaveDTO;
import com.elitesland.fin.application.facade.param.writeoff.FinArRecVerApplyQuery;
import com.elitesland.fin.application.facade.param.writeoff.FinArRecVerApplyRecQuery;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyPayVO;
import com.elitesland.fin.application.facade.vo.writeoff.FinArRecVerApplyRecVO;
import com.elitesland.fin.domain.entity.writeoff.FinArRecVerApplyRecDO;
import com.elitesland.fin.infr.dto.payorder.PayOrderDTO;
import com.elitesland.fin.infr.dto.recorder.RecOrderDTO;
import com.elitesland.fin.infr.repo.payorder.PayOrderRepoProc;
import com.elitesland.fin.infr.repo.recorder.RecOrderRepoProc;
import com.elitesland.fin.repo.writeoff.FinArRecVerApplyRecRepoProc;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 核销申请.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Service
@RequiredArgsConstructor
public class FinArRecVerApplyRecServiceImpl implements FinArRecVerApplyRecService {

    private final FinArRecVerApplyRecRepoProc finArRecVerApplyRecRepoProc;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;
    private final RecOrderRepoProc recOrderRepoProc;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void createBatch(Long masId, List<FinArRecVerApplyRecSaveDTO> saveList) {
        Assert.notNull(masId, "主表ID不能为Null");
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }

        List<String> recDocNoList = saveList.stream().map(FinArRecVerApplyRecSaveDTO::getRecDocNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<RecOrderDTO> recOrderDTOList = recOrderRepoProc.selectInOutCustByRecOrderNo(recDocNoList);
        Map<String, RecOrderDTO> recOrderDMap = CollectionUtil.isEmpty(recOrderDTOList) ? new HashMap<>() : recOrderDTOList.stream().collect(Collectors.toMap(RecOrderDTO::getRecOrderNo, t -> t, (t1, t2) -> t1));


        finArRecVerApplyRecRepoProc.save(saveList.stream()
                .map(e -> {
                    FinArRecVerApplyRecDO entity = FinArRecVerApplyRecConvert.INSTANCE.save2Do(e);
                    entity.setMasId(masId);
                    RecOrderDTO recOrderDTO = recOrderDMap.get(entity.getRecDocNo());
                    if (Objects.nonNull(recOrderDTO)){
                        String inOutCust = StringUtils.isBlank(entity.getInOutCust()) ? recOrderDTO.getInOutCust() : entity.getInOutCust();
                        String relevanceOuCode = StringUtils.isBlank(entity.getRelevanceOuCode()) ? recOrderDTO.getRelevanceOuCode() : entity.getRelevanceOuCode();
                        entity.setInOutCust(inOutCust);
                        entity.setRelevanceOuCode(relevanceOuCode);
                    }
                    return entity;
                }).collect(Collectors.toList()));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByMasId(Collection<Long> masIds) {
        finArRecVerApplyRecRepoProc.deleteByMasId(masIds);
    }

    @Override
    public List<FinArRecVerApplyRecVO> listByMasIds(Collection<Long> masIds) {
        List<FinArRecVerApplyRecVO> finArRecVerApplyRecVOList = finArRecVerApplyRecRepoProc.listByMasIds(masIds)
                .stream()
                .map(FinArRecVerApplyRecConvert.INSTANCE::entity2Vo)
                .collect(Collectors.toList());

        if (CollectionUtil.isEmpty(finArRecVerApplyRecVOList)){
            return Collections.EMPTY_LIST;
        }

        List<String> relevanceOuCodeList = finArRecVerApplyRecVOList.stream().map(FinArRecVerApplyRecVO::getRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relevanceOuCodeList);
        finArRecVerApplyRecVOList.forEach(v -> {
            OrgOuRpcSimpleDTO ouRpcSimpleDTO = ouMap.get(v.getRelevanceOuCode());
            if (Objects.nonNull(ouRpcSimpleDTO)){
                v.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
            }
        });

        return finArRecVerApplyRecVOList;
    }

	/**
	 * 根据条件查询核销收款单明细
	 *
	 * @param query
	 * @return
	 */
	@Override
	public List<FinArRecVerApplyRecVO> listByQuery(FinArRecVerApplyRecQuery query) {
		return finArRecVerApplyRecRepoProc.listByQuery(query)
				.stream()
				.map(FinArRecVerApplyRecConvert.INSTANCE::entity2Vo)
				.collect(Collectors.toList());
	}

	/**
	 * 通过第三方收款单号或者明细ID查询
	 *
	 * @param query
	 * @return
	 */
	@Override
	public List<FinArRecVerApplyRecVO> listByOutRecDocNoOrDId(FinArRecVerApplyQuery query) {
		/*if(StrUtil.isEmpty(query.getOutRecDocNo()) && StrUtil.isEmpty(query.getOutRecDId())){
			return null;
		}*/
		return finArRecVerApplyRecRepoProc.listByOutRecDocNoOrDId(query);
	}
}
