package com.elitesland.fin.domain.service.payment;


import com.elitesland.fin.domain.base.BaseRepo;
import com.elitesland.fin.entity.payment.PaymentRuleConfigDtlDO;
import com.elitesland.fin.repo.payment.PaymentRuleConfigDtlRepo;
import com.elitesland.fin.repo.payment.PaymentRuleConfigDtlRepoProc;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
@Service
@AllArgsConstructor
public class PaymentRuleConfigDtlDomainServiceImpl implements PaymentRuleConfigDtlDomainService {
    private final PaymentRuleConfigDtlRepo paymentRuleConfigDtlRepo;

    private final PaymentRuleConfigDtlRepoProc paymentRuleConfigDtlRepoProc;

    @Override
    public BaseRepo<PaymentRuleConfigDtlDO, Long> getDao() {
        return paymentRuleConfigDtlRepo;
    }

    @Override
    public void updateDynamically(List<PaymentRuleConfigDtlDO> invSceneConfigDtlDOS) {
        paymentRuleConfigDtlRepoProc.updateDynamically(invSceneConfigDtlDOS);
    }

    @Override
    public List<PaymentRuleConfigDtlDO> findPaymentRuleConfigDtlByMasId(Long masId) {
        return paymentRuleConfigDtlRepo.findByMasId(masId);
    }

    @Override
    public void deleteByParam(PaymentRuleConfigDtlDO paymentRuleConfigDtlDO) {
        paymentRuleConfigDtlRepoProc.deleteByParam(paymentRuleConfigDtlDO);
    }
}