/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.excel.imp;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.excel.common.DataImport;
import com.elitesland.fin.application.convert.account.AccountConvert;
import com.elitesland.fin.application.facade.excel.account.AccountImportEntity;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.account.AccountDO;
import com.elitesland.fin.repo.account.AccountRepo;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.support.provider.org.param.OrgOuRpcDtoParam;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AccountImportServiceImpl
implements DataImport<AccountImportEntity> {
    private static final Logger log = LoggerFactory.getLogger(AccountImportServiceImpl.class);
    private final AccountRepo accountRepo;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;
    private final UdcProvider udcProvider;
    private static final String ERROR_TEMPLATE = "\u7b2c {0} \u884c: {1} \u89e3\u6790\u5f02\u5e38: {2}; ";

    public String getTmplCode() {
        return "fin_account_import";
    }

    public List<String> executeImport(List<AccountImportEntity> dataList, int rowId) {
        if (CollUtil.isEmpty(dataList)) {
            return Collections.emptyList();
        }
        return this.saveData(dataList, rowId);
    }

    private List<String> saveData(List<AccountImportEntity> dataList, int rowId) {
        dataList.stream().forEach(item -> {
            if ("\u662f".equals(item.getDefaultAccount())) {
                item.setDefaultAccount("true");
            }
            if ("\u5426".equals(item.getDefaultAccount())) {
                item.setDefaultAccount("false");
            }
        });
        List<AccountDO> accountDOList = AccountConvert.INSTANCE.accountImportEntityList2AccountDOList(dataList);
        ArrayList<String> errorResult = new ArrayList<String>();
        ArrayList<AccountDO> saveList = new ArrayList<AccountDO>();
        List allAccountDOList = this.accountRepo.findAll();
        Set accountCodeSet = allAccountDOList.stream().map(AccountDO::getAccountCode).collect(Collectors.toSet());
        HashSet excelAccountCodeSet = new HashSet();
        List secOuCodeList = accountDOList.stream().map(AccountDO::getSecOuCode).collect(Collectors.toList());
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        orgOuRpcDtoParam.setOuCodes(secOuCodeList);
        List<OrgOuRpcDTO> orgOuRpcDTOList = this.rmiOrgOuRpcServiceService.findOuDtoByParam(orgOuRpcDtoParam);
        Set<String> ouCodeSet = orgOuRpcDTOList.stream().map(OrgOuRpcDTO::getOuCode).collect(Collectors.toSet());
        Map principalTypeUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.PRINCIPAL_TYPE_INVOICE.getModel(), UdcEnum.PRINCIPAL_TYPE_INVOICE.getCode());
        Collection<String> principalTypeCollection = principalTypeUdc.values();
        Map<String, String> principalTypeUdcName = principalTypeUdc.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getValue(), entry -> (String)entry.getKey(), (v1, v2) -> v1));
        List invTitleList = accountDOList.stream().map(AccountDO::getAccountHolderName).collect(Collectors.toList());
        Map finAccountTypeUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.ACCOUNT_TYPE_STORE.getModel(), UdcEnum.ACCOUNT_TYPE_STORE.getCode());
        Collection<String> finAccountTypeCollection = finAccountTypeUdc.values();
        Map<String, String> finAccountTypeUdcName = finAccountTypeUdc.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getValue(), entry -> (String)entry.getKey(), (v1, v2) -> v1));
        Pattern pattern = Pattern.compile("^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,2})?$");
        Map unionPayUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.UNION_PAY_700000000000001.getModel(), UdcEnum.UNION_PAY_700000000000001.getCode());
        Map<String, String> unionPayUdcName = unionPayUdc.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getValue(), entry -> (String)entry.getKey(), (v1, v2) -> v1));
        for (AccountDO accountDO : accountDOList) {
            ArrayList<String> errorList = new ArrayList<String>();
            this.checkImportMandatoryField(accountDO, errorList, rowId);
            this.checkDataValid(accountDO, errorList, ouCodeSet, principalTypeCollection, finAccountTypeCollection, unionPayUdc, pattern, rowId);
            if (CollectionUtils.isNotEmpty(errorList)) {
                errorResult.addAll(errorList);
            } else {
                errorResult.add(null);
                saveList.add(accountDO);
            }
            ++rowId;
        }
        if (CollectionUtils.isNotEmpty(saveList)) {
            this.saveData(saveList, finAccountTypeUdcName, principalTypeUdcName, unionPayUdcName);
            return CollectionUtil.isNotEmpty(errorResult) ? errorResult : null;
        }
        return errorResult;
    }

    private void saveData(List<AccountDO> saveList, Map<String, String> finAccountTypeUdcName, Map<String, String> principalTypeUdcName, Map<String, String> unionPayUdcName) {
        this.buildDefaultValue(saveList, finAccountTypeUdcName, principalTypeUdcName, unionPayUdcName);
        this.accountRepo.saveAll(saveList);
    }

    public void buildDefaultValue(List<AccountDO> accountDOList, Map<String, String> finAccountTypeUdcName, Map<String, String> principalTypeUdcName, Map<String, String> unionPayUdcName) {
        accountDOList.stream().forEach(item -> {
            if (StringUtils.isNotEmpty((CharSequence)item.getAccountHolderType())) {
                item.setAccountHolderType((String)principalTypeUdcName.get(item.getAccountHolderType()));
            }
            if (StringUtils.isNotEmpty((CharSequence)item.getAccountName())) {
                item.setAccountName((String)unionPayUdcName.get(item.getAccountName()));
            }
            if (StringUtils.isNotEmpty((CharSequence)item.getAccountType())) {
                item.setAccountType((String)finAccountTypeUdcName.get(item.getAccountType()));
            }
            item.setState(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        });
    }

    public void checkDataValid(AccountDO accountDO, List<String> errorList, Set<String> ouCodeSet, Collection<String> principalTypeCollection, Collection<String> finAccountTypeCollection, Map<String, String> unionPayUdc, Pattern pattern, int rowId) {
        if (StringUtils.isNotEmpty((CharSequence)accountDO.getSecOuCode()) && !ouCodeSet.contains(accountDO.getSecOuCode())) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u516c\u53f8\u7f16\u7801", "\u516c\u53f8\u7f16\u7801\u5728\u7cfb\u7edf\u4e0d\u5b58\u5728"));
        }
        if (StringUtils.isNotEmpty((CharSequence)accountDO.getAccountHolderType()) && !principalTypeCollection.contains(accountDO.getAccountHolderType())) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5f00\u6237\u4e3b\u4f53\u7c7b\u578b", "\u5f00\u6237\u4e3b\u4f53\u7c7b\u578b\u5728\u7cfb\u7edf\u4e0d\u5b58\u5728"));
        }
        if (StringUtils.isNotEmpty((CharSequence)accountDO.getAccountName()) && StrUtil.isNotBlank((CharSequence)accountDO.getAccountType()) && this.accountRepo.existsByAccountNameAndAccountType(accountDO.getAccountName(), accountDO.getAccountType())) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u540d\u79f0", "\u8d26\u6237\u540d\u79f0\u5df2\u5b58\u5728"));
        }
        if (StringUtils.isNotEmpty((CharSequence)accountDO.getAccountType()) && !finAccountTypeCollection.contains(accountDO.getAccountType())) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u7c7b\u578b", "\u8d26\u6237\u7c7b\u578b\u5728\u7cfb\u7edf\u4e0d\u5b58\u5728"));
        }
        if (accountDO.getAccountAmount() != null && !pattern.matcher(accountDO.getAccountAmount().toString()).matches()) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u91d1\u989d", "\u8d26\u6237\u91d1\u989d\u683c\u5f0f\u6709\u8bef"));
        }
        if (accountDO.getAccountOccupancyAmount() != null && !pattern.matcher(accountDO.getAccountOccupancyAmount().toString()).matches()) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u5360\u7528\u91d1\u989d", "\u8d26\u6237\u5360\u7528\u91d1\u989d\u683c\u5f0f\u6709\u8bef"));
        }
        if (accountDO.getAccountAvailableAmount() != null && !pattern.matcher(accountDO.getAccountAvailableAmount().toString()).matches()) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u53ef\u7528\u91d1\u989d", "\u8d26\u6237\u53ef\u7528\u91d1\u989d\u683c\u5f0f\u6709\u8bef"));
        }
        if (accountDO.getAccountAmount() != null && accountDO.getAccountOccupancyAmount() != null && accountDO.getAccountAvailableAmount() != null && accountDO.getAccountAmount().compareTo(accountDO.getAccountOccupancyAmount().add(accountDO.getAccountAvailableAmount())) != 0) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u91d1\u989d", "\u8d26\u6237\u91d1\u989d\u4e0d\u7b49\u4e8e\u8d26\u6237\u5360\u7528\u91d1\u989d+\u8d26\u6237\u53ef\u7528\u91d1\u989d"));
        }
        if (StrUtil.isNotBlank((CharSequence)accountDO.getAccountHolderCode()) && StrUtil.isNotBlank((CharSequence)accountDO.getSecOuCode()) && StrUtil.isNotBlank((CharSequence)accountDO.getAccountType()) && this.accountRepo.existsByAccountHolderCodeAndAccountType(accountDO.getAccountHolderCode(), accountDO.getAccountType())) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u7f16\u7801", "\u8d26\u6237\u5df2\u7ecf\u5b58\u5728"));
        }
    }

    private void checkImportRepeatAccountCode(AccountDO accountDO, List<String> errorList, Set<String> accountCodeSet, Set<String> excelAccountCodeSet, int rowId) {
        if (accountCodeSet.contains(accountDO.getAccountCode())) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u7f16\u7801", "\u8d26\u6237\u7f16\u7801\u5728\u7cfb\u7edf\u5df2\u7ecf\u5b58\u5728"));
        }
        if (StringUtils.isNotEmpty((CharSequence)accountDO.getAccountCode())) {
            if (excelAccountCodeSet.contains(accountDO.getAccountCode())) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u7f16\u7801", "\u8d26\u6237\u7f16\u7801\u91cd\u590d"));
            }
            excelAccountCodeSet.add(accountDO.getAccountCode());
        }
    }

    private void checkImportMandatoryField(AccountDO accountDO, List<String> errorList, int rowId) {
        if (StringUtils.isEmpty((CharSequence)accountDO.getSecOuCode())) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5f52\u5c5e\u516c\u53f8\u7f16\u7801", "\u5f52\u5c5e\u516c\u53f8\u7f16\u7801\u5fc5\u586b"));
        }
        if (StringUtils.isEmpty((CharSequence)accountDO.getSecFranchiseeCode())) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5f52\u5c5e\u52a0\u76df\u5546\u7f16\u7801", "\u5f52\u5c5e\u52a0\u76df\u5546\u7f16\u7801\u7f16\u7801\u5fc5\u586b"));
        }
        if (StringUtils.isEmpty((CharSequence)accountDO.getAccountHolderName())) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5f00\u6237\u4e3b\u4f53\u540d\u79f0", "\u5f00\u6237\u4e3b\u4f53\u540d\u79f0\u5fc5\u586b"));
        }
        if (StringUtils.isEmpty((CharSequence)accountDO.getAccountCode())) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u7f16\u7801", "\u8d26\u6237\u7f16\u7801\u5fc5\u586b"));
        }
        if (StringUtils.isEmpty((CharSequence)accountDO.getAccountName())) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u540d\u79f0", "\u8d26\u6237\u540d\u79f0\u5fc5\u586b"));
        }
        if (StringUtils.isEmpty((CharSequence)accountDO.getAccountType())) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u7c7b\u578b", "\u8d26\u6237\u7c7b\u578b\u5fc5\u586b"));
        }
        if (accountDO.getAccountAmount() == null) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u91d1\u989d", "\u8d26\u6237\u91d1\u989d\u5fc5\u586b"));
        }
        if (accountDO.getAccountAvailableAmount() == null) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u53ef\u7528\u91d1\u989d", "\u8d26\u6237\u53ef\u7528\u91d1\u989d\u5fc5\u586b"));
        }
        if (accountDO.getAccountOccupancyAmount() == null) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u5360\u7528\u91d1\u989d", "\u8d26\u6237\u5360\u7528\u91d1\u989d\u5fc5\u586b"));
        }
    }

    public AccountImportServiceImpl(AccountRepo accountRepo, RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService, UdcProvider udcProvider) {
        this.accountRepo = accountRepo;
        this.rmiOrgOuRpcServiceService = rmiOrgOuRpcServiceService;
        this.udcProvider = udcProvider;
    }
}

