/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.invoice.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitescloud.cloudt.common.util.RedLockUtils;
import com.elitesland.fin.application.facade.dto.mq.InvoiceRetryProcessMqMessageDTO;
import com.elitesland.fin.application.service.invoice.InvoiceService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.saleinv.SaleInvdDtlDO;
import com.elitesland.fin.infr.repo.saleinv.SaleInvdDtlRepo;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.redisson.RedissonRedLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class InvoiceRetryProcessListener
implements MessageQueueListener<InvoiceRetryProcessMqMessageDTO> {
    private static final Logger log = LoggerFactory.getLogger(InvoiceRetryProcessListener.class);
    private final RedLockUtils redLockUtils;
    private final InvoiceService invoiceService;
    private final SaleInvdDtlRepo saleInvdDtlRepo;

    @NotEmpty
    public String[] channels() {
        return new String[]{"invoice_retry_process"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConsume(@NotBlank String s, @NotNull InvoiceRetryProcessMqMessageDTO messageDTO) {
        log.info("\u5f00\u7968\u5931\u8d25\u91cd\u63a8\u63d0\u4ea4\uff1a{}", (Object)JSON.toJSONString((Object)messageDTO));
        RedissonRedLock redLock = null;
        try {
            redLock = this.redLockUtils.getRedLock("invoice_retry_process" + messageDTO.getBusinessKey());
            boolean lockFlag = redLock.tryLock(3L, 5L, TimeUnit.SECONDS);
            if (!lockFlag) {
                log.error("\u5f00\u7968\u5931\u8d25\u91cd\u63a8\u5df2\u5728\u5904\u7406\u4e2d,\u83b7\u53d6\u9501\u5931\u8d25");
                return;
            }
            List<Long> idList = messageDTO.getIdList();
            List<SaleInvdDtlDO> allById = this.saleInvdDtlRepo.findAllById(idList);
            if (CollectionUtil.isEmpty((Collection)allById)) {
                log.error("\u672a\u627e\u5230\u53d1\u7968:{}", idList);
                return;
            }
            allById = allById.stream().filter(saleInvdDtlDO -> {
                if (!saleInvdDtlDO.getInvState().equals(UdcEnum.INV_STATE_FAIL.getValueCode())) {
                    log.error("\u53d1\u7968\u4e0d\u5904\u4e8e\u5f00\u7968\u5931\u8d25\u72b6\u6001\uff0c\u8df3\u8fc7\u5904\u7406");
                    return false;
                }
                return true;
            }).sorted((o1, o2) -> o2.getTotalAmt().compareTo(o1.getTotalAmt())).toList();
            for (SaleInvdDtlDO saleInvdDtlDO2 : allById) {
                try {
                    if (Objects.equals(saleInvdDtlDO2.getRedBlueType(), UdcEnum.INV_RED_BLUE_TYPE_BLUE.getValueCode())) {
                        this.invoiceService.rePushSaleInvDDtl(List.of(saleInvdDtlDO2.getId()));
                        continue;
                    }
                    if (Objects.equals(saleInvdDtlDO2.getRedBlueType(), UdcEnum.INV_RED_BLUE_TYPE_RED.getValueCode())) {
                        this.invoiceService.getRedInvoiceResult(List.of(saleInvdDtlDO2.getId()));
                        continue;
                    }
                    log.error("\u53d1\u7968\u4e0d\u5904\u4e8e\u84dd\u3001\u7ea2\u7968\u72b6\u6001\uff0c\u8df3\u8fc7\u5904\u7406");
                }
                catch (Exception e) {
                    log.error("\u91cd\u63a8\u53d1\u7968\u65f6\u53d1\u751f\u5f02\u5e38,\u53d1\u7968\u6d41\u6c34\u53f7:{}", (Object)messageDTO.getBusinessKey(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            log.error("\u91cd\u63a8\u5931\u8d25\u53d1\u7968\u65f6\u53d1\u751f\u5f02\u5e38,\u53d1\u7968\u6d41\u6c34\u53f7:{}", (Object)messageDTO.getBusinessKey(), (Object)e);
        }
        finally {
            if (redLock != null) {
                redLock.unlock();
                log.info("\u5f00\u7968\u5931\u8d25\u91cd\u63a8\u786e\u8ba4\u5b8c\u6210\uff0c\u91ca\u653e\u9501\u6210\u529f");
            }
        }
    }

    public InvoiceRetryProcessListener(RedLockUtils redLockUtils, InvoiceService invoiceService, SaleInvdDtlRepo saleInvdDtlRepo) {
        this.redLockUtils = redLockUtils;
        this.invoiceService = invoiceService;
        this.saleInvdDtlRepo = saleInvdDtlRepo;
    }
}

