/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.service.inputinv;

import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.core.seq.SeqNumProvider;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.inputinv.InputInvConvert;
import com.elitesland.fin.application.convert.inputinv.InputInvDtlConvert;
import com.elitesland.fin.application.facade.param.inputInv.InputInvParam;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.inputinv.InputInv;
import com.elitesland.fin.domain.entity.inputinv.InputInvDO;
import com.elitesland.fin.domain.entity.inputinv.InputInvDtl;
import com.elitesland.fin.domain.entity.inputinv.InputInvDtlDO;
import com.elitesland.fin.domain.param.inputinv.InputInvPageParam;
import com.elitesland.fin.domain.service.inputinv.InputInvDomainService;
import com.elitesland.fin.infr.dto.inputinv.InputInvDTO;
import com.elitesland.fin.infr.dto.inputinv.InputInvDtlDTO;
import com.elitesland.fin.infr.factory.inputinv.InputInvFactory;
import com.elitesland.fin.infr.repo.inputinv.InputInvDtlRepo;
import com.elitesland.fin.infr.repo.inputinv.InputInvDtlRepoProc;
import com.elitesland.fin.infr.repo.inputinv.InputInvRepo;
import com.elitesland.fin.infr.repo.inputinv.InputInvRepoProc;
import com.elitesland.workflow.ProcessInfo;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InputInvDomainServiceImpl
implements InputInvDomainService {
    private final InputInvRepoProc inputInvRepoProc;
    private final InputInvRepo inputInvRepo;
    private final InputInvFactory inputInvFactory;
    private final InputInvDtlRepoProc inputInvDtlRepoProc;
    private final InputInvDtlRepo inputInvDtlRepo;
    private final SeqNumProvider sysNumberRuleService;
    private final String message = "\u5df2\u5b58\u5728\u7684\u53d1\u7968\u53f7\u7801,\u8bf7\u68c0\u67e5!";

    @Override
    public PagingVO<InputInvDTO> page(InputInvPageParam param) {
        return this.inputInvFactory.payOrderPage(param);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> deleteByIds(List<Long> ids) {
        List<InputInvDTO> inputInvDTOS = this.inputInvRepoProc.queryByIds(ids);
        inputInvDTOS.forEach(dto -> {
            if (!dto.getOrderState().equals(UdcEnum.APPLY_STATUS_DRAFT.getValueCode())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53ea\u80fd\u5220\u9664\u72b6\u6001\u4e3a\u8349\u7a3f\u7684\u8fdb\u9879\u53d1\u7968!");
            }
        });
        this.inputInvRepoProc.deleteByIds(ids);
        this.inputInvDtlRepoProc.deleteByMasId(ids);
        return ids;
    }

    @Override
    public InputInvDTO queryById(Long id, Boolean flag) {
        if (flag.booleanValue()) {
            InputInvDTO inputInvDTO = this.inputInvRepoProc.queryById(id);
            List<InputInvDtlDTO> inputInvDtlDTOS = this.inputInvDtlRepoProc.queryByMasId(id);
            inputInvDTO.setDtlDTOList(inputInvDtlDTOS);
            return inputInvDTO;
        }
        return this.inputInvRepoProc.queryById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(InputInv inputInv) {
        List<String> invNo = inputInv.getDtlList().stream().map(InputInvDtl::getInvNo).collect(Collectors.toList());
        inputInv.checkInvNo();
        inputInv.checkNotNull();
        if (inputInv.getId() != null) {
            inputInv.checkOrderState();
            Boolean aBoolean = this.inputInvDtlRepoProc.checkUpdate(invNo, inputInv.getId());
            if (aBoolean.booleanValue()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5df2\u5b58\u5728\u7684\u53d1\u7968\u53f7\u7801,\u8bf7\u68c0\u67e5!");
            }
        } else {
            Boolean aBoolean = this.inputInvDtlRepoProc.checkAdd(invNo);
            if (aBoolean.booleanValue()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5df2\u5b58\u5728\u7684\u53d1\u7968\u53f7\u7801,\u8bf7\u68c0\u67e5!");
            }
            String inputNo = this.sysNumberRuleService.generateCode("yst-fin", "JXFP", null);
            inputInv.setInvRegNo(inputNo);
        }
        inputInv.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        return this.updateOrSave(inputInv).getId();
    }

    private InputInvDO updateOrSave(InputInv inputInv) {
        InputInvDO inputInvDO = InputInvConvert.INSTANCE.convertToDo(inputInv);
        if (inputInv.getId() != null) {
            this.inputInvDtlRepoProc.deleteByMasId(List.of(inputInv.getId()));
        }
        InputInvDO save = (InputInvDO)this.inputInvRepo.save(inputInvDO);
        List<InputInvDtlDO> inputInvDtlDOS = InputInvDtlConvert.INSTANCE.convertToDO(inputInv.getDtlList());
        inputInvDtlDOS.forEach(dtl -> dtl.setMasId(save.getId()));
        this.inputInvDtlRepo.saveAll(inputInvDtlDOS);
        return save;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long submit(InputInv inputInv) {
        List<String> invNo = inputInv.getDtlList().stream().map(InputInvDtl::getInvNo).collect(Collectors.toList());
        inputInv.checkInvNo();
        inputInv.checkNotNull();
        inputInv.count();
        if (inputInv.getId() != null) {
            inputInv.checkOrderState();
            aBoolean = this.inputInvDtlRepoProc.checkUpdate(invNo, inputInv.getId());
            if (aBoolean.booleanValue()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5df2\u5b58\u5728\u7684\u53d1\u7968\u53f7\u7801,\u8bf7\u68c0\u67e5!");
            }
        } else {
            aBoolean = this.inputInvDtlRepoProc.checkAdd(invNo);
            if (aBoolean.booleanValue()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5df2\u5b58\u5728\u7684\u53d1\u7968\u53f7\u7801,\u8bf7\u68c0\u67e5!");
            }
            String inputNo = this.sysNumberRuleService.generateCode("yst-fin", "JXFP", null);
            inputInv.setInvRegNo(inputNo);
        }
        inputInv.setOrderState(UdcEnum.APPLY_STATUS_DOING.getValueCode());
        InputInvDO inputInvDO = this.updateOrSave(inputInv);
        return inputInvDO.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void approved(Long id, SysUserDTO user) {
        this.inputInvRepoProc.updateAudit(id, null, user);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void reject(InputInvParam param, SysUserDTO user) {
        this.inputInvRepoProc.updateAudit(param.getId(), param.getAuditRejection(), user);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateWorkInfo(ProcessInfo processInfo, Long resId) {
        this.inputInvRepoProc.updateWorkInfo(processInfo, resId);
    }

    @Override
    public void saveAll(List<InputInv> inputInvs) {
        if (CollectionUtils.isEmpty(inputInvs)) {
            return;
        }
        inputInvs.stream().forEach(v -> v.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode()));
        List inputInvDOS = inputInvs.stream().map(v -> {
            InputInvDO inputInvDO = InputInvConvert.INSTANCE.convertToDo((InputInv)v);
            inputInvDO.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
            return inputInvDO;
        }).collect(Collectors.toList());
        this.inputInvRepo.saveAll(inputInvDOS);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void savaApOrderNo(String createMode, String sourceNo, String apOrderNo) {
        this.inputInvRepoProc.savaApOrderNo(createMode, sourceNo, apOrderNo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeApOrderNo(String createMode, String sourceNo) {
        this.inputInvRepoProc.removeApOrderNo(createMode, sourceNo);
    }

    @Override
    public List<InputInvDTO> findAllByParam(InputInvPageParam param) {
        return this.inputInvRepoProc.findAllByParam(param);
    }

    public InputInvDomainServiceImpl(InputInvRepoProc inputInvRepoProc, InputInvRepo inputInvRepo, InputInvFactory inputInvFactory, InputInvDtlRepoProc inputInvDtlRepoProc, InputInvDtlRepo inputInvDtlRepo, SeqNumProvider sysNumberRuleService) {
        this.inputInvRepoProc = inputInvRepoProc;
        this.inputInvRepo = inputInvRepo;
        this.inputInvFactory = inputInvFactory;
        this.inputInvDtlRepoProc = inputInvDtlRepoProc;
        this.inputInvDtlRepo = inputInvDtlRepo;
        this.sysNumberRuleService = sysNumberRuleService;
    }
}

