/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.infinity.utils;

import com.elitescloud.boot.util.DatetimeUtil;
import com.elitescloud.cloudt.messenger.Messenger;
import com.elitescloud.cloudt.messenger.model.ByteMessageAttachmentVO;
import com.elitescloud.cloudt.messenger.model.MessageAccountVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.ApiOperation;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.multipart.MultipartFile;

public class MessageUtil {
    public static MultipartFile convert(String base64, String fileName, String contentType) {
        if (base64.contains(",")) {
            base64 = base64.split(",")[1];
        }
        byte[] decodedBytes = Base64.getDecoder().decode(base64);
        return new MockMultipartFile(fileName, fileName, contentType, decodedBytes);
    }

    @ApiOperation(value="\u53d1\u9001\u7b80\u5355\u90ae\u4ef6")
    @ApiOperationSupport(order=1)
    @GetMapping(value={"/email"})
    public String testSendEmail() {
        return Messenger.email().setSubject("\u7b80\u5355\u90ae\u4ef6").setContent("\u90ae\u4ef6\u5185\u5bb9\u90e8\u5206:" + DatetimeUtil.currentTimeStr()).setReceiverList(List.of(new MessageAccountVO("kaiser.wang@eliteslannd.com", "\u738b"))).setRetryableOnFailure(Boolean.valueOf(true)).setReceiptAccount("183964041@qq.com").build().send();
    }

    @ApiOperation(value="\u53d1\u9001\u5e26\u9644\u4ef6\u7684\u7b80\u5355\u90ae\u4ef6")
    @ApiOperationSupport(order=2)
    @PostMapping(value={"/email/attachment"})
    public String testSendAttachmentEmail(MultipartFile file) throws Exception {
        if (file == null || file.isEmpty()) {
            return "\u9644\u4ef6\u4e3a\u7a7a";
        }
        return Messenger.email().setSubject("\u5e26\u9644\u4ef6\u7684\u90ae\u4ef6").setContent("\u90ae\u4ef6\u5185\u5bb9\u90e8\u5206:" + DatetimeUtil.currentTimeStr()).setReceiverList(List.of(new MessageAccountVO("kaiser.wang@elitesland.com", "\u738b"))).setAttachments(List.of(new ByteMessageAttachmentVO(file.getBytes(), file.getOriginalFilename(), file.getContentType()))).build().send();
    }

    @ApiOperation(value="\u53d1\u9001html\u90ae\u4ef6")
    @ApiOperationSupport(order=3)
    @PostMapping(value={"/email/html"})
    public String testSendHtmlEmail(MultipartFile file) throws Exception {
        List attachmentVOList = file == null || file.isEmpty() ? Collections.emptyList() : List.of(new ByteMessageAttachmentVO(file.getBytes(), file.getOriginalFilename(), file.getContentType()));
        return Messenger.richTextEmail().setSubject("html\u683c\u5f0f\u7684\u90ae\u4ef6").setContent("<p style='color:red;'>\u90ae\u4ef6\u5185\u5bb9\u90e8\u5206:" + DatetimeUtil.currentTimeStr() + "</p>").setReceiverList(List.of(new MessageAccountVO("kaiser.wang@elitesland.com", "\u738b"))).setAttachments(attachmentVOList).build().send();
    }
}

