/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.provider.bip.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.common.FinPushInter;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.adjustorder.AdjustOrderDO;
import com.elitesland.fin.entity.creditaccountflow.CreditAccountFlowDO;
import com.elitesland.fin.entity.flow.AccountFlowDO;
import com.elitesland.fin.entity.push.FinPushResultDO;
import com.elitesland.fin.provider.bip.BipFinService;
import com.elitesland.fin.provider.bip.params.BipFinPaymentDTO;
import com.elitesland.fin.provider.bip.params.BipFinReceiptDTO;
import com.elitesland.fin.repo.account.AccountRepoProc;
import com.elitesland.fin.repo.adjustorder.AdjustOrderRepoProc;
import com.elitesland.fin.repo.creditaccount.CreditAccountRepoProc;
import com.elitesland.fin.repo.creditaccountflow.CreditAccountFlowRepoProc;
import com.elitesland.fin.repo.flow.AccountFlowRepoProc;
import com.elitesland.fin.repo.push.FinPushResultRepoProc;
import com.elitesland.pur.common.inter.PurInter;
import com.elitesland.pur.common.inter.PurPushRecordRepository;
import com.elitesland.pur.common.inter.bip.BipException;
import com.elitesland.pur.common.inter.bip.BipMoneyType;
import com.elitesland.pur.common.inter.bip.PurBipPushClient;
import com.elitesland.support.provider.org.dto.OrgOuBankRpcDTO;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import com.elitesland.workflow.enums.ProcInstStatus;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component
public class BipFinServiceImpl
implements BipFinService {
    private static final Logger logger = LoggerFactory.getLogger(BipFinServiceImpl.class);
    @Autowired
    private PurBipPushClient bipPushClient;
    @Autowired
    private CreditAccountFlowRepoProc creditAccountFlowRepoProc;
    @Autowired
    private AccountFlowRepoProc accountFlowRepoProc;
    @Autowired
    private AdjustOrderRepoProc adjustOrderRepoProc;
    @Autowired
    private OrgOuRpcService orgOuRpcService;
    @Autowired
    private OrgStoreRpcService orgStoreRpcService;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private FinPushResultRepoProc finPushResultRepoProc;
    @Autowired
    private PurPushRecordRepository purPushRecordRepository;
    @Autowired
    private AccountRepoProc accountRepoProc;
    @Autowired
    private CreditAccountRepoProc creditAccountRepoProc;
    @Autowired
    private UdcProvider udcProvider;

    @Override
    public ApiResult<String> pushReceiptOfSaoBeiAccountFlow(long creditAccountFlowId) {
        if (!this.bipPushClient.isEnabled()) {
            logger.info("\u672a\u542f\u7528BIP");
            return ApiResult.ok();
        }
        CreditAccountFlowDO creditAccountFlow = (CreditAccountFlowDO)((Object)this.creditAccountFlowRepoProc.get(creditAccountFlowId));
        Assert.notNull((Object)((Object)creditAccountFlow), (String)"\u6d41\u6c34\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        this.tryPush(creditAccountFlow.getId(), creditAccountFlow.getFlowNo(), FinPushInter.BIP_FIN_REC_CREDIT_ACCOUNT_FLOW_SAOBEI_SAVE, (id, docNo) -> (CreditAccountFlowDO)((Object)((Object)this.creditAccountFlowRepoProc.get((long)id))), this::supportToRecSaoBei, this::convertSaoBei);
        return ApiResult.ok();
    }

    @Override
    public ApiResult<String> pushReceiptOfStorageAccountFlow(long accountFlowId) {
        if (!this.bipPushClient.isEnabled()) {
            logger.info("\u672a\u542f\u7528BIP");
            return ApiResult.ok();
        }
        AccountFlowDO accountFlow = (AccountFlowDO)((Object)this.accountFlowRepoProc.get(accountFlowId));
        Assert.notNull((Object)((Object)accountFlow), (String)"\u6d41\u6c34\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        this.pushPaymentOfStorageAccountFlow(accountFlowId);
        this.tryPush(accountFlow.getId(), accountFlow.getFlowNo(), FinPushInter.BIP_FIN_REC_ACCOUNT_FLOW_STORAGE_SAVE, (id, docNo) -> (AccountFlowDO)((Object)((Object)this.accountFlowRepoProc.get((long)id))), this::supportToRecStorage, this::convertStorage);
        return ApiResult.ok();
    }

    @Override
    public ApiResult<String> pushReceiptOfAdjustOrder(long adjustOrderId) {
        if (!this.bipPushClient.isEnabled()) {
            logger.info("\u672a\u542f\u7528BIP");
            return ApiResult.ok();
        }
        AdjustOrderDO adjustOrder = (AdjustOrderDO)((Object)this.adjustOrderRepoProc.get(adjustOrderId));
        Assert.notNull((Object)((Object)adjustOrder), (String)"\u5355\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        this.tryPush(adjustOrder.getId(), adjustOrder.getDocNo(), FinPushInter.BIP_FIN_REC_ADJUST_ORDER_SAVE, (id, docNo) -> (AdjustOrderDO)((Object)((Object)this.adjustOrderRepoProc.get((long)id))), this::supportToRecAdjustOrder, this::convertAdjustOrder);
        return ApiResult.ok();
    }

    @Override
    public ApiResult<String> pushPaymentOfStorageAccountFlow(long accountFlowId) {
        if (!this.bipPushClient.isEnabled()) {
            logger.info("\u672a\u542f\u7528BIP");
            return ApiResult.ok();
        }
        AccountFlowDO accountFlow = (AccountFlowDO)((Object)this.accountFlowRepoProc.get(accountFlowId));
        Assert.notNull((Object)((Object)accountFlow), (String)"\u6d41\u6c34\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        this.tryPush(accountFlow.getId(), accountFlow.getFlowNo(), FinPushInter.BIP_FIN_PAY_ACCOUNT_FLOW_STORAGE_SAVE, (id, docNo) -> (AccountFlowDO)((Object)((Object)this.accountFlowRepoProc.get((long)id))), this::supportToPayStorage, this::convertPayStorage);
        return ApiResult.ok();
    }

    private BipFinPaymentDTO convertPayStorage(AccountFlowDO accountFlowDO) {
        List accountFlowBatchList = accountFlowDO.getSourceId() == null ? Collections.emptyList() : this.accountFlowRepoProc.listBySourceId(accountFlowDO.getSourceId());
        AccountFlowDO accountFlowLoan = accountFlowBatchList.isEmpty() ? null : (AccountFlowDO)accountFlowBatchList.stream().filter(t -> UdcEnum.ACCOUNT_FLOW_BUSINESS_TYPE_ITEM.getValueCode().equals(t.getBusinessType())).findFirst().orElse(null);
        BipFinPaymentDTO head = new BipFinPaymentDTO();
        ArrayList<BipFinPaymentDTO.Detail> detailList = new ArrayList<BipFinPaymentDTO.Detail>(4);
        BipFinPaymentDTO.Detail detail = new BipFinPaymentDTO.Detail();
        String storeOuCode = this.obtainStorageOuCodeByAcc(accountFlowDO.getAccountCode());
        String customerCode = this.accountRepoProc.getAccountHolderCodeByAccountCode(accountFlowDO.getAccountCode());
        String cbkAccount = null;
        if (UdcEnum.IO_TYPE_O.getValueCode().equals(accountFlowDO.getTransactionType())) {
            head.setOuCode(storeOuCode);
            cbkAccount = accountFlowDO.getFromAccountNo();
            BigDecimal amt = this.bipPushClient.formatMoney(accountFlowDO.getAmount(), BipMoneyType.AMOUNT);
            head.setAmt(amt);
            head.setAmt1(amt);
            detail.setMoney(amt);
            detail.setAmt(amt);
        } else if (UdcEnum.IO_TYPE_I.getValueCode().equals(accountFlowDO.getTransactionType())) {
            head.setOuCode(storeOuCode);
            cbkAccount = accountFlowDO.getToAccountNo();
            BigDecimal amt = this.bipPushClient.formatMoney(accountFlowDO.getAmount() == null ? null : accountFlowDO.getAmount().multiply(new BigDecimal(-1)), BipMoneyType.AMOUNT);
            head.setAmt(amt);
            head.setAmt1(amt);
            detail.setMoney(amt);
            detail.setAmt(amt);
        }
        if (customerCode != null) {
            customerCode = customerCode.trim();
        }
        head.setCustomerCode(customerCode);
        detail.setCustomerCode(customerCode);
        head.setCurrRate(BigDecimal.ONE);
        head.setCreateTime(accountFlowDO.getTransactionTime());
        head.setObjType("0");
        head.setTradeType("F3-Cxx-02");
        head.setSettleType("11");
        head.setCbkAccount(cbkAccount);
        head.setCurrCode("CNY");
        head.setCreatorRoot("ALZ");
        head.setCreator(accountFlowDO.getCreator());
        head.setDocNo(accountFlowDO.getFlowNo());
        detail.setPrepay(1);
        detail.setObjType(0);
        if (StrUtil.isNotBlank((CharSequence)accountFlowDO.getBusinessType())) {
            detail.setBusinessType((String)this.udcProvider.getValueMapByUdcCode("yst-fin", "ACCOUNT_FLOW_BUSINESS_TYPE").get(accountFlowDO.getBusinessType()));
        }
        detail.setCurrCode("CNY");
        detail.setCurrRate("1");
        detailList.add(detail);
        head.setDetailList(detailList);
        return head;
    }

    private String supportToPayStorage(AccountFlowDO accountFlowDO) {
        if (!UdcEnum.ACCOUNT_TYPE_STORE.getValueCode().equals(accountFlowDO.getAccountType())) {
            return "\u6d41\u6c34\u8d26\u6237\u7c7b\u578b\u4e0d\u652f\u6301\u63a8\u9001\uff1a" + accountFlowDO.getAccountType();
        }
        if (UdcEnum.DOC_CLS_AO.getValueCode().equals(accountFlowDO.getSourceDoc())) {
            return "\u6d41\u6c34\u6765\u6e90\u5355\u636e\u4e0d\u652f\u6301\u63a8\u9001\uff1a" + accountFlowDO.getSourceDoc();
        }
        return null;
    }

    private String obtainStorageOuCodeByAcc(String accCode) {
        String ouCode = this.accountRepoProc.getAccountHolderCodeByAccountCode(accCode);
        if (StrUtil.isBlank((CharSequence)ouCode)) {
            return null;
        }
        OrgStoreBaseRpcDTO orgStore = (OrgStoreBaseRpcDTO)this.orgStoreRpcService.findSimpleByCode(ouCode).computeData();
        return orgStore == null ? null : orgStore.getStoredOuCode();
    }

    private String obtainOrgStoreByAcc(String accCode) {
        return this.accountRepoProc.getAccountHolderCodeByAccountCode(accCode);
    }

    private BipFinReceiptDTO convertAdjustOrder(AdjustOrderDO adjustOrderDO) {
        BipFinReceiptDTO head = new BipFinReceiptDTO();
        ArrayList<BipFinReceiptDTO.Detail> detailList = new ArrayList<BipFinReceiptDTO.Detail>(4);
        BipFinReceiptDTO.Detail detail = new BipFinReceiptDTO.Detail();
        String customerCode = this.accountRepoProc.getAccountHolderCodeByAccountCode(adjustOrderDO.getAccCode());
        String ouCode = this.obtainStorageOuCodeByAcc(adjustOrderDO.getAccCode());
        OrgOuRpcSimpleDTO ou = this.queryOu(ouCode);
        Assert.notNull((Object)ou, (String)"\u50a8\u503c\u8d26\u6237\u516c\u53f8\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        head.setOuCode(ouCode);
        head.setDocDate(adjustOrderDO.getAuditTime());
        head.setObjType(0);
        if (customerCode != null) {
            customerCode = customerCode.trim();
        }
        head.setCustomerCode(customerCode);
        head.setSettleType("11");
        String receiveAccount = adjustOrderDO.getStoredBankAcc();
        head.setReceiveAccount(receiveAccount);
        head.setCbkAccount(null);
        head.setCurrCode("CNY");
        head.setCurrRate("1");
        head.setReceiptType("D2");
        head.setCreatorRoot("ALZ");
        head.setCreator(adjustOrderDO.getCreator());
        head.setDocNo(adjustOrderDO.getDocNo());
        head.setRemark(adjustOrderDO.getRemark());
        detail.setPrepay(1);
        detail.setBusinessType((String)this.udcProvider.getValueMapByUdcCode("yst-fin", UdcEnum.ACCOUNT_FLOW_BUSINESS_TYPE_ITEM.getCode()).get(UdcEnum.ACCOUNT_FLOW_BUSINESS_TYPE_ITEM.getValueCode()));
        detail.setObjType(0);
        detail.setCustomerCode(customerCode);
        detail.setCurrCode("CNY");
        detail.setReceiveAccount(receiveAccount);
        detail.setCurrRate("1");
        if (UdcEnum.ADJUST_TYPE_1.getValueCode().equals(adjustOrderDO.getAdjType())) {
            BigDecimal amt = this.bipPushClient.formatMoney(adjustOrderDO.getTotalAmt(), BipMoneyType.AMOUNT);
            head.setAmt(amt);
            head.setAmt1(amt);
            detail.setMoney(amt);
            detail.setAmt(amt);
        } else if (UdcEnum.ADJUST_TYPE_2.getValueCode().equals(adjustOrderDO.getAdjType())) {
            BigDecimal amt = this.bipPushClient.formatMoney(adjustOrderDO.getTotalAmt() == null ? null : adjustOrderDO.getTotalAmt().multiply(BigDecimal.valueOf(-1L)), BipMoneyType.AMOUNT);
            head.setAmt(amt);
            head.setAmt1(amt);
            detail.setMoney(amt);
            detail.setAmt(amt);
        }
        detail.setRootDocNo(null);
        detailList.add(detail);
        head.setDetailList(detailList);
        return head;
    }

    private String supportToRecAdjustOrder(AdjustOrderDO adjustOrderDO) {
        if (ProcInstStatus.APPROVED != adjustOrderDO.getWorkflowProcInstStatus()) {
            return "\u8c03\u6574\u5355\u5ba1\u6279\u72b6\u6001\u4e0d\u6ee1\u8db3\uff1a" + adjustOrderDO.getWorkflowProcInstStatus();
        }
        if (!UdcEnum.ACCOUNT_TYPE_STORE.getValueCode().equals(adjustOrderDO.getAccType())) {
            return "\u8c03\u6574\u5355\u8d26\u6237\u7c7b\u578b\u4e0d\u652f\u6301\uff1a" + adjustOrderDO.getAccType();
        }
        return null;
    }

    private BipFinReceiptDTO convertStorage(AccountFlowDO accountFlowDO) {
        BipFinReceiptDTO head = new BipFinReceiptDTO();
        ArrayList<BipFinReceiptDTO.Detail> detailList = new ArrayList<BipFinReceiptDTO.Detail>(4);
        BipFinReceiptDTO.Detail detail = new BipFinReceiptDTO.Detail();
        String ouCode = null;
        String customerCode = null;
        String cbkAccount = null;
        if (UdcEnum.IO_TYPE_O.getValueCode().equals(accountFlowDO.getTransactionType())) {
            ouCode = accountFlowDO.getToOuCode();
            customerCode = this.obtainOrgStoreByAcc(accountFlowDO.getAccountCode());
            cbkAccount = accountFlowDO.getToAccountNo();
            BigDecimal amt = this.bipPushClient.formatMoney(accountFlowDO.getAmount(), BipMoneyType.AMOUNT);
            head.setAmt(amt);
            head.setAmt1(amt);
            OrgOuRpcSimpleDTO toOu = this.queryOu(ouCode);
            Assert.notNull((Object)toOu, (String)"\u5165\u8d26\u516c\u53f8\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            head.setReceiptType(UdcEnum.COM_OU_TYPE_10.getValueCode().equals(toOu.getOuType()) ? "F2-Cxx-02" : "F2-Cxx-03");
            detail.setMoney(amt);
            detail.setAmt(amt);
        } else if (UdcEnum.IO_TYPE_I.getValueCode().equals(accountFlowDO.getTransactionType())) {
            ouCode = accountFlowDO.getFromOuCode();
            customerCode = this.obtainOrgStoreByAcc(accountFlowDO.getAccountCode());
            cbkAccount = accountFlowDO.getFromAccountNo();
            BigDecimal amt = this.bipPushClient.formatMoney(accountFlowDO.getAmount(), BipMoneyType.AMOUNT);
            if (amt != null) {
                amt = amt.multiply(new BigDecimal(-1));
            }
            head.setAmt(amt);
            head.setAmt1(amt);
            OrgOuRpcSimpleDTO fromOu = this.queryOu(ouCode);
            Assert.notNull((Object)fromOu, (String)"\u51fa\u8d26\u516c\u53f8\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            head.setReceiptType(UdcEnum.COM_OU_TYPE_10.getValueCode().equals(fromOu.getOuType()) ? "F2-Cxx-02" : "F2-Cxx-03");
            detail.setMoney(amt);
            detail.setAmt(amt);
        }
        if (customerCode != null) {
            customerCode = customerCode.trim();
        }
        head.setOuCode(ouCode);
        head.setCustomerCode(customerCode);
        head.setDocDate(accountFlowDO.getTransactionTime());
        head.setObjType(0);
        head.setSettleType("11");
        head.setCurrCode("CNY");
        head.setReceiveAccount("");
        head.setCbkAccount(cbkAccount);
        head.setCurrRate("1");
        head.setCreatorRoot("ALZ");
        head.setCreator(accountFlowDO.getCreator());
        head.setDocNo(accountFlowDO.getFlowNo());
        head.setRemark(accountFlowDO.getRemark());
        detail.setPrepay(1);
        if (StrUtil.isNotBlank((CharSequence)accountFlowDO.getBusinessType())) {
            detail.setBusinessType((String)this.udcProvider.getValueMapByUdcCode("yst-fin", "ACCOUNT_FLOW_BUSINESS_TYPE").get(accountFlowDO.getBusinessType()));
        }
        detail.setObjType(0);
        detail.setCustomerCode(customerCode);
        detail.setCurrCode("CNY");
        detail.setReceiveAccount("");
        detail.setCurrRate("1");
        detail.setRootDocNo(accountFlowDO.getRootDocNo());
        detailList.add(detail);
        head.setDetailList(detailList);
        return head;
    }

    private String supportToRecStorage(AccountFlowDO accountFlowDO) {
        if (!UdcEnum.ACCOUNT_TYPE_STORE.getValueCode().equals(accountFlowDO.getAccountType())) {
            return "\u8d26\u6237\u7c7b\u578b\u4e0d\u652f\u6301\uff1a" + accountFlowDO.getAccountType();
        }
        if (UdcEnum.DOC_CLS_AO.getValueCode().equals(accountFlowDO.getSourceDoc())) {
            return "\u8d26\u6237\u6d41\u6c34\u7c7b\u522b\u4e0d\u652f\u6301\uff1a" + accountFlowDO.getSourceDoc();
        }
        return null;
    }

    private BipFinReceiptDTO convertSaoBei(CreditAccountFlowDO creditAccountFlowDO) {
        BipFinReceiptDTO head = new BipFinReceiptDTO();
        ArrayList<BipFinReceiptDTO.Detail> detailList = new ArrayList<BipFinReceiptDTO.Detail>(4);
        BipFinReceiptDTO.Detail detail = new BipFinReceiptDTO.Detail();
        String ouCode = null;
        String customerCode = null;
        String cbkAccount = null;
        if (UdcEnum.CREDIT_IO_TYPE_O.getValueCode().equals(creditAccountFlowDO.getTransactionType())) {
            ouCode = creditAccountFlowDO.getToOuCode();
            customerCode = creditAccountFlowDO.getObjectCode();
            cbkAccount = creditAccountFlowDO.getToAccountNo();
            BigDecimal amt = this.bipPushClient.formatMoney(creditAccountFlowDO.getAmount(), BipMoneyType.AMOUNT);
            head.setAmt(amt);
            head.setAmt1(amt);
            OrgOuRpcSimpleDTO toOu = this.queryOu(ouCode);
            Assert.notNull((Object)toOu, (String)"\u5165\u8d26\u516c\u53f8\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            head.setReceiptType(UdcEnum.COM_OU_TYPE_10.getValueCode().equals(toOu.getOuType()) ? "F2-Cxx-02" : "F2-Cxx-03");
            detail.setMoney(amt);
        } else if (UdcEnum.CREDIT_IO_TYPE_I.getValueCode().equals(creditAccountFlowDO.getTransactionType())) {
            ouCode = creditAccountFlowDO.getFromOuCode();
            customerCode = creditAccountFlowDO.getObjectCode();
            cbkAccount = creditAccountFlowDO.getFromAccountNo();
            BigDecimal amt = this.bipPushClient.formatMoney(creditAccountFlowDO.getAmount(), BipMoneyType.AMOUNT);
            if (amt != null) {
                amt = amt.multiply(new BigDecimal(-1));
            }
            head.setAmt(amt);
            head.setAmt1(amt);
            OrgOuRpcSimpleDTO fromOu = this.queryOu(ouCode);
            Assert.notNull((Object)fromOu, (String)"\u51fa\u8d26\u516c\u53f8\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            head.setReceiptType(UdcEnum.COM_OU_TYPE_10.getValueCode().equals(fromOu.getOuType()) ? "F2-Cxx-02" : "F2-Cxx-03");
            detail.setMoney(amt);
        }
        head.setOuCode(ouCode);
        if (customerCode != null) {
            customerCode = customerCode.trim();
        }
        head.setCustomerCode(customerCode);
        head.setDocDate(creditAccountFlowDO.getTransactionTime());
        head.setObjType(0);
        head.setSettleType("10");
        head.setCurrCode("CNY");
        head.setReceiveAccount("");
        head.setCbkAccount(cbkAccount);
        head.setCurrRate("1");
        head.setCreatorRoot("ALZ");
        head.setCreator(creditAccountFlowDO.getCreator());
        head.setDocNo(creditAccountFlowDO.getFlowNo());
        head.setRemark(creditAccountFlowDO.getRemark());
        detail.setCustomerCode(customerCode);
        detail.setPrepay(1);
        if (StrUtil.isNotBlank((CharSequence)creditAccountFlowDO.getBusinessType())) {
            detail.setBusinessType((String)this.udcProvider.getValueMapByUdcCode("yst-fin", "ACCOUNT_FLOW_BUSINESS_TYPE").get(creditAccountFlowDO.getBusinessType()));
        }
        detail.setObjType(0);
        detail.setCurrCode("CNY");
        detail.setReceiveAccount("");
        detail.setCurrRate("1");
        detail.setRootDocNo(creditAccountFlowDO.getRootDocNo());
        detailList.add(detail);
        head.setDetailList(detailList);
        return head;
    }

    private String supportToRecSaoBei(CreditAccountFlowDO creditAccountFlowDO) {
        if (UdcEnum.CREDIT_IO_TYPE_O.getValueCode().equals(creditAccountFlowDO.getTransactionType())) {
            if (CharSequenceUtil.isBlank((CharSequence)creditAccountFlowDO.getFromAccountNo())) {
                return "\u51fa\u8d26\u65b9\u8d26\u6237\u4e3a\u7a7a, \u4e0d\u63a8\u9001!";
            }
            if (CharSequenceUtil.isBlank((CharSequence)creditAccountFlowDO.getToAccountNo())) {
                return "\u5165\u8d26\u65b9\u8d26\u6237\u4e3a\u7a7a, \u4e0d\u63a8\u9001!";
            }
            return null;
        }
        if (UdcEnum.CREDIT_IO_TYPE_I.getValueCode().equals(creditAccountFlowDO.getTransactionType())) {
            if (CharSequenceUtil.isBlank((CharSequence)creditAccountFlowDO.getFromAccountNo())) {
                return "\u51fa\u8d26\u65b9\u8d26\u6237\u4e3a\u7a7a, \u4e0d\u63a8\u9001!";
            }
            if (CharSequenceUtil.isBlank((CharSequence)creditAccountFlowDO.getToAccountNo())) {
                return "\u5165\u8d26\u65b9\u8d26\u6237\u4e3a\u7a7a, \u4e0d\u63a8\u9001!";
            }
            return null;
        }
        return "\u4e0d\u652f\u6301\u63a8\u9001\u7684\u4ea4\u6613\u7c7b\u578b";
    }

    private String queryOrgOuBankAcc(Long ouId) {
        List ouBankList = this.orgOuRpcService.findOuBank(ouId);
        if (CollUtil.isEmpty((Collection)ouBankList)) {
            return null;
        }
        return ouBankList.stream().filter(ouBank -> "IN".equals(ouBank.getAccType())).map(OrgOuBankRpcDTO::getBankAcc).findFirst().orElse(null);
    }

    private OrgOuRpcSimpleDTO queryOu(String ouCode) {
        if (CharSequenceUtil.isBlank((CharSequence)ouCode)) {
            return null;
        }
        List ouList = this.orgOuRpcService.findSimpleByOuCodes(List.of(ouCode));
        return CollUtil.isEmpty((Collection)ouList) ? null : (OrgOuRpcSimpleDTO)ouList.get(0);
    }

    private OrgOuRpcSimpleDTO queryOu(Long ouId) {
        if (ouId == null) {
            return null;
        }
        List ouList = this.orgOuRpcService.findSimpleOuDto(List.of(ouId));
        return CollUtil.isEmpty((Collection)ouList) ? null : (OrgOuRpcSimpleDTO)ouList.get(0);
    }

    private <T> void tryPush(final Long docId, final String docNo, FinPushInter inter, BiFunction<Long, String, T> docGetter, Function<T, String> supportPush, Function<T, Object> reqBodyConverter) {
        Assert.notNull((Object)docId, (String)"\u5355\u636eID\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)docNo, (String)"\u5355\u636e\u7f16\u53f7\u4e3a\u7a7a", (Object[])new Object[0]);
        final Supplier<Void> pusher = () -> {
            CompletableFuture.runAsync(() -> {
                Long pushResultId;
                logger.info("[{}]\u5f00\u59cb\u63a8\u9001\u5355\u636e\uff1a{}, {}", new Object[]{inter.name(), docNo, docId});
                FinPushResultDO existsRecord = this.finPushResultRepoProc.getRecord(inter.getInterCode(), docId);
                if (existsRecord != null && UdcEnum.COM_PUSH_RESULT_SUCCESS.getValueCode().equals(existsRecord.getPushResult())) {
                    logger.info("[{}]\u5355\u636e\u5df2\u63a8\u9001\u6210\u529f\uff1a{}, {}", new Object[]{inter.name(), docNo, docId});
                    return;
                }
                Long l = pushResultId = existsRecord == null ? null : existsRecord.getId();
                if (pushResultId == null) {
                    pushResultId = this.addPushResult(inter, docNo, docId);
                }
                Object data = docGetter.apply(docId, docNo);
                Object reqBody = null;
                try {
                    String noPushReason = null;
                    noPushReason = data == null ? "\u5355\u636e\u4e0d\u5b58\u5728" : (String)supportPush.apply(data);
                    if (noPushReason != null) {
                        logger.info("\u4e0d\u652f\u6301\u63a8\u9001\u7684\u5355\u636e\uff1a{}, {}, {}", new Object[]{docNo, docId, noPushReason});
                        this.finPushResultRepoProc.updatePushNoop(pushResultId, noPushReason);
                        return;
                    }
                    reqBody = reqBodyConverter.apply(data);
                }
                catch (Throwable e) {
                    logger.error("\u63a8\u9001BIP\u65f6\u53d1\u9001\u5f02\u5e38\uff1a{}, {}", new Object[]{docNo, docId, e});
                    String errorMsg = ExceptionUtil.getRootCauseMessage((Throwable)e);
                    this.finPushResultRepoProc.updatePushFail(pushResultId, errorMsg);
                    this.purPushRecordRepository.saveFailRecord((PurInter)inter, docId, docNo, errorMsg);
                    this.purPushRecordRepository.savePushRecord((PurInter)inter, docNo, docId, null, null, false, LocalDateTime.now(), null, errorMsg);
                    return;
                }
                try {
                    Long finalPushResultId = pushResultId;
                    if (reqBody instanceof Collection) {
                        AtomicInteger i = new AtomicInteger(1);
                        ((Collection)reqBody).forEach(item -> {
                            logger.info("\u63a8\u9001\u7b2c{}\u5355\uff1a", (Object)i.getAndIncrement());
                            this.bipPushClient.push((PurInter)inter, docId, docNo, item, pushRecordId -> this.finPushResultRepoProc.updatePushRecordId(finalPushResultId, (Long)pushRecordId));
                        });
                    } else {
                        this.bipPushClient.push((PurInter)inter, docId, docNo, reqBody, pushRecordId -> this.finPushResultRepoProc.updatePushRecordId(finalPushResultId, (Long)pushRecordId));
                    }
                    this.finPushResultRepoProc.updatePushSuccess(pushResultId);
                }
                catch (Throwable e) {
                    logger.error("\u63a8\u9001BIP\u65f6\u53d1\u751f\u5f02\u5e38\uff1a{}, {}", new Object[]{docNo, docId, e});
                    String expMsg = e instanceof BipException ? "[BIP\u54cd\u5e94\u9519\u8bef]:" + ((BipException)e).getMessage() : ExceptionUtil.getRootCauseMessage((Throwable)e);
                    this.finPushResultRepoProc.updatePushFail(pushResultId, expMsg);
                }
            }, (Executor)this.taskExecutor);
            return null;
        };
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    logger.info("\u4e8b\u52a1\u7ed3\u675f\uff0c\u51c6\u5907\u63a8\u9001\uff1a{}, {}", (Object)docNo, (Object)docId);
                    pusher.get();
                }
            });
        } else {
            logger.info("\u5f53\u524d\u65e0\u4e8b\u52a1, \u51c6\u5907\u63a8\u9001\uff1a{}, {}", (Object)docNo, (Object)docId);
            pusher.get();
        }
    }

    private Long addPushResult(FinPushInter inter, String docNo, Long docId) {
        FinPushResultDO resultDO = new FinPushResultDO();
        resultDO.setTargetType(inter.getTarget().name());
        resultDO.setDocType(inter.getDocType().name());
        resultDO.setDocNo(docNo);
        resultDO.setDocId(docId);
        resultDO.setInterCode(inter.getInterCode());
        resultDO.setPushResult(UdcEnum.COM_PUSH_RESULT_PUSH.getValueCode());
        resultDO.setPushTimeFirst(LocalDateTime.now());
        resultDO.setPushTimeLast(resultDO.getPushTimeFirst());
        this.finPushResultRepoProc.save((Serializable)((Object)resultDO));
        return resultDO.getId();
    }
}

