/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.utils;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.rpc.system.SystemRpcService;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

public class SysUtils {
    private static final String TECHNOLOGY_COSTS = "TECHNOLOGY_COSTS";
    private static final String OPERATING_COSTS = "OPERATING_COSTS";
    private static final String MARKETING_COSTS = "MARKETING_COSTS";
    private static Cache<String, String> orderSettingCache = Caffeine.newBuilder().maximumSize(5L).expireAfterWrite(8L, TimeUnit.HOURS).build();

    public static Integer getPricePlace() {
        SysSettingVO priceDecimalPlace = ((SystemRpcService)SpringUtil.getBean(SystemRpcService.class)).findSysSettingByNo("PRICE_DECIMAL_PLACE");
        if (priceDecimalPlace == null) {
            throw new BusinessException("\u8c03\u7528\u7cfb\u7edf\u57df\u62a5\u9519\uff1a\u83b7\u53d6\u5355\u4ef7\u5c0f\u6570\u4f4d\u6570\u62a5\u9519");
        }
        String settingVal = priceDecimalPlace.getSettingVal();
        if (StringUtils.isBlank((String)settingVal)) {
            throw new BusinessException("\u8c03\u7528\u7cfb\u7edf\u57df\u62a5\u9519\uff1a\u672a\u8bbe\u7f6e\u5355\u4ef7\u5c0f\u6570");
        }
        try {
            return Integer.parseInt(settingVal.trim());
        }
        catch (Exception e) {
            throw new BusinessException("\u8c03\u7528\u7cfb\u7edf\u57df\u62a5\u9519\uff1a\u5355\u4ef7\u5c0f\u6570\u4f4d\u4e0d\u662f\u6570\u5b57" + e.getMessage());
        }
    }

    public static Integer getAmtPlace() {
        SysSettingVO amountDecimalPlace = ((SystemRpcService)SpringUtil.getBean(SystemRpcService.class)).findSysSettingByNo("AMOUNT_DECIMAL_PLACE");
        if (amountDecimalPlace == null) {
            throw new BusinessException("\u8c03\u7528\u7cfb\u7edf\u57df\u62a5\u9519\uff1a\u83b7\u53d6\u91d1\u989d\u5c0f\u6570\u4f4d\u6570\u62a5\u9519");
        }
        String settingVal = amountDecimalPlace.getSettingVal();
        if (StringUtils.isBlank((String)settingVal)) {
            throw new BusinessException("\u8c03\u7528\u7cfb\u7edf\u57df\u62a5\u9519\uff1a\u672a\u8bbe\u7f6e\u91d1\u989d\u5c0f\u6570");
        }
        try {
            return Integer.parseInt(settingVal.trim());
        }
        catch (Exception e) {
            throw new BusinessException("\u8c03\u7528\u7cfb\u7edf\u57df\u62a5\u9519\uff1a\u91d1\u989d\u5c0f\u6570\u4f4d\u4e0d\u662f\u6570\u5b57" + e.getMessage());
        }
    }

    public static String getOptType(String sourceDocStatus) {
        if (FinConstant.ACCOUNT_FLOW_TYPE_PAY.contains(sourceDocStatus)) {
            return UdcEnum.FLOW_OPT_TYPE_PAY.getValueCode();
        }
        if (FinConstant.ACCOUNT_FLOW_TYPE_RETURN.contains(sourceDocStatus)) {
            return UdcEnum.FLOW_OPT_TYPE_RETURN.getValueCode();
        }
        if (FinConstant.ACCOUNT_FLOW_TYPE_REFUND.contains(sourceDocStatus)) {
            return UdcEnum.FLOW_OPT_TYPE_REFUND.getValueCode();
        }
        if (FinConstant.ACCOUNT_FLOW_TYPE_CLOSE.contains(sourceDocStatus)) {
            return UdcEnum.FLOW_OPT_TYPE_CLOSE.getValueCode();
        }
        if (FinConstant.ACCOUNT_FLOW_TYPE_AO_ALL.contains(sourceDocStatus)) {
            return UdcEnum.FLOW_OPT_TYPE_AO.getValueCode();
        }
        return null;
    }

    public static String getTechnologyCosts() {
        return (String)orderSettingCache.get((Object)TECHNOLOGY_COSTS, key -> {
            SysSettingVO orderSetting = ((SystemRpcService)SpringUtil.getBean(SystemRpcService.class)).findSysSettingByNo(TECHNOLOGY_COSTS);
            return orderSetting == null || StrUtil.isBlank((CharSequence)orderSetting.getSettingVal()) ? "1" : orderSetting.getSettingVal().trim();
        });
    }

    public static String getOperatingCosts() {
        return (String)orderSettingCache.get((Object)OPERATING_COSTS, key -> {
            SysSettingVO orderSetting = ((SystemRpcService)SpringUtil.getBean(SystemRpcService.class)).findSysSettingByNo(OPERATING_COSTS);
            return orderSetting == null || StrUtil.isBlank((CharSequence)orderSetting.getSettingVal()) ? "1" : orderSetting.getSettingVal().trim();
        });
    }

    public static String getMarketingCosts() {
        return (String)orderSettingCache.get((Object)MARKETING_COSTS, key -> {
            SysSettingVO orderSetting = ((SystemRpcService)SpringUtil.getBean(SystemRpcService.class)).findSysSettingByNo(MARKETING_COSTS);
            return orderSetting == null || StrUtil.isBlank((CharSequence)orderSetting.getSettingVal()) ? "1" : orderSetting.getSettingVal().trim();
        });
    }
}

