/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.utils.excel.convert;

import com.elitesland.fin.utils.excel.convert.ExcelConverterManager;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Converter<IN, OUT, BASE>
extends JsonSerializer<IN> {
    private static final Logger log = LoggerFactory.getLogger(Converter.class);
    protected volatile BASE baseValue;

    public abstract OUT convert(IN var1);

    public synchronized BASE initBaseValue() {
        return this.baseValue;
    }

    public BASE baseValue() {
        return this.baseValue;
    }

    public synchronized BASE refreshBaseValue() {
        return this.baseValue;
    }

    public void serialize(IN value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        ExcelConverterManager instance = ExcelConverterManager.instance(false);
        try {
            Converter converter = instance.getConverter(((Object)((Object)this)).getClass());
            OUT converted = converter.convert(value);
            if (converted instanceof String) {
                gen.writeString((String)converted);
            } else if (converted instanceof BigDecimal) {
                gen.writeString(((BigDecimal)converted).toPlainString());
            } else if (converted instanceof Boolean) {
                gen.writeString((Boolean)converted != false ? "\u662f" : "\u5426");
            } else {
                gen.writeString(converted.toString());
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

