package com.elitesland.fin.application.web.accountingengine;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.accountingengine.FinFlexibleValueParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinFlexibleValueVO;
import com.elitesland.fin.application.service.accountingengine.FinFlexibleValueService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * @author gyj
 * @date 2023/10/10
 */
@RestController
@RequestMapping("/fin/flexibleValue")
@RequiredArgsConstructor
@Api(value = "值集-值", tags = {"值集-值"})
public class FinFlexibleValueController {

    private final FinFlexibleValueService finFlexibleValueService;
    @PostMapping("/page")
    @ApiOperation("分页查询")
    public ApiResult<PagingVO<FinFlexibleValueVO>> page(@RequestBody FinFlexibleValueParam finFlexibleValueParam) {
        return ApiResult.ok(finFlexibleValueService.page(finFlexibleValueParam));
    }
    @PostMapping("/pageBySetOfBook")
    @ApiOperation("根据账薄编码分页查询")
    public ApiResult<PagingVO<FinFlexibleValueVO>> pageBySetOfBook(@RequestBody FinFlexibleValueParam finFlexibleValueParam) {
        return ApiResult.ok(finFlexibleValueService.pageBySetOfBook(finFlexibleValueParam));
    }
}
