package com.elitesland.fin.application.web.creditaccount;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.application.facade.param.creditaccount.CreditSettingParam;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditSettingDetailVO;
import com.elitesland.fin.application.service.creditaccount.CreditSettingService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/credit/setting")
@Api(value = "信用设置", tags = {"信用设置"})
@AllArgsConstructor
public class CreditSettingController {

    private final CreditSettingService creditSettingService;

    @GetMapping("/detail")
    @ApiOperation("信用设置-详情")
    public ApiResult<CreditSettingDetailVO> detail() {
        CreditSettingDetailVO result = creditSettingService.detail();
        return ApiResult.ok(result);
    }

    @PostMapping("/save")
    @ApiOperation("编辑信用设置")
    public ApiResult<?> saveOrUpdate(@RequestBody CreditSettingParam param) {
        val ret = creditSettingService.saveOrUpdate(param);
        return ApiResult.ok(ret);
    }
}
