package com.elitesland.fin.infinity.utils;

import com.elitescloud.boot.util.DatetimeUtil;
import com.elitescloud.cloudt.messenger.Messenger;
import com.elitescloud.cloudt.messenger.model.ByteMessageAttachmentVO;
import com.elitescloud.cloudt.messenger.model.MessageAccountVO;
import com.elitescloud.cloudt.messenger.model.MessageAttachmentVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.ApiOperation;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.multipart.MultipartFile;

import java.util.Collections;
import java.util.List;

/**
 *
 * Created by lance on 2025/10/27.
 */
public class MessageUtil {
    public static MultipartFile convert(String base64, String fileName, String contentType) {
        // 去除Base64前缀（如果有）
        if (base64.contains(",")) {
            base64 = base64.split(",")[1];
        }

        // 解码Base64字符串为字节数组
        byte[] decodedBytes = java.util.Base64.getDecoder().decode(base64);

        // 创建MockMultipartFile实例
        return new MockMultipartFile(fileName, fileName, contentType, decodedBytes);
    }

    @ApiOperation(value = "发送简单邮件")
    @ApiOperationSupport(order = 1)
    @GetMapping("/email")
    public String testSendEmail() {
        return Messenger.email()
                .setSubject("简单邮件")
                .setContent("邮件内容部分:" + DatetimeUtil.currentTimeStr())
                .setReceiverList(List.of(new MessageAccountVO("kaiser.wang@eliteslannd.com", "王")))
                .setRetryableOnFailure(true)
                .setReceiptAccount("183964041@qq.com")
                .build()
                .send();
    }

    @ApiOperation(value = "发送带附件的简单邮件")
    @ApiOperationSupport(order = 2)
    @PostMapping("/email/attachment")
    public String testSendAttachmentEmail(MultipartFile file) throws Exception {
        if (file == null || file.isEmpty()) {
            return "附件为空";
        }
        return Messenger.email()
                .setSubject("带附件的邮件")
                .setContent("邮件内容部分:" + DatetimeUtil.currentTimeStr())
                .setReceiverList(List.of(new MessageAccountVO("kaiser.wang@elitesland.com", "王")))
                .setAttachments(List.of(new ByteMessageAttachmentVO(file.getBytes(), file.getOriginalFilename(), file.getContentType())))
                .build()
                .send();
    }

    @ApiOperation(value = "发送html邮件")
    @ApiOperationSupport(order = 3)
    @PostMapping("/email/html")
    public String testSendHtmlEmail(MultipartFile file) throws Exception {
        List<MessageAttachmentVO> attachmentVOList = file == null || file.isEmpty() ? Collections.emptyList() :
                List.of(new ByteMessageAttachmentVO(file.getBytes(), file.getOriginalFilename(), file.getContentType()));
        return Messenger.richTextEmail()
                .setSubject("html格式的邮件")
                .setContent("<p style='color:red;'>邮件内容部分:" + DatetimeUtil.currentTimeStr() + "</p>")
                .setReceiverList(List.of(new MessageAccountVO("kaiser.wang@elitesland.com", "王")))
                .setAttachments(attachmentVOList)
                .build()
                .send();
    }
}
