package com.elitesland.fin.infr.repo.arorder;

import com.elitesland.fin.application.facade.dto.writeoff.ArOrderAmtUpdateDTO;
import com.elitesland.fin.domain.entity.aporder.ApOrderDtlDO;
import com.elitesland.fin.domain.entity.arorder.ArOrderDtlDO;
import com.elitesland.fin.domain.entity.arorder.ArOrderDtlRecordDO;

import java.math.BigDecimal;
import java.util.List;

import feign.Param;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.infr.repo.aporder
 * @date 2022/3/16 10:40
 */
@Repository
public interface ArOrderDtlRepo extends JpaRepository<ArOrderDtlDO, Long>, QuerydslPredicateExecutor<ArOrderDtlDO> {

    /**
     * 根据主表id查询应收单明细记录表
     * @param masId 主表id
     * @return
     */
    List<ArOrderDtlDO> findAllByMasId(Long masId);

    List<ArOrderDtlDO> findAllByMasIdIn(List<Long> masId);

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update ar_order_dtl set modify_time = CURRENT_TIMESTAMP, " +
            " audit_data_version = :version + 1, ver_amt = :verAmt, ver_amting = :verAmting, un_ver_amt = :unVerAmt where id =:arDtlId and " +
            " audit_data_version = :version and delete_flag != 1", nativeQuery = true)
    int updateExtVerAmt(@Param("arDtlId") Long arDtlId, @Param("version") Integer version
            , @Param("verAmt") BigDecimal verAmt, @Param("verAmting") BigDecimal verAmting, @Param("unVerAmt") BigDecimal unVerAmt);


}
