/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.expense;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.aporder.ApOrderConvert;
import com.elitesland.fin.application.convert.arorder.ArOrderConvert;
import com.elitesland.fin.application.convert.expense.ExpLedgerConvert;
import com.elitesland.fin.application.facade.base.BaseModelVO;
import com.elitesland.fin.application.facade.param.expense.ExpLedgeCalParam;
import com.elitesland.fin.application.facade.param.expense.ExpLedgerApproveParam;
import com.elitesland.fin.application.facade.param.expense.ExpLedgerGenApArSaveParam;
import com.elitesland.fin.application.facade.param.expense.ExpLedgerQueryParam;
import com.elitesland.fin.application.facade.param.expense.ExpLedgerSaveParam;
import com.elitesland.fin.application.facade.vo.expense.ExpLedgerDetailRespVO;
import com.elitesland.fin.application.facade.vo.expense.ExpLedgerPageVO;
import com.elitesland.fin.application.service.aporder.ApOrderService;
import com.elitesland.fin.application.service.arorder.ApArOrderService;
import com.elitesland.fin.application.service.arorder.ArOrderService;
import com.elitesland.fin.application.service.expense.ExpenseLedgerService;
import com.elitesland.fin.application.service.workflow.WorkFlowDefKey;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.aporder.ApOrder;
import com.elitesland.fin.domain.entity.aporder.ApOrderDO;
import com.elitesland.fin.domain.entity.aporder.ApOrderDtl;
import com.elitesland.fin.domain.entity.aporder.ApOrderDtlGroup;
import com.elitesland.fin.domain.entity.arorder.ArOrder;
import com.elitesland.fin.domain.entity.arorder.ArOrderDtl;
import com.elitesland.fin.domain.param.aptype.ApTypePageParam;
import com.elitesland.fin.domain.param.artype.ArTypePageParam;
import com.elitesland.fin.domain.service.aporder.ApOrderDomainService;
import com.elitesland.fin.domain.service.aptype.ApTypeDomainService;
import com.elitesland.fin.domain.service.arorder.ArOrderDomainService;
import com.elitesland.fin.domain.service.artype.ArTypeDomainService;
import com.elitesland.fin.domain.service.expense.ExpTypeDomainService;
import com.elitesland.fin.entity.expense.ExpLedgerDO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.aptype.ApTypeDTO;
import com.elitesland.fin.infr.dto.arorder.ApArOrderHandleDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.dto.artype.ArTypeDTO;
import com.elitesland.fin.infr.dto.expesne.ExpTypeDTO;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepo;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepoProc;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepo;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepoProc;
import com.elitesland.fin.repo.expense.ExpLedgerRepo;
import com.elitesland.fin.repo.expense.ExpLedgerRepoProc;
import com.elitesland.fin.rpc.pur.PurSuppOutService;
import com.elitesland.fin.rpc.sale.RmiSaleRpcService;
import com.elitesland.fin.rpc.tms.TmsOutService;
import com.elitesland.fin.rpc.workflow.WorkflowRpcService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.inv.dto.expesne.ExpenseReCalParamRpcDTO;
import com.elitesland.inv.provider.ExpenseCalServiceProvider;
import com.elitesland.inv.provider.InvTrnProvider;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcDTO;
import com.elitesland.sale.api.vo.resp.crm.CustBaseDTO;
import com.elitesland.sale.dto.param.CustBaseRpcParam;
import com.elitesland.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.support.provider.item.service.ItmItemRpcService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.tms.api.vo.TmsOuQueryParamVO;
import com.elitesland.tms.api.vo.TmsOuRespVO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
public class ExpenseLedgerServiceImpl
implements ExpenseLedgerService {
    private static final Logger log = LoggerFactory.getLogger(ExpenseLedgerServiceImpl.class);
    private final ExpLedgerRepo expLedgerRepo;
    private final ExpLedgerRepoProc expLedgerRepoProc;
    private final TmsOutService tmsOutService;
    private final PurSuppOutService purSuppOutService;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;
    private final ApTypeDomainService apTypeDomainService;
    private final ArTypeDomainService arTypeDomainService;
    private final RmiSaleRpcService rmiSaleRpcService;
    private final ArOrderService arOrderService;
    private final ApOrderService apOrderService;
    private final ArOrderDomainService arOrderDomainService;
    private final ApOrderDomainService apOrderDomainService;
    private final ArOrderRepo arOrderRepo;
    private final ApOrderRepo apOrderRepo;
    private final ArOrderRepoProc arOrderRepoProc;
    private final ApOrderRepoProc apOrderRepoProc;
    private final WorkflowRpcService workflowRpcService;
    private final ExpenseCalServiceProvider expenseCalServiceProvider;
    private final InvTrnProvider invTrnProvider;
    private final ApArOrderService apArOrderService;
    private final TransactionTemplate transactionTemplate;
    private final ExpTypeDomainService expTypeDomainService;
    private final ItmItemRpcService itmItemRpcService;

    @Override
    @SysCodeProc
    public PagingVO<ExpLedgerPageVO> searchPage(ExpLedgerQueryParam param) {
        log.info("\u8d39\u7528\u53f0\u8d26-\u5206\u9875\u67e5\u8be2\u53c2\u6570:{}", (Object)JSONUtil.toJsonStr((Object)((Object)param)));
        PagingVO<ExpLedgerPageVO> pagingVO = this.expLedgerRepoProc.searchPage(param);
        log.info("\u8d39\u7528\u53f0\u8d26-\u5206\u9875\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr(pagingVO));
        if (CollectionUtils.isEmpty((Collection)pagingVO.getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        List expLedgerPageVOList = pagingVO.getRecords();
        List<String> carrierList = expLedgerPageVOList.stream().map(ExpLedgerPageVO::getCarrier).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, TmsOuRespVO> tmsOuRespVOMap = this.tmsOutService.findTmsOuMapByCodes(carrierList);
        expLedgerPageVOList.stream().forEach(expLedgerPageVO -> {
            if (StringUtils.isBlank((CharSequence)expLedgerPageVO.getFinFlag())) {
                expLedgerPageVO.setFinFlagName("\u672a\u751f\u6210");
            } else if (Objects.equals(expLedgerPageVO.getFinFlag(), "0")) {
                expLedgerPageVO.setFinFlagName("\u672a\u751f\u6210");
            } else if (Objects.equals(expLedgerPageVO.getFinFlag(), "1")) {
                expLedgerPageVO.setFinFlagName("\u5df2\u751f\u6210");
            } else if (Objects.equals(expLedgerPageVO.getFinFlag(), "2")) {
                expLedgerPageVO.setFinFlagName("\u751f\u6210\u5931\u8d25");
            }
            TmsOuRespVO tmsOuRespVO = (TmsOuRespVO)tmsOuRespVOMap.get(expLedgerPageVO.getCarrier());
            if (Objects.nonNull(tmsOuRespVO)) {
                expLedgerPageVO.setCarrierName(tmsOuRespVO.getLogisticsOuName());
            }
        });
        return PagingVO.builder().total(pagingVO.getTotal()).records(expLedgerPageVOList).build();
    }

    @Override
    public ExpLedgerDetailRespVO detail(Long id) {
        log.info("\u8d39\u7528\u53f0\u8d26-\u8be6\u60c5\u67e5\u8be2\u53c2\u6570:{}", (Object)id);
        ExpLedgerDetailRespVO data = this.expLedgerRepoProc.detail(id);
        log.info("\u8d39\u7528\u53f0\u8d26-\u8be6\u60c5\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)data));
        return data;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void approve(ExpLedgerApproveParam param) {
        List data = this.expLedgerRepo.findAllById(param.getIds());
        data.forEach(e -> {
            e.setOrderState("APPROVED");
            e.setComment(param.getComment());
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void reject(ExpLedgerApproveParam param) {
        List data = this.expLedgerRepo.findAllById(param.getIds());
        List docNos = data.stream().map(ExpLedgerDO::getSourceDocNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ExpenseReCalParamRpcDTO paramRpcDTO = new ExpenseReCalParamRpcDTO();
        paramRpcDTO.setDocNos(docNos);
        this.invTrnProvider.updateExpFlag(paramRpcDTO);
        data.forEach(e -> {
            e.setOrderState("REJECTED");
            e.setComment(param.getComment());
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void reCal(ExpLedgeCalParam param) {
        log.info("\u91cd\u7b97\u8fd0\u8d39\u53f0\u8d26\u53c2\u6570:{}", (Object)JSONUtil.toJsonStr((Object)((Object)param)));
        List<String> docNos = param.getDocNos();
        List<ExpLedgerDO> bySourceNoList = this.expLedgerRepoProc.findBySourceNoList(docNos);
        if (CollUtil.isEmpty(bySourceNoList)) {
            log.warn("\u6ca1\u6709\u9700\u8981\u91cd\u7b97\u7684\u5355\u636e\u4fe1\u606f");
            return;
        }
        List ids = bySourceNoList.stream().map(BaseModel::getId).distinct().collect(Collectors.toList());
        ExpenseReCalParamRpcDTO expenseReCalParamRpcDTO = new ExpenseReCalParamRpcDTO();
        expenseReCalParamRpcDTO.setDocNos(docNos);
        this.expenseCalServiceProvider.reCal(expenseReCalParamRpcDTO);
        this.expLedgerRepo.deleteAllByIdInBatch(ids);
        log.info("\u91cd\u7b97\u5b8c\u6210");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(ExpLedgerSaveParam param) {
        log.info("\u751f\u6210\u8d39\u7528\u8ba1\u7b97\u53f0\u8d26\u53c2\u6570:{}", (Object)JSONUtil.toJsonStr((Object)param));
        ExpLedgerDO expLedgerDO = ExpLedgerConvert.INSTANCE.saveParam2SaveDo(param);
        this.expLedgerRepo.saveAndFlush(expLedgerDO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(List<ExpLedgerSaveParam> paramList) {
        log.info("\u751f\u6210\u8d39\u7528\u8ba1\u7b97\u53f0\u8d26\u53c2\u6570:{}", (Object)JSONUtil.toJsonStr(paramList));
        List<String> sourceNoList = paramList.stream().map(ExpLedgerSaveParam::getSourceDocNo).distinct().collect(Collectors.toList());
        this.expLedgerRepoProc.deleteBySourceNoList(sourceNoList);
        log.info("\u5148\u5220\u9664\u6765\u6e90\u5355\u636e\u7684\u5386\u53f2\u53f0\u8d26\u8bb0\u5f55");
        List<ExpLedgerDO> expLedgerDOS = ExpLedgerConvert.INSTANCE.saveParam2SaveDoBatch(paramList);
        this.expLedgerRepo.saveAllAndFlush(expLedgerDOS);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void generateApArOrder(ExpLedgerGenApArSaveParam saveParam) {
        block13: {
            log.info("\u8d39\u7528\u8ba1\u7b97\u53f0\u8d26\u751f\u6210\u5e94\u6536\u5e94\u4ed8\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)saveParam));
            this.checkGenerateApArOrder(saveParam);
            ExpLedgerQueryParam expLedgerQueryParam = new ExpLedgerQueryParam();
            expLedgerQueryParam.setOuCode(saveParam.getOuCode());
            expLedgerQueryParam.setCarrier(saveParam.getCarrier());
            expLedgerQueryParam.setExpTypeCode(saveParam.getExpTypeCode());
            expLedgerQueryParam.setSourceDocNoDateStart(saveParam.getSourceDocNoDateStart());
            expLedgerQueryParam.setSourceDocNoDateEnd(saveParam.getSourceDocNoDateEnd());
            expLedgerQueryParam.setOrderState("APPROVED");
            expLedgerQueryParam.setNotGenerateFinFlag(true);
            List<ExpLedgerPageVO> expLedgerPageVOList = this.expLedgerRepoProc.selectListByParam(expLedgerQueryParam);
            if (CollectionUtil.isEmpty(expLedgerPageVOList)) {
                return;
            }
            List carrierList = expLedgerPageVOList.stream().map(ExpLedgerPageVO::getCarrier).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            TmsOuQueryParamVO tmsOuQueryParamVO = new TmsOuQueryParamVO();
            tmsOuQueryParamVO.setLogisticsOuCodes(carrierList);
            List<TmsOuRespVO> tmsOuRespVOList = this.tmsOutService.findTmsOuList(tmsOuQueryParamVO);
            List<Long> suppIds = tmsOuRespVOList.stream().map(TmsOuRespVO::getSuppId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List<PurSuppBaseRpcDTO> purSuppBaseRpcDTOList = this.purSuppOutService.findSimpleRpcDtoBySuppId(suppIds);
            HashMap suppCodeMap = CollectionUtil.isEmpty(purSuppBaseRpcDTOList) ? new HashMap() : purSuppBaseRpcDTOList.stream().collect(Collectors.toMap(PurSuppBaseRpcDTO::getSuppCode, t -> t, (t1, t2) -> t1));
            HashMap suppIdMap = CollectionUtil.isEmpty(purSuppBaseRpcDTOList) ? new HashMap() : purSuppBaseRpcDTOList.stream().collect(Collectors.toMap(PurSuppBaseRpcDTO::getId, t -> t, (t1, t2) -> t1));
            tmsOuRespVOList.forEach(tmsOuRespVO -> {
                PurSuppBaseRpcDTO purSuppBaseRpcDTO = (PurSuppBaseRpcDTO)suppIdMap.get(tmsOuRespVO.getSuppId());
                if (Objects.nonNull(purSuppBaseRpcDTO)) {
                    tmsOuRespVO.setSuppCode(purSuppBaseRpcDTO.getSuppCode());
                    tmsOuRespVO.setSuppName(purSuppBaseRpcDTO.getSuppName());
                }
            });
            HashMap tmsOuRespVOMap = CollectionUtil.isEmpty(tmsOuRespVOList) ? new HashMap() : tmsOuRespVOList.stream().collect(Collectors.toMap(TmsOuRespVO::getLogisticsOuCode, t -> t, (t1, t2) -> t1));
            List<String> ouCodeList = expLedgerPageVOList.stream().map(ExpLedgerPageVO::getOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List<OrgOuRpcSimpleDTO> orgOuRpcSimpleDTOList = this.rmiOrgOuRpcServiceService.findBaseOuByCodes(ouCodeList);
            HashMap ouMap = CollectionUtil.isEmpty(orgOuRpcSimpleDTOList) ? new HashMap() : orgOuRpcSimpleDTOList.stream().collect(Collectors.toMap(OrgOuRpcSimpleDTO::getOuCode, t -> t, (t1, t2) -> t1));
            List<String> expTypeCodeList = expLedgerPageVOList.stream().map(ExpLedgerPageVO::getExpTypeCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List<ExpTypeDTO> expTypeDTOList = this.expTypeDomainService.getListByExpTypeCodes(expTypeCodeList);
            HashMap itmItemMap = new HashMap();
            if (CollectionUtil.isNotEmpty(expTypeDTOList)) {
                List expTypeItemCodes = expTypeDTOList.stream().map(ExpTypeDTO::getItemCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(expTypeItemCodes)) {
                    ItmItemRpcDtoParam itmItemRpcDtoParam = new ItmItemRpcDtoParam();
                    itmItemRpcDtoParam.setItemCodes(expTypeItemCodes);
                    List itmItemRpcDTOList = this.itmItemRpcService.findItemRpcDtoByParam(itmItemRpcDtoParam);
                    itmItemMap = CollectionUtil.isEmpty((Collection)itmItemRpcDTOList) ? new HashMap() : itmItemRpcDTOList.stream().collect(Collectors.toMap(ItmItemRpcDTO::getItemCode, t -> t));
                }
                for (ExpTypeDTO expTypeDTO : expTypeDTOList) {
                    ItmItemRpcDTO itmItemRpcDTO;
                    if (!Objects.nonNull(expTypeDTO.getItemCode()) || !Objects.nonNull(itmItemRpcDTO = (ItmItemRpcDTO)itmItemMap.get(expTypeDTO.getItemCode()))) continue;
                    expTypeDTO.setItemId(itmItemRpcDTO.getId());
                    expTypeDTO.setItemName(itmItemRpcDTO.getItemName());
                    expTypeDTO.setItemType(itmItemRpcDTO.getItemType());
                    expTypeDTO.setSmallCateCode(itmItemRpcDTO.getItemCateCode());
                    expTypeDTO.setSmallCateName(itmItemRpcDTO.getItemCateFullName());
                    expTypeDTO.setUom(itmItemRpcDTO.getUom());
                    expTypeDTO.setUomName(itmItemRpcDTO.getUomName());
                    expTypeDTO.setTaxCode(itmItemRpcDTO.getTaxCode());
                    expTypeDTO.setTaxRate(itmItemRpcDTO.getTaxRate());
                    expTypeDTO.setTaxCode2(itmItemRpcDTO.getTaxCode2());
                    expTypeDTO.setTaxRate2(itmItemRpcDTO.getTaxRate2());
                }
            }
            HashMap<String, ExpTypeDTO> expTypeMap = CollectionUtil.isEmpty(expTypeDTOList) ? new HashMap<String, ExpTypeDTO>() : expTypeDTOList.stream().collect(Collectors.toMap(ExpTypeDTO::getExpTypeCode, t -> t, (t1, t2) -> t1));
            String ouCode = saveParam.getOuCode();
            OrgOuRpcSimpleDTO ouRpcSimpleDTO = (OrgOuRpcSimpleDTO)ouMap.get(ouCode);
            String carrier = saveParam.getCarrier();
            TmsOuRespVO tmsOuRespVO2 = (TmsOuRespVO)tmsOuRespVOMap.get(carrier);
            if (Objects.isNull(tmsOuRespVO2)) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u7269\u6d41\u516c\u53f8\u4fe1\u606f");
            }
            String suppCode = tmsOuRespVO2.getSuppCode();
            if (StringUtils.isBlank((CharSequence)suppCode)) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7269\u6d41\u516c\u53f8\u7684\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a\u7a7a");
            }
            PurSuppBaseRpcDTO purSuppBaseRpcDTO = (PurSuppBaseRpcDTO)suppCodeMap.get(suppCode);
            if (Objects.isNull(purSuppBaseRpcDTO)) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u7269\u6d41\u516c\u53f8\u7684\u4f9b\u5e94\u5546\u4fe1\u606f");
            }
            String ioType = purSuppBaseRpcDTO.getIoType();
            if (StringUtils.isBlank((CharSequence)ioType)) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7269\u6d41\u516c\u53f8\u7684\u4f9b\u5e94\u5546\u7684\u5185\u5916\u90e8\u4e3a\u7a7a");
            }
            List<Long> allIdList = expLedgerPageVOList.stream().map(BaseModelVO::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            try {
                if (Objects.equals("INSIDE", ioType)) {
                    ArOrder arOrder = this.assembledAr(saveParam, expLedgerPageVOList, tmsOuRespVO2, expTypeMap, ouRpcSimpleDTO, purSuppBaseRpcDTO);
                    ApOrder apOrder = this.assembledAp(saveParam, expLedgerPageVOList, expTypeMap, ouRpcSimpleDTO, purSuppBaseRpcDTO);
                    this.transactionTemplate.setPropagationBehavior(3);
                    ApArOrderHandleDTO apArOrderHandleDTO = (ApArOrderHandleDTO)this.transactionTemplate.execute(transactionStatus -> {
                        try {
                            ApArOrderHandleDTO apArOrderDTO = new ApArOrderHandleDTO();
                            Long arResId = this.arOrderDomainService.newCommit(arOrder, false);
                            apArOrderDTO.setArResId(arResId);
                            Long apResId = this.apOrderDomainService.newCommit(apOrder);
                            apArOrderDTO.setApResId(apResId);
                            return apArOrderDTO;
                        }
                        catch (Exception e) {
                            log.error("\u8d39\u7528\u8ba1\u7b97\u53f0\u8d26\u751f\u6210\u5e94\u6536\u5e94\u4ed8error:", (Throwable)e);
                            transactionStatus.setRollbackOnly();
                            throw new BusinessException(ApiCode.FAIL, e.getMessage());
                        }
                    });
                    Long arResId = apArOrderHandleDTO.getArResId();
                    Long apResId = apArOrderHandleDTO.getApResId();
                    ArOrderDTO newArOrderDTO = this.arOrderRepoProc.get(arResId);
                    ArOrder newArOrder = ArOrderConvert.INSTANCE.dtoConvertToAr(newArOrderDTO);
                    this.arOrderService.startWorkFlow(newArOrder, arResId);
                    ApOrderDTO newApOrderDTO = this.apOrderRepoProc.get(apResId);
                    ApOrder newApOrder = ApOrderConvert.INSTANCE.dtoConvertToAr(newApOrderDTO);
                    this.apOrderService.startWorkFlow(newApOrder, apResId);
                    this.arOrderDomainService.updateSourceNo(newApOrderDTO.getApOrderNo(), arResId);
                    this.apOrderDomainService.updateSourceNo(newArOrderDTO.getArOrderNo(), apResId);
                    this.expLedgerRepoProc.updateFinFlagByIds(allIdList, "1");
                    break block13;
                }
                if (Objects.equals("OUTSIDE", ioType)) {
                    ApOrder apOrder = this.assembledAp(saveParam, expLedgerPageVOList, expTypeMap, ouRpcSimpleDTO, purSuppBaseRpcDTO);
                    Long apResId = this.apOrderDomainService.commit(apOrder);
                    ApOrderDO newApOrderDO = (ApOrderDO)this.apOrderRepo.findById(apResId).get();
                    ApOrder newApOrder = ApOrderConvert.INSTANCE.convert(newApOrderDO);
                    if (newApOrder.getProcInstId() == null || WorkflowConstant.CAN_START_PROC_STATUSES.contains(newApOrder.getProcInstStatus())) {
                        String procInstName = "\u5e94\u4ed8\u5355\u5ba1\u6838-" + newApOrder.getApOrderNo();
                        String procKey = WorkFlowDefKey.FIN_AP_ORDER.name();
                        ProcessInfo processInfo = this.workflowRpcService.startProcess(procKey, procInstName, apResId.toString(), new HashMap<String, Object>());
                        this.apOrderDomainService.updateWorkInfo(processInfo, apResId);
                    }
                    this.expLedgerRepoProc.updateFinFlagByIds(allIdList, "1");
                    break block13;
                }
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7269\u6d41\u516c\u53f8\u7684\u4f9b\u5e94\u5546\u7684\u5185\u5916\u90e8\u7c7b\u578b\u4e0d\u5339\u914d");
            }
            catch (Exception e) {
                log.error("\u8d39\u7528\u8ba1\u7b97\u53f0\u8d26\u751f\u6210\u5e94\u6536\u5e94\u4ed8\u53d1\u751f\u9519\u8bef,\u9519\u8bef\u539f\u56e0: {}", (Object)e.getMessage());
                this.expLedgerRepoProc.updateFinFlagByIds(allIdList, "2");
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8d39\u7528\u8ba1\u7b97\u53f0\u8d26\u751f\u6210\u5e94\u6536\u5e94\u4ed8\u53d1\u751f\u9519\u8bef,\u9519\u8bef\u539f\u56e0:" + e.getMessage());
            }
        }
    }

    private ApOrder assembledAp(ExpLedgerGenApArSaveParam saveParam, List<ExpLedgerPageVO> expLedgerPageVOList, Map<String, ExpTypeDTO> expTypeMap, OrgOuRpcSimpleDTO ouRpcSimpleDTO, PurSuppBaseRpcDTO purSuppBaseRpcDTO) {
        if (Objects.isNull(ouRpcSimpleDTO)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u9500\u552e\u516c\u53f8\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (Objects.isNull(purSuppBaseRpcDTO)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7269\u6d41\u516c\u53f8\u7684\u4f9b\u5e94\u5546\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        ApOrder apOrder = new ApOrder();
        apOrder.setId(null);
        apOrder.setSourceNo(null);
        apOrder.setApOrderNo(null);
        apOrder.setOuCode(ouRpcSimpleDTO.getOuCode());
        apOrder.setOuId(ouRpcSimpleDTO.getId());
        apOrder.setOuName(ouRpcSimpleDTO.getOuName());
        apOrder.setCreateMode("EXP");
        ApTypePageParam apTypeParam = new ApTypePageParam();
        apTypeParam.setApTypeCode("YFD02_SYS");
        List<ApTypeDTO> apTypeDTOList = this.apTypeDomainService.selectMatchByParam(apTypeParam);
        if (CollectionUtil.isEmpty(apTypeDTOList)) {
            throw new BusinessException("\u672a\u5339\u914d\u5230\u5e94\u4ed8\u5355\u7c7b\u578b\u914d\u7f6e(YFD02_SYS)");
        }
        if (CollectionUtil.isNotEmpty(apTypeDTOList) && apTypeDTOList.size() > 1) {
            throw new BusinessException("\u5339\u914d\u5230\u591a\u6761\u5e94\u4ed8\u5355\u7c7b\u578b\u7684\u914d\u7f6e\u89c4\u5219(YFD02_SYS)");
        }
        ApTypeDTO apTypeDTO = apTypeDTOList.get(0);
        apOrder.setApTypeId(apTypeDTO.getId());
        apOrder.setApTypeCode(apTypeDTO.getApTypeCode());
        apOrder.setApTypeName(apTypeDTO.getApTypeName());
        Boolean isAuto = false;
        if (isAuto.booleanValue()) {
            apOrder.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
        } else {
            apOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        }
        apOrder.setBuDate(LocalDateTime.now());
        apOrder.setCurrCode("CNY");
        apOrder.setCurrName("\u4eba\u6c11\u5e01");
        apOrder.setExchangeRate(BigDecimal.ONE);
        apOrder.setTaxFlag(true);
        apOrder.setInitFlag(false);
        apOrder.setSuppId(purSuppBaseRpcDTO.getId());
        apOrder.setSuppCode(purSuppBaseRpcDTO.getSuppCode());
        apOrder.setSuppName(purSuppBaseRpcDTO.getSuppName());
        apOrder.setInOutCust(purSuppBaseRpcDTO.getIoType());
        apOrder.setRelevanceOuCode(null);
        if (Objects.equals(purSuppBaseRpcDTO.getSuppType2(), "INNER")) {
            apOrder.setRelevanceOuCode(purSuppBaseRpcDTO.getOuCode2());
        }
        apOrder.setBuId(null);
        apOrder.setBuCode(null);
        apOrder.setBuName(null);
        apOrder.setBuType(null);
        apOrder.setPayMentName(null);
        apOrder.setPayMentId(null);
        apOrder.setPayMentCode(null);
        apOrder.setProtocolCode(purSuppBaseRpcDTO.getProtocolCode());
        apOrder.setTaxRate(null);
        apOrder.setLocalCurrCode("CNY");
        apOrder.setLocalCurrName("\u4eba\u6c11\u5e01");
        apOrder.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
        apOrder.setVerAmt(BigDecimal.ZERO);
        String addrNo = Objects.isNull(purSuppBaseRpcDTO.getAddrNo()) ? null : String.valueOf(purSuppBaseRpcDTO.getAddrNo());
        apOrder.setAddrNo(addrNo);
        apOrder.setSuppAddrNo(addrNo);
        apOrder.setRemark(saveParam.getRemark());
        apOrder.setAuditUserId(null);
        apOrder.setAuditUser(null);
        apOrder.setAuditDate(null);
        apOrder.setOperUserId(null);
        apOrder.setOperator(null);
        apOrder.setAuditRejection(null);
        apOrder.setProcInstId(null);
        apOrder.setProcInstStatus(null);
        apOrder.setSubmitTime(null);
        apOrder.setApprovedTime(null);
        apOrder.setCreateUserId(null);
        apOrder.setCreator(null);
        apOrder.setCreateTime(null);
        List<ApOrderDtl> apOrderDtlList = this.assembledApDtl(apOrder, expLedgerPageVOList, null, expTypeMap);
        apOrder.setApOrderDtlList(apOrderDtlList);
        BigDecimal totalAmt = apOrderDtlList.stream().map(ApOrderDtl::getTotalAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal exclTaxAmt = apOrderDtlList.stream().map(ApOrderDtl::getExclTaxAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal taxAmt = apOrderDtlList.stream().map(ApOrderDtl::getTaxAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalCurAmt = apOrderDtlList.stream().map(ApOrderDtl::getTotalCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal exclTaxCurAmt = apOrderDtlList.stream().map(ApOrderDtl::getExclTaxCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal taxCurAmt = apOrderDtlList.stream().map(ApOrderDtl::getTaxCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        apOrder.setTotalAmt(totalAmt);
        apOrder.setExclTaxAmt(exclTaxAmt);
        apOrder.setTaxAmt(taxAmt);
        apOrder.setTotalCurAmt(totalCurAmt);
        apOrder.setExclTaxCurAmt(exclTaxCurAmt);
        apOrder.setTaxCurAmt(taxCurAmt);
        List<ApOrderDtlGroup> apOrderDtlGroups = this.genApDtlGroup(apOrder);
        apOrder.setApOrderDtlGroupList(apOrderDtlGroups);
        return apOrder;
    }

    private List<ApOrderDtl> assembledApDtl(ApOrder apOrder, List<ExpLedgerPageVO> expLedgerPageVOList, Long masId, Map<String, ExpTypeDTO> expTypeMap) {
        List<ApOrderDtl> apOrderDtlList = expLedgerPageVOList.stream().map(expLedgerPageVO -> {
            ApOrderDtl apOrderDtl = new ApOrderDtl();
            apOrderDtl.setMasId(masId);
            apOrderDtl.setSourceNo(expLedgerPageVO.getSourceDocNo());
            apOrderDtl.setSourceLine(null);
            if (Objects.equals(expLedgerPageVO.getExpTypeCode(), UdcEnum.FIN_EXPENSES_TYPE_WLF.getValueCode())) {
                ExpTypeDTO expTypeDTO = (ExpTypeDTO)expTypeMap.get(expLedgerPageVO.getExpTypeCode());
                apOrderDtl.setItemId(10001L);
                apOrderDtl.setItemCode("WLXNSPCODE");
                apOrderDtl.setItemName("\u7269\u6d41\u865a\u62df\u5546\u54c1");
                if (Objects.nonNull(expTypeDTO)) {
                    apOrderDtl.setItemId(expTypeDTO.getItemId());
                    apOrderDtl.setItemCode(expTypeDTO.getItemCode());
                    apOrderDtl.setItemName(expTypeDTO.getItemName());
                    apOrderDtl.setItemType(expTypeDTO.getItemType());
                    apOrderDtl.setSmallCateCode(expTypeDTO.getSmallCateCode());
                    apOrderDtl.setSmallCateName(expTypeDTO.getSmallCateName());
                    apOrderDtl.setUom(expTypeDTO.getUom());
                    apOrderDtl.setUomName(expTypeDTO.getUomName());
                    apOrderDtl.setTaxRate(expTypeDTO.getTaxRate());
                }
            }
            if (Objects.nonNull(expLedgerPageVO.getAmt()) && expLedgerPageVO.getAmt().compareTo(BigDecimal.ZERO) == -1) {
                apOrderDtl.setExclTaxPrice(expLedgerPageVO.getAmt().abs());
                apOrderDtl.setPrice(expLedgerPageVO.getAmt().abs());
                apOrderDtl.setQty(BigDecimal.ONE.negate());
            } else {
                apOrderDtl.setExclTaxPrice(expLedgerPageVO.getAmt());
                apOrderDtl.setPrice(expLedgerPageVO.getAmt());
                apOrderDtl.setQty(BigDecimal.ONE);
            }
            apOrderDtl.setTotalAmt(expLedgerPageVO.getAmt());
            apOrderDtl.setExclTaxAmt(expLedgerPageVO.getNetAmt());
            apOrderDtl.setTaxAmt(expLedgerPageVO.getTaxAmt());
            apOrderDtl.setTotalCurAmt(expLedgerPageVO.getAmt());
            apOrderDtl.setExclTaxCurAmt(expLedgerPageVO.getNetAmt());
            apOrderDtl.setTaxCurAmt(expLedgerPageVO.getTaxAmt());
            apOrderDtl.setRemark(expLedgerPageVO.getRemark());
            apOrderDtl.setCreateUserId(null);
            apOrderDtl.setCreator(null);
            apOrderDtl.setCreateTime(null);
            apOrderDtl.setSourceNoDid(null);
            apOrderDtl.setProtocolCode(apOrder.getProtocolCode());
            return apOrderDtl;
        }).collect(Collectors.toList());
        return apOrderDtlList;
    }

    public List<ApOrderDtlGroup> genApDtlGroup(ApOrder apOrder) {
        List<ApOrderDtl> res = apOrder.getApOrderDtlList();
        Map<String, List<ApOrderDtl>> collectMaps = res.stream().collect(Collectors.groupingBy(ApOrderDtl::getItemCode));
        ArrayList<ApOrderDtlGroup> resList = new ArrayList<ApOrderDtlGroup>();
        for (Map.Entry<String, List<ApOrderDtl>> entry : collectMaps.entrySet()) {
            ApOrderDtlGroup apOrderDtlGroup = new ApOrderDtlGroup();
            List<ApOrderDtl> apOrderDtlList = entry.getValue();
            BigDecimal qtySum = apOrderDtlList.stream().map(ApOrderDtl::getQty).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal taxAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getTaxAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal taxCurAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getTaxCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal exclTaxAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getExclTaxAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal exclTaxCurAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getExclTaxCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getTotalAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalCurAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getTotalCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            apOrderDtlGroup.setItemId(apOrderDtlList.get(0).getItemId());
            apOrderDtlGroup.setItemCode(apOrderDtlList.get(0).getItemCode());
            apOrderDtlGroup.setItemName(apOrderDtlList.get(0).getItemName());
            apOrderDtlGroup.setSmallCateCode(apOrderDtlList.get(0).getSmallCateCode());
            apOrderDtlGroup.setSmallCateName(apOrderDtlList.get(0).getSmallCateName());
            apOrderDtlGroup.setQty(qtySum);
            apOrderDtlGroup.setTotalAmt(totalAmtSum);
            apOrderDtlGroup.setExclTaxAmt(exclTaxAmtSum);
            apOrderDtlGroup.setTaxAmt(taxAmtSum);
            apOrderDtlGroup.setTotalCurAmt(totalCurAmtSum);
            apOrderDtlGroup.setExclTaxCurAmt(exclTaxCurAmtSum);
            apOrderDtlGroup.setTaxCurAmt(taxCurAmtSum);
            resList.add(apOrderDtlGroup);
        }
        return resList;
    }

    private ArOrder assembledAr(ExpLedgerGenApArSaveParam saveParam, List<ExpLedgerPageVO> expLedgerPageVOList, TmsOuRespVO tmsOuRespVO, Map<String, ExpTypeDTO> expTypeMap, OrgOuRpcSimpleDTO ouRpcSimpleDTO, PurSuppBaseRpcDTO purSuppBaseRpcDTO) {
        if (Objects.isNull(tmsOuRespVO)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7269\u6d41\u516c\u53f8\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        CustBaseRpcParam custBaseRpcParam = new CustBaseRpcParam();
        custBaseRpcParam.setCorBusinCodes(Arrays.asList(saveParam.getOuCode()));
        List<CustBaseDTO> baseCustByParam = this.rmiSaleRpcService.findBaseCustByParam(custBaseRpcParam);
        if (CollUtil.isEmpty(baseCustByParam)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u9500\u552e\u516c\u53f8\u7684\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        CustBaseDTO custBaseDTO = baseCustByParam.get(0);
        ArOrder arOrder = new ArOrder();
        arOrder.setSourceNo(null);
        arOrder.setArOrderNo(null);
        arOrder.setOuCode(tmsOuRespVO.getLogisticsOuCode());
        arOrder.setOuId(tmsOuRespVO.getId());
        arOrder.setOuName(tmsOuRespVO.getLogisticsOuName());
        arOrder.setCreateMode("EXP");
        ArTypePageParam arTypePageParam = new ArTypePageParam();
        arTypePageParam.setArTypeCode("YSD02_SYS");
        List<ArTypeDTO> arTypeDTOList = this.arTypeDomainService.selectMatchByParam(arTypePageParam);
        if (CollectionUtil.isEmpty(arTypeDTOList)) {
            throw new BusinessException("\u672a\u5339\u914d\u5230\u5e94\u6536\u5355\u7c7b\u578b\u914d\u7f6e(YSD02_SYS)");
        }
        if (CollectionUtil.isNotEmpty(arTypeDTOList) && arTypeDTOList.size() > 1) {
            throw new BusinessException("\u5339\u914d\u5230\u591a\u6761\u5e94\u6536\u5355\u7c7b\u578b\u7684\u914d\u7f6e\u89c4\u5219(YSD02_SYS)");
        }
        ArTypeDTO arTypeDTO = arTypeDTOList.get(0);
        arOrder.setArTypeId(arTypeDTO.getId());
        arOrder.setArTypeCode(arTypeDTO.getArTypeCode());
        arOrder.setArTypeName(arTypeDTO.getArTypeName());
        Boolean isAuto = false;
        if (isAuto.booleanValue()) {
            arOrder.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
        } else {
            arOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        }
        arOrder.setBuDate(LocalDateTime.now());
        arOrder.setCurrCode("CNY");
        arOrder.setCurrName("\u4eba\u6c11\u5e01");
        arOrder.setLocalCurrCode("CNY");
        arOrder.setLocalCurrName("\u4eba\u6c11\u5e01");
        arOrder.setExchangeRate(BigDecimal.ONE);
        arOrder.setTaxFlag(true);
        arOrder.setInitFlag(false);
        arOrder.setCustId(custBaseDTO.getId());
        arOrder.setCustCode(custBaseDTO.getCustCode());
        arOrder.setCustName(custBaseDTO.getCustName());
        arOrder.setInOutCust(custBaseDTO.getInOutCust());
        arOrder.setRelevanceOuCode(null);
        if (Objects.equals(custBaseDTO.getCustType2(), "C")) {
            arOrder.setRelevanceOuCode(custBaseDTO.getCorBusinCode());
        }
        arOrder.setBuId(null);
        arOrder.setBuCode(null);
        arOrder.setBuName(null);
        arOrder.setBuType(null);
        arOrder.setProtocolCode(custBaseDTO.getPaymentTerm());
        arOrder.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
        arOrder.setVerAmt(BigDecimal.ZERO);
        arOrder.setOrgId(null);
        arOrder.setOrgCode(null);
        arOrder.setOrgName(null);
        arOrder.setSaleUserId(null);
        arOrder.setSaleUser(null);
        arOrder.setArOrderType("EXP");
        arOrder.setDocType(null);
        arOrder.setDocType2(null);
        arOrder.setDocCls(null);
        arOrder.setRemark(saveParam.getRemark());
        arOrder.setAuditUserId(null);
        arOrder.setAuditUser(null);
        arOrder.setAuditDate(null);
        arOrder.setOperUserId(null);
        arOrder.setOperator(null);
        arOrder.setAuditRejection(null);
        arOrder.setProcInstId(null);
        arOrder.setProcInstStatus(null);
        arOrder.setSubmitTime(null);
        arOrder.setApprovedTime(null);
        arOrder.setCreateUserId(null);
        arOrder.setCreator(null);
        arOrder.setCreateTime(null);
        arOrder.setSettlementType(null);
        arOrder.setEs1(null);
        arOrder.setEs2(null);
        arOrder.setEs3(null);
        arOrder.setEs4(null);
        arOrder.setEs5(null);
        arOrder.setEs6(null);
        arOrder.setDocType(null);
        List<ArOrderDtl> arOrderDtlList = this.assembledArDtl(arOrder, expLedgerPageVOList, null, expTypeMap);
        arOrder.setDtlList(arOrderDtlList);
        BigDecimal totalAmt = arOrderDtlList.stream().map(ArOrderDtl::getTotalAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal exclTaxAmt = arOrderDtlList.stream().map(ArOrderDtl::getExclTaxAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal taxAmt = arOrderDtlList.stream().map(ArOrderDtl::getTaxAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalCurAmt = arOrderDtlList.stream().map(ArOrderDtl::getTotalCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal exclTaxCurAmt = arOrderDtlList.stream().map(ArOrderDtl::getExclTaxCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal taxCurAmt = arOrderDtlList.stream().map(ArOrderDtl::getTaxCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        arOrder.setTotalAmt(totalAmt);
        arOrder.setExclTaxAmt(exclTaxAmt);
        arOrder.setTaxAmt(taxAmt);
        arOrder.setTotalCurAmt(totalCurAmt);
        arOrder.setExclTaxCurAmt(exclTaxCurAmt);
        arOrder.setTaxCurAmt(taxCurAmt);
        return arOrder;
    }

    private List<ArOrderDtl> assembledArDtl(ArOrder arOrder, List<ExpLedgerPageVO> expLedgerPageVOList, Long masId, Map<String, ExpTypeDTO> expTypeMap) {
        List<ArOrderDtl> arOrderDtlList = expLedgerPageVOList.stream().map(expLedgerPageVO -> {
            ArOrderDtl arOrderDtl = new ArOrderDtl();
            arOrderDtl.setId(null);
            arOrderDtl.setMasId(masId);
            arOrderDtl.setSourceNo(expLedgerPageVO.getSourceDocNo());
            arOrderDtl.setSourceLine(null);
            if (Objects.equals(expLedgerPageVO.getExpTypeCode(), UdcEnum.FIN_EXPENSES_TYPE_WLF.getValueCode())) {
                ExpTypeDTO expTypeDTO = (ExpTypeDTO)expTypeMap.get(expLedgerPageVO.getExpTypeCode());
                arOrderDtl.setItemId(10001L);
                arOrderDtl.setItemCode("WLXNSPCODE");
                arOrderDtl.setItemName("\u7269\u6d41\u865a\u62df\u5546\u54c1");
                if (Objects.nonNull(expTypeDTO)) {
                    arOrderDtl.setItemId(expTypeDTO.getItemId());
                    arOrderDtl.setItemCode(expTypeDTO.getItemCode());
                    arOrderDtl.setItemName(expTypeDTO.getItemName());
                    arOrderDtl.setItemType(expTypeDTO.getItemType());
                    arOrderDtl.setSmallCateCode(expTypeDTO.getSmallCateCode());
                    arOrderDtl.setSmallCateName(expTypeDTO.getSmallCateName());
                    arOrderDtl.setUom(expTypeDTO.getUom());
                    arOrderDtl.setUomName(expTypeDTO.getUomName());
                    arOrderDtl.setTaxRate(expTypeDTO.getTaxRate2());
                }
            }
            if (Objects.nonNull(expLedgerPageVO.getAmt()) && expLedgerPageVO.getAmt().compareTo(BigDecimal.ZERO) == -1) {
                arOrderDtl.setExclTaxPrice(expLedgerPageVO.getAmt().abs());
                arOrderDtl.setPrice(expLedgerPageVO.getAmt().abs());
                arOrderDtl.setQty(BigDecimal.ONE.negate());
            } else {
                arOrderDtl.setExclTaxPrice(expLedgerPageVO.getAmt());
                arOrderDtl.setPrice(expLedgerPageVO.getAmt());
                arOrderDtl.setQty(BigDecimal.ONE);
            }
            arOrderDtl.setTotalAmt(expLedgerPageVO.getAmt());
            arOrderDtl.setExclTaxAmt(expLedgerPageVO.getNetAmt());
            arOrderDtl.setTaxAmt(expLedgerPageVO.getTaxAmt());
            arOrderDtl.setTotalCurAmt(expLedgerPageVO.getAmt());
            arOrderDtl.setExclTaxCurAmt(expLedgerPageVO.getNetAmt());
            arOrderDtl.setTaxCurAmt(expLedgerPageVO.getTaxAmt());
            arOrderDtl.setBuCode(null);
            arOrderDtl.setBuId(null);
            arOrderDtl.setBuName(null);
            arOrderDtl.setExpensesType(expLedgerPageVO.getExpTypeCode());
            arOrder.setSaleUserId(null);
            arOrder.setSaleUser(null);
            arOrder.setCurrCode("CNY");
            arOrder.setCurrName("\u4eba\u6c11\u5e01");
            arOrder.setExchangeRate(BigDecimal.ONE);
            arOrderDtl.setCreateUserId(null);
            arOrderDtl.setCreator(null);
            arOrderDtl.setCreateTime(null);
            arOrderDtl.setEs11(null);
            arOrderDtl.setEs12(null);
            arOrderDtl.setEs13(null);
            arOrderDtl.setEs14(null);
            arOrderDtl.setEs15(null);
            arOrderDtl.setEs16(null);
            arOrderDtl.setEs17(null);
            arOrderDtl.setEs18(null);
            arOrderDtl.setEs19(null);
            arOrderDtl.setProtocolCode(arOrder.getProtocolCode());
            arOrderDtl.setEs20(null);
            arOrderDtl.setEs21(null);
            arOrderDtl.setEs22(null);
            arOrderDtl.setEs23(null);
            arOrderDtl.setEs24(null);
            arOrderDtl.setRelateId(null);
            return arOrderDtl;
        }).collect(Collectors.toList());
        return arOrderDtlList;
    }

    private void checkGenerateApArOrder(ExpLedgerGenApArSaveParam saveParam) {
        if (StringUtils.isBlank((CharSequence)saveParam.getExpTypeCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8d39\u7528\u7c7b\u578b\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)saveParam.getOuCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u9500\u552e\u516c\u53f8\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)saveParam.getCarrier())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7269\u6d41\u516c\u53f8\u7f16\u7801\u4e3a\u7a7a");
        }
        if (Objects.isNull(saveParam.getSourceDocNoDateStart())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5355\u636e\u65e5\u671f\u5f00\u59cb\u4e3a\u7a7a");
        }
        if (Objects.isNull(saveParam.getSourceDocNoDateEnd())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5355\u636e\u65e5\u671f\u7ed3\u675f\u4e3a\u7a7a");
        }
    }

    public ExpenseLedgerServiceImpl(ExpLedgerRepo expLedgerRepo, ExpLedgerRepoProc expLedgerRepoProc, TmsOutService tmsOutService, PurSuppOutService purSuppOutService, RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService, ApTypeDomainService apTypeDomainService, ArTypeDomainService arTypeDomainService, RmiSaleRpcService rmiSaleRpcService, ArOrderService arOrderService, ApOrderService apOrderService, ArOrderDomainService arOrderDomainService, ApOrderDomainService apOrderDomainService, ArOrderRepo arOrderRepo, ApOrderRepo apOrderRepo, ArOrderRepoProc arOrderRepoProc, ApOrderRepoProc apOrderRepoProc, WorkflowRpcService workflowRpcService, ExpenseCalServiceProvider expenseCalServiceProvider, InvTrnProvider invTrnProvider, ApArOrderService apArOrderService, TransactionTemplate transactionTemplate, ExpTypeDomainService expTypeDomainService, ItmItemRpcService itmItemRpcService) {
        this.expLedgerRepo = expLedgerRepo;
        this.expLedgerRepoProc = expLedgerRepoProc;
        this.tmsOutService = tmsOutService;
        this.purSuppOutService = purSuppOutService;
        this.rmiOrgOuRpcServiceService = rmiOrgOuRpcServiceService;
        this.apTypeDomainService = apTypeDomainService;
        this.arTypeDomainService = arTypeDomainService;
        this.rmiSaleRpcService = rmiSaleRpcService;
        this.arOrderService = arOrderService;
        this.apOrderService = apOrderService;
        this.arOrderDomainService = arOrderDomainService;
        this.apOrderDomainService = apOrderDomainService;
        this.arOrderRepo = arOrderRepo;
        this.apOrderRepo = apOrderRepo;
        this.arOrderRepoProc = arOrderRepoProc;
        this.apOrderRepoProc = apOrderRepoProc;
        this.workflowRpcService = workflowRpcService;
        this.expenseCalServiceProvider = expenseCalServiceProvider;
        this.invTrnProvider = invTrnProvider;
        this.apArOrderService = apArOrderService;
        this.transactionTemplate = transactionTemplate;
        this.expTypeDomainService = expTypeDomainService;
        this.itmItemRpcService = itmItemRpcService;
    }
}

