package com.elitesland.fin.application.facade.vo.accountingengine;

import com.elitesland.fin.application.facade.base.BaseModelParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Data
@ApiModel(description = "凭证")
public class FinJournalVO extends BaseModelParam {

    @ApiModelProperty("单据编码")
    private String docNum;

    @ApiModelProperty("单据类型")
    private String docType;

    @ApiModelProperty("来源系统编码")
    private String systemSourceCode;

    @ApiModelProperty("来源系统名称")
    private String systemSourceName;

    @ApiModelProperty("凭证编码")
    private String voucherTypeCode;

    @ApiModelProperty("凭证类型")
    private String voucherTypeName;

    @ApiModelProperty("核算维度1")
    private String segment1;

    @ApiModelProperty("核算维度2")
    private String segment2;

    @ApiModelProperty("核算维度3")
    private String segment3;

    @ApiModelProperty("核算维度4")
    private String segment4;

    @ApiModelProperty("核算维度5")
    private String segment5;

    @ApiModelProperty("核算维度6")
    private String segment6;

    @ApiModelProperty("核算维度7")
    private String segment7;

    @ApiModelProperty("核算维度8")
    private String segment8;

    @ApiModelProperty("核算维度9")
    private String segment9;

    @ApiModelProperty("核算维度10")
    private String segment10;

    @ApiModelProperty("核算维度11")
    private String segment11;

    @ApiModelProperty("核算维度12")
    private String segment12;

    @ApiModelProperty("核算维度13")
    private String segment13;

    @ApiModelProperty("核算维度14")
    private String segment14;

    @ApiModelProperty("核算维度15")
    private String segment15;

    @ApiModelProperty("核算维度16")
    private String segment16;

    @ApiModelProperty("核算维度17")
    private String segment17;

    @ApiModelProperty("核算维度18")
    private String segment18;

    @ApiModelProperty("借贷方 D/C")
    private String dc;

    @ApiModelProperty("借方金额")
    private BigDecimal debitAmt;

    @ApiModelProperty("贷方金额")
    private BigDecimal creditAmt;

    @ApiModelProperty("本币借方金额")
    private BigDecimal debitCurAmt;

    @ApiModelProperty("本币贷方金额")
    private BigDecimal creditCurAmt;

    @ApiModelProperty("币种")
    private String currCode;

    @ApiModelProperty("币种")
    private String currName;

    @ApiModelProperty("汇率")
    private BigDecimal exchangeRate;

    @ApiModelProperty("总账日期")
    private LocalDateTime glDate;

    @ApiModelProperty("会计期间")
    private String accountPeriod;

    @ApiModelProperty("账套编码")
    private String sobLedgerCode;

    @ApiModelProperty("账套名称")
    private String sobLedgerName;

    @ApiModelProperty("业务单号")
    private String docNum1;

    @ApiModelProperty("会计引擎ID")
    private Long accountEngineId;

    @ApiModelProperty("会计引擎明细ID")
    private Long accountEngineDetailsId;

    @ApiModelProperty("记账行ID")
    private Long accEngDetDataId;

    public void setField(String segmentName,String value){
        switch (segmentName){
            case "segment1": this.segment1=value;break;
            case "segment2": this.segment2=value;break;
            case "segment3": this.segment3=value;break;
            case "segment4": this.segment4=value;break;
            case "segment5": this.segment5=value;break;
            case "segment6": this.segment6=value;break;
            case "segment7": this.segment7=value;break;
            case "segment8": this.segment8=value;break;
            case "segment9": this.segment9=value;break;
            case "segment10": this.segment10=value;break;
            case "segment11": this.segment11=value;break;
            case "segment12": this.segment12=value;break;
            case "segment13": this.segment13=value;break;
            case "segment14": this.segment14=value;break;
            case "segment15": this.segment15=value;break;
            case "segment16": this.segment16=value;break;
            case "segment17": this.segment17=value;break;
            case "segment18": this.segment18=value;break;
            default:break;
        }
    }
    public String getField(String segmentName){
        switch (segmentName){
            case "segment1": return this.segment1;
            case "segment2": return this.segment2;
            case "segment3": return this.segment3;
            case "segment4": return this.segment4;
            case "segment5": return this.segment5;
            case "segment6": return this.segment6;
            case "segment7": return this.segment7;
            case "segment8": return this.segment8;
            case "segment9": return this.segment9;
            case "segment10": return this.segment10;
            case "segment11": return this.segment11;
            case "segment12": return this.segment12;
            case "segment13": return this.segment13;
            case "segment14": return this.segment14;
            case "segment15": return this.segment15;
            case "segment16": return this.segment16;
            case "segment17": return this.segment17;
            case "segment18": return this.segment18;
            default:return null;
        }
    }
}
