package com.elitesland.fin.rpc.ystsupp;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

/**
 * @Auther: Mark
 * @Date: 2024/7/12 15:41
 * @Description:
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class RmiSupportRpcServiceImpl implements RmiSupportRpcService {

    private final OrgOuRpcService orgOuRpcService;

    @Override
    public Optional<OrgOuRpcSimpleDTO>  findSimpleByOuCodes(String ouCode) {
        log.info("调用支撑域-findSimpleByOuCodes，时间：{}，入参：{}", LocalDateTime.now(), ouCode);
        try {
            List<OrgOuRpcSimpleDTO> orgOuVOS = orgOuRpcService.findSimpleByOuCodes(Arrays.asList(ouCode) );
            if (!CollectionUtils.isEmpty(orgOuVOS)) {
                return Optional.of(orgOuVOS.get(0)) ;
            }else{
                return Optional.empty();
            }
        } catch (Exception e) {
            log.error("调用支撑域-findSimpleByOuCodes发生异常:{}", e.getMessage(), e);
            throw new BusinessException("调用支撑域-findSimpleByOuCodes发生异常:"+e.getMessage(), e);
        }
    }
}
