package com.elitesland.fin.application.convert.rectype;
import com.elitesland.fin.application.facade.param.rectype.RecTypeSaveParam;
import com.elitesland.fin.application.facade.vo.recorder.RecOrderVO;
import com.elitesland.fin.application.facade.vo.rectype.RecTypeVO;
import com.elitesland.fin.domain.entity.rectype.RecType;
import com.elitesland.fin.domain.entity.rectype.RecTypeDO;
import com.elitesland.fin.infr.dto.rectype.RecTypeDTO;
import com.elitescloud.cloudt.common.base.PagingVO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/4/11 13:47
 */
@Mapper(unmappedTargetPolicy = ReportingPolicy.IGNORE)
public interface RecTypeConvert {
    RecTypeConvert INSTANCE = Mappers.getMapper(RecTypeConvert.class);

    PagingVO<RecTypeVO> convertPage(PagingVO<RecTypeDTO> param);

    RecTypeVO dtoToVo(RecTypeDTO dto);

    List<RecTypeVO> dtoToVo(List<RecTypeDTO> dto);

    RecType convert(RecTypeSaveParam param);

    RecTypeDO convert(RecType recType);

    //付款单类型ID映射收款单recTypeId  忽略主键ID映射
    @Mapping(source = "id", target = "recTypeId")
    @Mapping(target = "id",ignore = true)
    RecOrderVO typeToOrder(RecTypeDTO recType);


}
