package com.elitesland.fin.application.facade.param.creditaccount;

import com.elitesland.fin.application.facade.base.BaseModelParam;
import com.elitesland.fin.application.facade.dto.creditaccount.CreditAccountRuleConfigDtlDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
@ApiModel(description = "账户规则传输类")
@Data
public class CreditAccountRuleConfigSaveParam extends BaseModelParam implements Serializable {

    private static final long serialVersionUID = -9172927634362072762L;

    @ApiModelProperty("账户规则码")
    private String ruleCode;

    @ApiModelProperty("账户规则名称")
    private String ruleName;

    @ApiModelProperty("适用单据")
    private String optDoc;

    @ApiModelProperty("是否启用，默认为启用 [UDC]FIN:ACTIVE_STATUS")
    private String status;

    public List<CreditAccountRuleConfigDtlDTO> accountRuleConfigDtlDTOList;

}
