package com.elitesland.fin.application.facade.vo.invoiceredraft;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author gyj
 * @description
 * @Date 2023/7/14
 */
@Data
@ApiModel("重新开票分页")
public class InvoiceRedraftPageVO extends CustomFieldBaseModelVo {

    @ApiModelProperty("换开申请单号")
    private String origApplyNo;

    @ApiModelProperty("发票号码")
    private String invoiceNo;

    @ApiModelProperty("流水号")
    private String serialNo;

    @ApiModelProperty("开票金额")
    private BigDecimal invoiceAmt;

    @ApiModelProperty("开票日期")
    private LocalDateTime invoiceDate;

    @ApiModelProperty("发票类型 [UDC]FIN:INV_TYPE")
    @SysCode(sys = "yst-fin", mod = "INV_TYPE")
    private String invoiceType;
    @ApiModelProperty("发票类型名称")
    private String invoiceTypeName;

    @ApiModelProperty("发票是否抵扣 0-否 1-是")
    private Integer invoiceDeduction;

    @ApiModelProperty("开票抬头")
    private String invTitle;

    @ApiModelProperty("开票抬头类型")
    @SysCode(sys = "yst-supp", mod = "INV_TITLE_TYPE")
    private String invTitleType;
    private String invTitleTypeName;

    @ApiModelProperty("税号")
    private String taxerNo;

    @ApiModelProperty("换开理由")
    private String redraftReason;

    @ApiModelProperty("附件id")
    private String attachmentId;

    @ApiModelProperty("审批状态")
    private ProcInstStatus workflowProcInstStatus;
    @ApiModelProperty("审批状态名称")
    private String workflowProcInstStatusName;

    @ApiModelProperty("审批流实例id")
    private String workflowProcInstId;

    @ApiModelProperty("单据状态")
    @SysCode(sys = "yst-supp",mod = "APPLY_STATUS")
    private String docStatus;
    private String docStatusName;

}
