package com.elitesland.fin.application.service.saleinvd;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.vo.invoiceredraft.InvoiceRedraftPageVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvDetailAppVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvdDtlVO;
import com.elitesland.fin.domain.param.saleinvd.SaleInvdPageParam;
import com.elitesland.fin.domain.param.saleinvd.SaleInvdParam;
import com.elitesland.fin.domain.service.saleinvd.SaleInvdDomainService;
import com.elitesland.fin.infr.repo.saleinv.SaleInvdDtlRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Map;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.service.saleinv
 * @date 2022/5/6 15:02
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class SaleInvdServiceImpl implements SaleInvdService {

    private final SaleInvdDomainService saleInvdDomainService;
    private final SaleInvdDtlRepoProc saleInvdDtlRepoProc;
    private final UdcProvider udcProvider;
    @Override
    @SysCodeProc
    public PagingVO<SaleInvdDtlVO> page(SaleInvdPageParam param) {
        PagingVO<SaleInvdDtlVO> page = saleInvdDtlRepoProc.getPage(param);
        if (CollectionUtil.isNotEmpty(page.getRecords())) {
            Map<String, String> invRedBlueType = udcProvider.getValueMapByUdcCode("yst-fin", "INV_RED_BLUE_TYPE");
            Map<String, String> invState = udcProvider.getValueMapByUdcCode("yst-fin", "INV_STATE");
            page.getRecords().forEach(saleInvdDtlVO -> {
                saleInvdDtlVO.setRedBlueTypeName(invRedBlueType.get(saleInvdDtlVO.getRedBlueType()));
                saleInvdDtlVO.setInvStateName(invState.get(saleInvdDtlVO.getInvState()));
            });
        }
        return page;
    }

    @Override
    public void cancel(Long id) {
        saleInvdDomainService.cancel(id);
    }

    @Override
    public void red(Long id) {
        saleInvdDomainService.red(id);
    }

    @Transactional
    @Override
    public InvoiceRedraftPageVO redraft(Long id) {
        return saleInvdDomainService.redraft(id);

    }

    @Override
    public void update(SaleInvdParam param) {
        saleInvdDomainService.update(param);
    }

    @Override
    @SysCodeProc
    public SaleInvDetailAppVO appGet(Long id) {
        return saleInvdDomainService.appGet(id);
    }

}
