package com.elitesland.fin.application.service.writeoff;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.fin.application.convert.writeoff.FinApPayVerApplyApConvert;
import com.elitesland.fin.application.facade.dto.writeoff.FinApPayVerApplyApSaveDTO;
import com.elitesland.fin.application.facade.param.writeoff.FinApPayVerApplyApQuery;
import com.elitesland.fin.application.facade.param.writeoff.FinApPayVerApplyQuery;
import com.elitesland.fin.application.facade.vo.aporder.ApOrderVO;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyApVO;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyPayVO;
import com.elitesland.fin.domain.entity.writeoff.FinApPayVerApplyApDO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepoProc;
import com.elitesland.fin.repo.writeoff.FinApPayVerApplyApRepoProc;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 核销申请.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Service
@RequiredArgsConstructor
public class FinApPayVerApplyApServiceImpl implements FinApPayVerApplyApService {

    private final FinApPayVerApplyApRepoProc finApPayVerApplyApRepoProc;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;
    private final ApOrderRepoProc apOrderRepoProc;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void createBatch(Long masId, List<FinApPayVerApplyApSaveDTO> saveList) {
        Assert.notNull(masId, "主表ID不能为Null");
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        List<String> apDocNoList = saveList.stream().map(FinApPayVerApplyApSaveDTO::getApDocNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<ApOrderDTO> apOrderDTOList = apOrderRepoProc.selectInOutCustByApOrderNo(apDocNoList);
        Map<String, ApOrderDTO> apOrderMap = CollectionUtil.isEmpty(apOrderDTOList) ? new HashMap<>() : apOrderDTOList.stream().collect(Collectors.toMap(ApOrderDTO::getApOrderNo, t -> t, (t1, t2) -> t1));

        finApPayVerApplyApRepoProc.save(saveList.stream()
                .map(e -> {
                    FinApPayVerApplyApDO entity = FinApPayVerApplyApConvert.INSTANCE.save2Do(e);
                    entity.setMasId(masId);
                    ApOrderDTO apOrderDTO = apOrderMap.get(entity.getApDocNo());
                    if (Objects.nonNull(apOrderDTO)){
                        String inOutCust = StringUtils.isBlank(entity.getInOutCust()) ? apOrderDTO.getInOutCust() : entity.getInOutCust();
                        String relevanceOuCode = StringUtils.isBlank(entity.getRelevanceOuCode()) ? apOrderDTO.getRelevanceOuCode() : entity.getRelevanceOuCode();
                        entity.setInOutCust(inOutCust);
                        entity.setRelevanceOuCode(relevanceOuCode);
                    }
                    return entity;
                }).collect(Collectors.toList()));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByMasId(Collection<Long> masIds) {
        finApPayVerApplyApRepoProc.deleteByMasId(masIds);
    }

    @Override
    @SysCodeProc
    public List<FinApPayVerApplyApVO> listByMasIds(Collection<Long> masIds) {
        List<FinApPayVerApplyApVO> finApPayVerApplyApVOList =  finApPayVerApplyApRepoProc.listByMasIds(masIds)
                .stream()
                .map(FinApPayVerApplyApConvert.INSTANCE::entity2Vo)
                .collect(Collectors.toList());
        if (CollectionUtil.isEmpty(finApPayVerApplyApVOList)){
            return Collections.EMPTY_LIST;
        }
        List<String> relevanceOuCodeList = finApPayVerApplyApVOList.stream().map(FinApPayVerApplyApVO::getRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relevanceOuCodeList);
        finApPayVerApplyApVOList.forEach(v -> {
            OrgOuRpcSimpleDTO ouRpcSimpleDTO = ouMap.get(v.getRelevanceOuCode());
            if (Objects.nonNull(ouRpcSimpleDTO)){
                v.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
            }
        });

        return finApPayVerApplyApVOList;
    }

	/**
	 * 根据条件查询核销应收单明细
	 *
	 * @param query
	 * @return
	 */
	@Override
	public List<FinApPayVerApplyApVO> listByQuery(FinApPayVerApplyApQuery query) {
		return finApPayVerApplyApRepoProc.listByQuery(query)
				.stream()
				.map(FinApPayVerApplyApConvert.INSTANCE::entity2Vo)
				.collect(Collectors.toList());
	}

	/**
	 * 通过第三方应收单号或者第三方应收单明细ID查询
	 * @param applyQuery
	 * @return
	 */
	@Override
	public List<FinApPayVerApplyApVO> listByOutArDocNoOrDId(FinApPayVerApplyQuery applyQuery) {
		/*if(StrUtil.isEmpty(applyQuery.getOutApDocNo()) && StrUtil.isEmpty(applyQuery.getOutApDId())){
			return null;
		}*/
		return finApPayVerApplyApRepoProc.listByOutApDocNoOrDId(applyQuery);
	}
}
