package com.elitesland.fin.domain.service.account;

import com.elitesland.fin.repo.account.AccountRepo;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;


import java.math.BigDecimal;
@Service
@AllArgsConstructor
@Slf4j
public class AccountDomainServiceImpl implements AccountDomainService{
    private final AccountRepo accountRepo;
    @Transactional(rollbackFor = {Exception.class})
    @Override
    public int updateAccountOccupancyAmountAndAccountAvailableAmountById(long id, BigDecimal accountAmount) {
        return accountRepo.updateAccountOccupancyAmountAndAccountAvailableAmountById(id,accountAmount);
    }
    @Transactional(rollbackFor = {Exception.class})
    @Override
    public int updateAddAccountAmountAndAccountAvailableAmountById(Long id, BigDecimal amount) {
        return accountRepo.updateAddAccountAmountAndAccountAvailableAmountById(id,amount);
    }
    @Transactional(rollbackFor = {Exception.class})
    @Override
    public int updateSubtractAccountAmountAndAccountAvailableAmountById(Long id, BigDecimal amount) {
        return accountRepo.updateSubtractAccountAmountAndAccountAvailableAmountById(id,amount);
    }
    @Transactional(rollbackFor = {Exception.class})
    @Override
    public int updateSubtractAccountOccupancyAmountAndAccountAvailableAmountById(Long id, BigDecimal amount) {
        return accountRepo.updateSubtractAccountOccupancyAmountAndAccountAvailableAmountById(id,amount);
    }
}
