package com.elitesland.fin.domain.service.paymentperiod;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.paymentperiod.AgingRangeOuConvert;
import com.elitesland.fin.application.facade.param.paymentperiod.AgingRangeOuPageParam;
import com.elitesland.fin.application.facade.param.paymentperiod.AgingRangeOuSaveParam;
import com.elitesland.fin.application.facade.vo.paymentperiod.AgingRangeOuVO;
import com.elitesland.fin.domain.entity.paymentperiod.AgingRangeOuDO;
import com.elitesland.fin.infr.dto.paymentperiod.AgingRangeOuDTO;
import com.elitesland.fin.infr.repo.paymentperiod.AgingRangeOuRepo;
import com.elitesland.fin.infr.repo.paymentperiod.AgingRangeOuRepoProc;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/17
 * @Version 1.0
 * @Content:
 */
@Service
@RequiredArgsConstructor
public class AgingRangeOuDomainServiceImpl implements AgingRangeOuDomainService{

    private final AgingRangeOuRepo agingRangeOuRepo;
    private final AgingRangeOuRepoProc agingRangeOuRepoProc;


    @Override
    @SysCodeProc
    public PagingVO<AgingRangeOuDTO> ouPage(AgingRangeOuPageParam pageParam) {
        PagingVO<AgingRangeOuDTO> res = agingRangeOuRepoProc.page(pageParam);
        return res;
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public Long addOu(AgingRangeOuSaveParam saveParam) {

        AgingRangeOuDO agingRangeOuDO = AgingRangeOuConvert.INSTANCE.saveVoToDo(saveParam);
        // 验证主表Id 和 ouid是否存在，

        Boolean isExist = agingRangeOuRepoProc.existByApTypeIdOuId(agingRangeOuDO);
        if (!isExist) {
            AgingRangeOuDO save = agingRangeOuRepo.save(agingRangeOuDO);
            return save.getId();
        }
        return saveParam.getId();
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public void cancelOu(List<Long> ids) {
        //Long res = agingRangeOuRepoProc.updateDeleteFlagBatchById(1,ids);
        agingRangeOuRepo.deleteByIdIn(ids);

    }

    /**
     * 账龄区间分配公司保存
     *
     * @param saveParamList 入参
     * @return 账龄区间分配公司ID
     */
    @Override
    @Transactional(rollbackFor = {Exception.class})
    public List<Long> save(List<AgingRangeOuSaveParam> saveParamList) {
        List<AgingRangeOuDO> dtlDOList = saveParamList.stream().map(AgingRangeOuConvert.INSTANCE::saveVoToDo).collect(Collectors.toList());

        return agingRangeOuRepo.saveAll(dtlDOList).stream().map(AgingRangeOuDO::getId).collect(Collectors.toList());
    }

    /**
     * 根据主表ID删除账龄区间分配公司
     *
     * @param masId 主表ID
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByMasId(Long masId) {
        agingRangeOuRepo.deleteByMasId(masId);
    }

    /**
     * 根据主表ID查询账龄区间分配公司
     *
     * @param masId 主表ID
     * @return 账龄区间分配公司
     */
    @Override
    @SysCodeProc
    public List<AgingRangeOuVO> selectByMasId(Long masId) {
        if (Objects.isNull(masId)) {
            return Collections.EMPTY_LIST;
        }
        AgingRangeOuPageParam queryVO = new AgingRangeOuPageParam();
        queryVO.setMasId(masId);
        List<AgingRangeOuVO> dtlVOList = agingRangeOuRepoProc.selectListByParam(queryVO);
        if (CollectionUtils.isEmpty(dtlVOList)) {
            return Collections.EMPTY_LIST;
        }

        return dtlVOList;
    }

    /**
     * 根据入参查询账龄区间分配公司
     *
     * @param queryVO 入参
     * @return 账龄区间分配公司数据
     */
    @Override
    @SysCodeProc
    public List<AgingRangeOuVO> selectByParam(AgingRangeOuPageParam queryVO) {
        List<AgingRangeOuVO> dtlVOList = agingRangeOuRepoProc.selectListByParam(queryVO);
        if (CollectionUtils.isEmpty(dtlVOList)) {
            return Collections.EMPTY_LIST;
        }
        return dtlVOList;
    }

    /**
     * 根据主表ID批量更新deleteFlag
     *
     * @param deleteFlag 删除标记
     * @param masIds     主表ID
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateDeleteFlagBatchByMasId(Integer deleteFlag, List<Long> masIds) {
        agingRangeOuRepoProc.updateDeleteFlagBatchByMasId(deleteFlag, masIds);
    }

}
