package com.elitesland.fin.repo.accountingengine;

import com.elitesland.fin.domain.entity.accountingengine.FinFlexibleDO;
import com.elitesland.fin.domain.entity.accountingengine.FinFlexibleValueDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Repository
public interface FinFlexibleValueRepo extends JpaRepository<FinFlexibleValueDO, Long>, QuerydslPredicateExecutor<FinFlexibleValueDO> {

    void deleteAllByMasId(Long masId);

    List<FinFlexibleValueDO> findAllByMasIdIn(List<Long> ids);

    List<FinFlexibleValueDO> findAllByMasId(Long id);

    List<FinFlexibleValueDO> findByFlexibleValueCodeIn(Collection<String> flexibleValueCodes);
}
