/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.creditaccount;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.fin.application.convert.adjusttoorder.AdjustToOrderConvert;
import com.elitesland.fin.application.convert.creditaccount.CreditAutoRepaymentConditionConvert;
import com.elitesland.fin.application.facade.param.account.AccountPageParam;
import com.elitesland.fin.application.facade.param.adjusttoorder.AdjustToOrderSaveParam;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountPageParam;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAutoRepaymentJobParam;
import com.elitesland.fin.application.facade.vo.account.AccountVO;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountPageVO;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditSettingDetailVO;
import com.elitesland.fin.application.service.adjusttoorder.AdjustToOrderService;
import com.elitesland.fin.application.service.creditaccount.CreditAccountAutoRepaymentService;
import com.elitesland.fin.common.SysNumEnum;
import com.elitesland.fin.common.SysNumberGenerator;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.account.AccountDO;
import com.elitesland.fin.entity.adjusttoorder.AdjustToOrderDO;
import com.elitesland.fin.entity.creditaccount.CreditAccountDO;
import com.elitesland.fin.entity.creditaccount.CreditAutoRepaymentConditionDO;
import com.elitesland.fin.repo.account.AccountRepoProc;
import com.elitesland.fin.repo.adjusttoorder.AdjustToOrderRepo;
import com.elitesland.fin.repo.adjusttoorder.AdjustToOrderRepoProc;
import com.elitesland.fin.repo.creditaccount.CreditAccountRepoProc;
import com.elitesland.fin.repo.creditaccount.CreditAutoRepaymentConditionRepo;
import com.elitesland.fin.repo.creditaccount.CreditSettingRepoProc;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class CreditAccountAutoRepaymentServiceImpl
implements CreditAccountAutoRepaymentService {
    private static final Logger log = LoggerFactory.getLogger(CreditAccountAutoRepaymentServiceImpl.class);
    private final CreditSettingRepoProc creditSettingRepoProc;
    private final AccountRepoProc accountRepoProc;
    private final CreditAccountRepoProc creditAccountRepoProc;
    private final CreditAutoRepaymentConditionRepo autoRepaymentConditionRepo;
    public static final String CREDIT_ACCOUNT_TABLE_NAME = "credit_account";
    public static final String ACCOUNT_TABLE_NAME = "account";
    public static final String DEFAULT_USER_NAME = "\u7cfb\u7edf\u81ea\u52a8";
    public static final Long DEFAULT_USER_ID = 0L;
    public static final String DEFAULT_ADJUST_TO_ORDER_REMARK = "\u4fe1\u7528\u8d26\u6237\u81ea\u52a8\u8fd8\u6b3e";
    private final SysNumberGenerator sysNumberGenerator;
    private final AdjustToOrderRepo adjustToOrderRepo;
    private final AdjustToOrderRepoProc adjustToOrderRepoProc;
    private final AdjustToOrderService adjustToOrderService;
    private final UdcProvider udcProvider;
    @PersistenceContext
    private EntityManager entityManager;
    private final TransactionTemplate transactionTemplate;

    @Override
    public void creditAccountAutoRepayment(String param) {
        JSONObject jsonObject;
        CreditAutoRepaymentJobParam autoRepaymentJobParam;
        CreditAutoRepaymentJobParam jobParam = new CreditAutoRepaymentJobParam();
        if (StringUtils.isNotBlank((CharSequence)param) && Objects.nonNull(autoRepaymentJobParam = (CreditAutoRepaymentJobParam)JSONObject.toJavaObject((JSON)(jsonObject = JSONObject.parseObject((String)param)), CreditAutoRepaymentJobParam.class))) {
            CreditAutoRepaymentConditionConvert.INSTANCE.oldToNewDO(autoRepaymentJobParam, jobParam);
        }
        this.autoRepayment(jobParam);
    }

    @Override
    public void autoRepayment(CreditAutoRepaymentJobParam jobParam) {
        log.info("\u767b\u5f55\u4eba\u4fe1\u606f\uff1a{}", (Object)SecurityContextUtil.currentUser());
        log.info("\u4fe1\u7528\u8d26\u6237\u81ea\u52a8\u8fd8\u6b3e\u5b9a\u65f6\u4efb\u52a1\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)jobParam));
        CreditSettingDetailVO creditSettingDetailVO = this.creditSettingRepoProc.findAll();
        if (Objects.isNull(creditSettingDetailVO)) {
            log.info("\u67e5\u8be2\u4fe1\u7528\u8bbe\u7f6e\u4e3a\u7a7a");
            return;
        }
        if (Objects.nonNull(creditSettingDetailVO.getAutoRepaymentFlag()) && creditSettingDetailVO.getAutoRepaymentFlag().booleanValue()) {
            ArrayList creditAccountConditionList = new ArrayList();
            ArrayList accountConditionList = new ArrayList();
            List<CreditAutoRepaymentConditionDO> autoRepaymentConditionDOList = this.autoRepaymentConditionRepo.findAllByMasId(creditSettingDetailVO.getId());
            Map<String, List<CreditAutoRepaymentConditionDO>> autoRepaymentConditionMap = autoRepaymentConditionDOList.stream().filter(i -> StringUtils.isNotBlank((CharSequence)i.getTableName())).collect(Collectors.groupingBy(i -> i.getTableName()));
            autoRepaymentConditionMap.forEach((key, values) -> {
                String buildSql = this.buildSql((String)key, (List<CreditAutoRepaymentConditionDO>)values);
                if (Objects.equals(key, CREDIT_ACCOUNT_TABLE_NAME)) {
                    List<CreditAccountDO> creditAccountDOList = this.selectCreditAccountData(buildSql);
                    log.info("\u67e5\u8be2\u6ee1\u8db3\u81ea\u52a8\u8fd8\u6b3e\u6761\u4ef6\u7684\u4fe1\u7528\u8d26\u6237:{}", (Object)JSON.toJSONString(creditAccountDOList));
                    if (CollectionUtil.isNotEmpty(creditAccountDOList)) {
                        creditAccountConditionList.addAll(creditAccountDOList);
                    }
                } else if (Objects.equals(key, ACCOUNT_TABLE_NAME)) {
                    List<AccountDO> accountDOList = this.selectAccountData(buildSql);
                    log.info("\u67e5\u8be2\u6ee1\u8db3\u81ea\u52a8\u8fd8\u6b3e\u6761\u4ef6\u7684\u8d26\u6237:{}", (Object)JSON.toJSONString(accountDOList));
                    if (CollectionUtil.isNotEmpty(accountDOList)) {
                        accountConditionList.addAll(accountDOList);
                    }
                }
            });
            if (CollectionUtil.isEmpty(creditAccountConditionList) || creditAccountConditionList.size() < 1) {
                log.info("\u65e0\u6ee1\u8db3\u81ea\u52a8\u8fd8\u6b3e\u6761\u4ef6\u7684\u4fe1\u7528\u8d26\u6237");
                return;
            }
            List creditAccountConditionIds = creditAccountConditionList.stream().map(BaseModel::getId).collect(Collectors.toList());
            if (CollectionUtil.isEmpty(accountConditionList) || accountConditionList.size() < 1) {
                log.info("\u65e0\u6ee1\u8db3\u81ea\u52a8\u8fd8\u6b3e\u6761\u4ef6\u7684\u8d26\u6237");
                return;
            }
            List accountConditionIds = accountConditionList.stream().map(BaseModel::getId).collect(Collectors.toList());
            CreditAccountPageParam creditAccountPageParam = new CreditAccountPageParam();
            creditAccountPageParam.setStatus(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
            List<CreditAccountPageVO> creditAccountVOList = this.creditAccountRepoProc.queryList(creditAccountPageParam);
            log.info("\u67e5\u8be2\u4fe1\u7528\u8d26\u6237\u96c6\u5408:{}", (Object)JSON.toJSONString(creditAccountVOList));
            if (CollectionUtil.isEmpty(creditAccountVOList)) {
                log.info("\u67e5\u8be2\u4fe1\u7528\u8d26\u6237\u96c6\u5408\u4e3a\u7a7a");
                return;
            }
            List creditAccountVoFilters = creditAccountVOList.stream().filter(creditAccountPageVO -> creditAccountConditionIds.contains(creditAccountPageVO.getId())).collect(Collectors.toList());
            if (CollectionUtil.isEmpty(creditAccountVoFilters) || creditAccountVoFilters.size() < 1) {
                log.info("\u65e0\u7b26\u5408\u81ea\u52a8\u8fd8\u6b3e\u8bbe\u7f6e\u6761\u4ef6\u7684\u4fe1\u7528\u8d26\u6237");
                return;
            }
            Map udcCode = this.udcProvider.getValueMapByUdcCode(UdcEnum.ACCOUNT_TYPE_STORE.getModel(), Set.of(UdcEnum.ACCOUNT_TYPE_STORE.getCode(), UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getCode()));
            Map accountTypeMap = (Map)udcCode.get(UdcEnum.ACCOUNT_TYPE_STORE.getCode());
            Map creditAccountTypeMap = (Map)udcCode.get(UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getCode());
            for (CreditAccountPageVO creditAccountPageVO2 : creditAccountVoFilters) {
                String ouCode = creditAccountPageVO2.getOuCode();
                String objectCode = creditAccountPageVO2.getObjectCode();
                AccountPageParam accountPageParam = new AccountPageParam();
                accountPageParam.setSecOuCode(ouCode);
                accountPageParam.setAccountHolderCode(objectCode);
                accountPageParam.setState(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
                accountPageParam.setAccountType(UdcEnum.ACCOUNT_TYPE_STORE.getValueCode());
                List<AccountVO> accountVOList = this.accountRepoProc.queryList(accountPageParam);
                log.info("\u67e5\u8be2\u50a8\u503c\u8d26\u6237\u96c6\u5408:{}", (Object)JSON.toJSONString(accountVOList));
                if (CollectionUtil.isEmpty(accountVOList)) {
                    log.info("\u67e5\u8be2\u50a8\u503c\u8d26\u6237\u96c6\u5408\u4e3a\u7a7a");
                    continue;
                }
                if (CollectionUtil.isNotEmpty(accountVOList) && accountVOList.size() > 1) {
                    log.info("\u6839\u636e\u516c\u53f8(" + ouCode + ")+\u5ba2\u6237(" + objectCode + ")\u7ef4\u5ea6\u67e5\u51fa\u591a\u4e2a\u50a8\u503c\u8d26\u6237\u6570\u636e");
                    continue;
                }
                AccountVO accountVO = accountVOList.get(0);
                if (!accountConditionIds.contains(accountVO.getId())) {
                    log.info("\u65e0\u7b26\u5408\u81ea\u52a8\u8fd8\u6b3e\u8bbe\u7f6e\u6761\u4ef6\u7684\u50a8\u503c\u8d26\u6237,\u516c\u53f8:{}, \u5ba2\u6237:{}", (Object)ouCode, (Object)objectCode);
                    continue;
                }
                BigDecimal adjustmentAmt = this.computeAdjustmentAmt(creditAccountPageVO2, accountVO);
                if (Objects.isNull(adjustmentAmt)) {
                    log.info("\u8c03\u6574\u91d1\u989d\u4e3a\u7a7a\u5219\u65e0\u9700\u8fd8\u6b3e");
                    continue;
                }
                this.transactionTemplate.setPropagationBehavior(3);
                Integer n = (Integer)this.transactionTemplate.execute(transactionStatus -> {
                    try {
                        this.generateAdjustToOrder(creditAccountPageVO2, accountVO, adjustmentAmt, accountTypeMap, creditAccountTypeMap, jobParam);
                        return 1;
                    }
                    catch (Exception e) {
                        log.error("\u516c\u53f8(" + ouCode + ")\u4e0e\u5bf9\u8c61\u7f16\u7801(" + objectCode + ")\u4fe1\u7528\u8d26\u6237\u81ea\u52a8\u8fd8\u6b3e\u5931\u8d25!:{}", (Object)e.getMessage());
                        transactionStatus.setRollbackOnly();
                        return 0;
                    }
                });
            }
        } else {
            log.info("\u4fe1\u7528\u8bbe\u7f6e\u7684\u662f\u5426\u8bbe\u7f6e\u81ea\u52a8\u8fd8\u6b3e\u4e3a\u3010\u5426\u3011\u65f6\u65e0\u9700\u89e6\u53d1");
            return;
        }
    }

    private BigDecimal computeAdjustmentAmt(CreditAccountPageVO creditAccountPageVO, AccountVO accountVO) {
        BigDecimal creditAccountUsedLimit = creditAccountPageVO.getCreditAccountUsedLimit();
        BigDecimal accountAvailableAmount = accountVO.getAccountAvailableAmount();
        if (creditAccountUsedLimit.compareTo(BigDecimal.ZERO) == 1 && accountAvailableAmount.compareTo(BigDecimal.ZERO) == 1) {
            BigDecimal adjustmentAmt = BigDecimal.ZERO;
            if (creditAccountUsedLimit.compareTo(accountAvailableAmount) > -1) {
                adjustmentAmt = accountAvailableAmount;
                return adjustmentAmt;
            }
            if (creditAccountUsedLimit.compareTo(accountAvailableAmount) == -1) {
                adjustmentAmt = creditAccountUsedLimit;
                return adjustmentAmt;
            }
        }
        return null;
    }

    private String buildSql(String tableName, List<CreditAutoRepaymentConditionDO> autoRepaymentConditionDOList) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select");
        stringBuilder.append(" ");
        stringBuilder.append("*");
        stringBuilder.append(" ");
        stringBuilder.append("from");
        stringBuilder.append(" ");
        stringBuilder.append(tableName);
        stringBuilder.append(" ");
        stringBuilder.append("where");
        stringBuilder.append(" ");
        stringBuilder.append("(delete_flag = 0 or delete_flag is null)");
        stringBuilder.append(" ");
        String buildWhere = this.buildWhere(autoRepaymentConditionDOList);
        if (StringUtils.isNotBlank((CharSequence)buildWhere)) {
            stringBuilder.append("and");
            stringBuilder.append(" ");
            stringBuilder.append(buildWhere);
        }
        return stringBuilder.toString();
    }

    private String buildWhere(List<CreditAutoRepaymentConditionDO> autoRepaymentConditionDOList) {
        if (CollectionUtils.isEmpty(autoRepaymentConditionDOList)) {
            return null;
        }
        List wheres = autoRepaymentConditionDOList.stream().map(item -> this.buildWhere(item.getConditionType(), item.getTableName(), item.getColumnName(), item.getValueFrom(), item.getValueTo())).collect(Collectors.toList());
        return StringUtils.join(wheres, (String)" ".concat("and").concat(" "));
    }

    private String buildWhere(String conditionType, String tableName, String columnName, String valueFrom, String valueTo) {
        Map eventTableConditionUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.EVENT_TABLE_CONDITION_EQUAL.getModel(), UdcEnum.EVENT_TABLE_CONDITION_EQUAL.getCode());
        conditionType = (String)eventTableConditionUdc.get(conditionType);
        String concat = " ".concat(columnName).concat(" ");
        if (UdcEnum.EVENT_TABLE_CONDITION_BETWEEN_AND.getValueCode().equals(conditionType)) {
            return concat.concat("between").concat(" ").concat(valueFrom).concat(" ").concat("and").concat(" ").concat(valueTo).concat(" ");
        }
        return concat.concat(conditionType).concat(" ").concat(valueFrom).concat(" ");
    }

    private List<AccountDO> selectAccountData(String sql) {
        Query query = this.entityManager.createNativeQuery(sql, AccountDO.class);
        List resultList = query.getResultList();
        return resultList;
    }

    private List<CreditAccountDO> selectCreditAccountData(String sql) {
        Query query = this.entityManager.createNativeQuery(sql, CreditAccountDO.class);
        List resultList = query.getResultList();
        return resultList;
    }

    @Transactional(rollbackFor={Exception.class})
    public void generateAdjustToOrder(CreditAccountPageVO creditAccountVO, AccountVO accountVO, BigDecimal adjustmentAmt, Map<String, String> accountTypeMap, Map<String, String> creditAccountTypeMap, CreditAutoRepaymentJobParam jobParam) {
        log.info("\u751f\u6210\u8c03\u5242\u5355\u548c\u6d41\u6c34\u5165\u53c2,\u4fe1\u7528\u8d26\u6237:{},\u8d26\u6237:{},\u8c03\u6574\u91d1\u989d:{}", new Object[]{JSON.toJSONString((Object)((Object)creditAccountVO)), JSON.toJSONString((Object)((Object)accountVO)), JSON.toJSONString((Object)adjustmentAmt)});
        AdjustToOrderSaveParam adjustToOrderSaveParam = new AdjustToOrderSaveParam();
        adjustToOrderSaveParam.setAccountNameFrom(accountVO.getAccountName());
        adjustToOrderSaveParam.setAccountCodeFrom(accountVO.getAccountCode());
        adjustToOrderSaveParam.setAccountTypeFrom(UdcEnum.ACCOUNT_TYPE_STORE.getValueCode());
        adjustToOrderSaveParam.setAccountNameTo(creditAccountVO.getCreditAccountName());
        adjustToOrderSaveParam.setAccountCodeTo(creditAccountVO.getCreditAccountCode());
        adjustToOrderSaveParam.setAccountTypeTo(UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getValueCode());
        adjustToOrderSaveParam.setAdjustReason(UdcEnum.FIN_ADJUST_REASON_5.getValueCode());
        adjustToOrderSaveParam.setAdjustAmount(adjustmentAmt);
        this.adjustToOrderService.checkSave(adjustToOrderSaveParam);
        AdjustToOrderDO adjustToOrderDO = AdjustToOrderConvert.INSTANCE.saveParamToDO(adjustToOrderSaveParam);
        String docNo = this.sysNumberGenerator.generate(SysNumEnum.FIN_ADJTO_ORDER.getCode());
        adjustToOrderDO.setDocNo(docNo);
        adjustToOrderDO.setDocState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
        String userName = StringUtils.isNotBlank((CharSequence)jobParam.getUserName()) ? jobParam.getUserName() : DEFAULT_USER_NAME;
        Long userId = Objects.nonNull(jobParam.getUserId()) ? jobParam.getUserId() : DEFAULT_USER_ID;
        adjustToOrderDO.setAuditTime(LocalDateTime.now());
        adjustToOrderDO.setAuditUser(userName);
        adjustToOrderDO.setAuditUserId(userId);
        adjustToOrderDO.setRemark(DEFAULT_ADJUST_TO_ORDER_REMARK);
        adjustToOrderDO.setCreateTime(LocalDateTime.now());
        adjustToOrderDO.setCreator(userName);
        adjustToOrderDO.setCreateUserId(userId);
        adjustToOrderDO.setModifyUserId(userId);
        adjustToOrderDO.setUpdater(userName);
        adjustToOrderDO.setModifyTime(LocalDateTime.now());
        this.adjustToOrderRepo.save((Object)adjustToOrderDO);
        AccountDO fromAccountDO = this.accountRepoProc.findByAccountCode(adjustToOrderDO.getAccountCodeFrom());
        if (NumberUtil.isGreater((BigDecimal)adjustToOrderDO.getAdjustAmount(), (BigDecimal)fromAccountDO.getAccountAvailableAmount())) {
            throw new BusinessException(String.format("\u4ece\u8d26\u6237(" + adjustToOrderDO.getAccountCodeFrom() + ")\u8c03\u51fa\u91d1\u989d%s\u5927\u4e8e\u8d26\u6237\u53ef\u7528\u989d\u5ea6%s", adjustToOrderDO.getAdjustAmount().setScale(2, RoundingMode.HALF_UP), fromAccountDO.getAccountAvailableAmount().setScale(2, RoundingMode.HALF_UP)));
        }
        AdjustToOrderDO adjustToOrderDoingDO = new AdjustToOrderDO();
        AdjustToOrderConvert.INSTANCE.oldToNewDO(adjustToOrderDO, adjustToOrderDoingDO);
        adjustToOrderDoingDO.setDocState(UdcEnum.APPLY_STATUS_DOING.getValueCode());
        this.adjustToOrderService.generateAccountFlow(adjustToOrderDoingDO, adjustToOrderDoingDO.getAccountCodeFrom(), UdcEnum.ADJUST_TYPE_2.getValueCode());
        AdjustToOrderDO adjustToOrderCompleteDO = new AdjustToOrderDO();
        AdjustToOrderConvert.INSTANCE.oldToNewDO(adjustToOrderDO, adjustToOrderCompleteDO);
        adjustToOrderCompleteDO.setDocState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
        this.adjustToOrderService.generateAccountFlow(adjustToOrderCompleteDO, adjustToOrderCompleteDO.getAccountCodeFrom(), UdcEnum.ADJUST_TYPE_2.getValueCode());
        if (accountTypeMap.containsKey(adjustToOrderCompleteDO.getAccountTypeTo())) {
            this.adjustToOrderService.generateAccountFlow(adjustToOrderCompleteDO, adjustToOrderCompleteDO.getAccountCodeTo(), UdcEnum.ADJUST_TYPE_1.getValueCode());
        } else if (creditAccountTypeMap.containsKey(adjustToOrderCompleteDO.getAccountTypeTo())) {
            this.adjustToOrderService.generateCreditAccountFlow(adjustToOrderCompleteDO);
        } else {
            throw new BusinessException(String.format("\u81f3\u8d26\u6237\u7c7b\u578b%s\u6ca1\u6709\u7ef4\u62a4", adjustToOrderCompleteDO.getAccountTypeTo()));
        }
    }

    public CreditAccountAutoRepaymentServiceImpl(CreditSettingRepoProc creditSettingRepoProc, AccountRepoProc accountRepoProc, CreditAccountRepoProc creditAccountRepoProc, CreditAutoRepaymentConditionRepo autoRepaymentConditionRepo, SysNumberGenerator sysNumberGenerator, AdjustToOrderRepo adjustToOrderRepo, AdjustToOrderRepoProc adjustToOrderRepoProc, AdjustToOrderService adjustToOrderService, UdcProvider udcProvider, TransactionTemplate transactionTemplate) {
        this.creditSettingRepoProc = creditSettingRepoProc;
        this.accountRepoProc = accountRepoProc;
        this.creditAccountRepoProc = creditAccountRepoProc;
        this.autoRepaymentConditionRepo = autoRepaymentConditionRepo;
        this.sysNumberGenerator = sysNumberGenerator;
        this.adjustToOrderRepo = adjustToOrderRepo;
        this.adjustToOrderRepoProc = adjustToOrderRepoProc;
        this.adjustToOrderService = adjustToOrderService;
        this.udcProvider = udcProvider;
        this.transactionTemplate = transactionTemplate;
    }
}

