package com.elitesland.fin.application.facade.vo.invoice;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @Author: ryan.xu
 * @since 2023/4/13
 */
@Data
@ApiModel(value = "付款通知单保存参数")
public class PaymentNoticeSaveVO implements Serializable {
    private static final long serialVersionUID = 2617718744779453725L;

    @ApiModelProperty(" 付款通知单ID")
    private Long id;

    @ApiModelProperty("加盟商ID")
    @NotNull(message = "加盟商ID不能为空")
    private Long franchiseeId;

    @ApiModelProperty("公司ID")
    @NotNull(message = "公司ID不能为空")
    private Long ouId;

    @ApiModelProperty("公司编码")
    @NotNull(message = "公司编码不能为空")
    private String ouCode;

    @ApiModelProperty("公司名称")
    @NotBlank(message = "公司名称不能为空")
    private String ouName;

    /**
     * 开户银行
     */
    @ApiModelProperty(name = "开户银行")
    @NotBlank(message = "开户银行不能为空")
    private String invBankNo;
    /**
     * 银行账号
     */
    @ApiModelProperty(name = "银行账号")
    @NotBlank(message = "银行账号不能为空")
    private String bankAccount;
    /**
     * 日期
     */
    @ApiModelProperty(name = "日期")
    @NotNull(message = "日期不能为空")
    private LocalDateTime noticeDate;

    /**
     * 收费项目
     */
    @ApiModelProperty(name = "收费项目")
    private String itemCode;

    @ApiModelProperty("税率")
    private String taxRate;

    /**
     * 含税金额
     */
    @ApiModelProperty(name = "含税金额")
    @NotNull(message = "含税金额不能为空")
    private BigDecimal amt;

    /**
     * 通知内容
     */
    @ApiModelProperty(name = "通知内容")
    private String noticeContent;

    @ApiModelProperty(name = "联行号")
    private String uniBankNo;

    @ApiModelProperty(name = "备注")
    private String remark;


    @ApiModelProperty("可开票金额")
    private BigDecimal amtRate;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("门店名称")
    private String storeName;

    @ApiModelProperty(name = "付款通知单明细保存参数")
    private List<PaymentNoticeDSaveVO> paymentNoticeDS;
}
