package com.elitesland.fin.application.facade.vo.recorder;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author lucan.liu
 * @date 2023-09-05 23:14
 */
@Data
public class RecOrderDtlExVo extends RecOrderDtlVO implements Serializable {

    @ApiModelProperty(value = "主表ID")
    private Long masId;

    @ApiModelProperty("收款单明细id")
    private Long recDId;

    @ApiModelProperty("收款单明细表关联id")
    @Column(name = "relate_id", columnDefinition = "bigint(20)  comment '收款单明细表关联id'")
    private Long relateId;

    @ApiModelProperty("第三方收款单明细id")
    @Column(name = "third_order_dt_id", columnDefinition = "varchar(32)  comment '第三方收款单明细id'")
    private String thirdOrderDtId;

    @ApiModelProperty("客户编码")
    @Column(name = "cust_code", columnDefinition = "varchar(32)  comment '客户编码'")
    private String custCode;

    @ApiModelProperty("收款单ID")
    private Long recOrderId;

    @ApiModelProperty(value = "收款单编码")
    private String recOrderNo;

    @ApiModelProperty("收款性质")
    @Column(name = "nature_payment", columnDefinition = "varchar(32)  comment '收款性质'")
    private String naturePayment;

    @ApiModelProperty("销售组织编码")
    @Column(name = "bu_code", columnDefinition = "varchar(32)  comment '销售组织编码'")
    private String buCode;

    @ApiModelProperty("业务员编码")
    @Column(name = "business_code", columnDefinition = "varchar(32)  comment '业务员编码'")
    private String businessCode;

    @ApiModelProperty("币种")
    @Column(name = "curr_code", columnDefinition = "varchar(32)  comment '币种'")
    private String currCode;

    @ApiModelProperty("汇率")
    @Column(name = "exchange_rate", columnDefinition = "varchar(32)  comment '汇率'")
    private String exchangeRate;

    @ApiModelProperty("收款银行账户")
    @Column(name = "rec_bank", columnDefinition = "varchar(32)  comment '收款银行账户'")
    private String recBank;

    @ApiModelProperty("付款银行账户")
    @Column(name = "pay_bank", columnDefinition = "varchar(32)  comment '付款银行账户'")
    private String payBank;


    @ApiModelProperty("第三方收款单号")
    private String sourceNo;

    @ApiModelProperty("收款单类型")
    private String recTypeName;

    @ApiModelProperty("部门名称")
    private String buName;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("业务人员名称")
    private String businessName;

    @ApiModelProperty("收款公司编码")
    private String recOuCode;

    @ApiModelProperty("收款公司名称")
    private String recOuName;

    @ApiModelProperty("单据日期")
    private LocalDateTime createTime;

    @ApiModelProperty("币种")
    private String currName;

    @ApiModelProperty("已核销金额")
    private BigDecimal verAmt;

    @ApiModelProperty("主表总金额")
    private BigDecimal mainTotalAmt;

    @ApiModelProperty("未核销金额")
    private BigDecimal unVerAmt;

    @ApiModelProperty("核销申请中金额")
    private BigDecimal applyVerAmTing;

    @ApiModelProperty(value = "发票号")
    private String invoiceNumber;

    @ApiModelProperty(value = "收款业务类型")
    @SysCode(sys = "yst-fin", mod = "COLL_BUSINESS_TYPE")
    private String recKind;
    private String recKindName;

    @ApiModelProperty(value = "收款单ID")
    private Long recId;

    @ApiModelProperty(value = "第三方收款单号")
    private String outRecDocNo;

    @ApiModelProperty(value = "应收单号")
    private String recDocNo;

    @ApiModelProperty(value = "业务员名称")
    private String salesmanName;

    @ApiModelProperty(value = "外部收款单明细ID")
    private String outRecDId;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty(value = "收款业务类型")
    private String recBuType;

    @ApiModelProperty(value = "收款性质")
    private String recNat;

    @ApiModelProperty(value = "未核销金额")
    private BigDecimal notVerAmt;
}
