package com.elitesland.fin.application.service.rectype;

import com.elitesland.fin.application.convert.rectype.RecTypeOuConvert;
import com.elitesland.fin.application.facade.param.rectype.RecTypeOuParam;
import com.elitesland.fin.application.facade.vo.rectype.RecTypeOuVO;
import com.elitesland.fin.domain.entity.rectype.RecTypeOu;
import com.elitesland.fin.domain.param.rectype.RecTypeOuPageParam;
import com.elitesland.fin.domain.service.rectype.RecTypeOuDomainService;
import com.elitesland.fin.infr.dto.rectype.RecTypeOuDTO;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/4/11 13:42
 */
@Service
@RequiredArgsConstructor
public class RecTypeOuServiceImpl implements RecTypeOuService {

    private final RecTypeOuDomainService recTypeDomainService;

    @SysCodeProc
    @Override
    public PagingVO<RecTypeOuVO> page(RecTypeOuPageParam param) {
        PagingVO<RecTypeOuDTO> page = recTypeDomainService.page(param);
        PagingVO<RecTypeOuVO> recTypeOuVOPagingVO = RecTypeOuConvert.INSTANCE.convertPage(page);
        return recTypeOuVOPagingVO;
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public ApiResult<List<Long>> cancelOu(List<Long> ids) {
        return ApiResult.ok(recTypeDomainService.cancelOu(ids));
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public ApiResult<List<Long>> addOu(RecTypeOuParam param) {
        //转换为实体
        List<RecTypeOu> recTypeOus = RecTypeOuConvert.INSTANCE.paramConvert(param.getRecTypeOuSaveParams());
        //设置实体付款单类型ID
        recTypeOus.forEach(ou->{
            ou.setRecTypeId(param.getRecTypeId());
        });
        return ApiResult.ok(recTypeDomainService.addOu(recTypeOus));
    }
}
