package com.elitesland.fin.domain.entity.aporder;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;

/**
 * @author : Jason.zhao (zhao jun hui)
 * @date : 2022-3-16
 * @desc : 应付单明细
 */
@Entity
@Table(name="ap_order_dtl")
@org.hibernate.annotations.Table(appliesTo = "ap_order_dtl", comment = "应付单明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class ApOrderDtlDO extends BaseModel implements Serializable {


    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '总单ID'")
    private Long masId;

    @Column(name = "source_no", columnDefinition = "varchar(32) comment '来源单号'")
    private String sourceNo;

    @Column(name = "source_line", columnDefinition = "int(10) comment '来源行号'")
    private Integer sourceLine;

    @Column(name = "item_id", columnDefinition = "bigint(20) comment '商品ID'")
    private Long itemId;

    @Column(name = "item_code", columnDefinition = "varchar(32) comment '商品编码'")
    private String itemCode;

    @Column(name = "item_name", columnDefinition = "varchar(32) comment '商品名称'")
    private String itemName;

    @Column(name = "item_type", columnDefinition = "varchar(32) comment '规格型号'")
    private String itemType;

    @Column(name = "small_cate_code", columnDefinition = "varchar(32) comment '小类编码'")
    private String smallCateCode;

    @Column(name = "small_cate_name", columnDefinition = "varchar(32) comment '小类名称'")
    private String smallCateName;

    @Column(name = "uom", columnDefinition = "varchar(32) comment '计量单位'")
    private String uom;

    @Column(name = "uom_name", columnDefinition = "varchar(32) comment '计量单位名称'")
    private String uomName;

    @Column(name = "qty", columnDefinition = "decimal(16,4) comment '数量'")
    private BigDecimal qty;

    @Column(name = "excl_tax_price", columnDefinition = "decimal(18,8) comment '单价'")
    private BigDecimal exclTaxPrice;

    @Column(name = "price", columnDefinition = "decimal(18,8) comment '含税单价'")
    private BigDecimal price;

    @Column(name = "tax_rate", columnDefinition = "decimal(18,8) comment '税率'")
    private BigDecimal taxRate;

    @Column(name = "total_amt", columnDefinition = "decimal(18,8) comment '含税总金额'")
    private BigDecimal totalAmt;

    @Column(name = "excl_tax_amt", columnDefinition = "decimal(18,8) comment '不含税总金额'")
    private BigDecimal exclTaxAmt;

    @Column(name = "tax_amt", columnDefinition = "decimal(18,8) comment '税额'")
    private BigDecimal taxAmt;

    @Column(name = "total_cur_amt", columnDefinition = "decimal(18,8) comment '含税总金额(本位币)'")
    private BigDecimal totalCurAmt;

    @Column(name = "excl_tax_cur_amt", columnDefinition = "decimal(18,8) comment '不含税总金额(本位币)'")
    private BigDecimal exclTaxCurAmt;

    @Column(name = "tax_cur_amt", columnDefinition = "decimal(18,8) comment '税额(本位币)'")
    private BigDecimal taxCurAmt;
    @Column(name = "ver_amt", columnDefinition = "decimal(16,4)  comment '已核销金额'")
    private BigDecimal verAmt;

    @Column(name = "un_ver_amt", columnDefinition = "decimal(16,4)  comment '未核销金额'")
    private BigDecimal unVerAmt;

    @Column(name = "ver_amting", columnDefinition = "decimal(16,4)  comment '核销申请中金额'")
    private BigDecimal applyVerAmTing;
    @Transient
    private Integer version;
    @ApiModelProperty("付款协议编码")
    @Column(name = "protocol_code", columnDefinition = "varchar(64)  comment '付款协议编码'")
    private String protocolCode;

    @Column(name = "source_no_did", columnDefinition = "bigint(20) comment '来源单据明细ID'")
    private Long sourceNoDid;

    @Column(name = "start_cal_date", columnDefinition = "date  comment '起算日期'")
    private LocalDate startCalDate;

    @Column(name = "expire_pay_date", columnDefinition = "date  comment '到期付款日'")
    private LocalDate expirePayDate;

    @ApiModelProperty(value = "单位成本")
    @Column(name = "cost_price", columnDefinition = "decimal(20,8)  comment '单位成本'")
    private BigDecimal costPrice;

    @ApiModelProperty("应付暂估差异")
    @Column(name = "invoice_price_variance", columnDefinition = "decimal(20,8)  comment '应付暂估差异'")
    private BigDecimal invoicePriceVariance;


    @Column(name = "inv_io_id", columnDefinition = "bigint(20) comment '库存流水ID'")
    private Long invIoId;

    @Column(name = "relate_doc_no", columnDefinition = "varchar(32) comment '关联单号(对账单号)'")
    private String relateDocNo;

    @Column(name = "relate_doc_line", columnDefinition = "int(10) comment '关联单行号(对账单)'")
    private Integer relateDocLine;

    @Column(name = "ipv_flag", columnDefinition = "tinyint(1) default 0 comment 'ipv计算标记，是：true,否：false'")
    private Boolean ipvFlag;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApOrderDtlDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ApOrderDtlDO entity = (ApOrderDtlDO) o;
        return getId().equals(entity.getId());
    }
    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}
