package com.elitesland.fin.infr.dto.recorder;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * @author zhiyu.he
 * @date 2022/4/13 11:00
 */
@Data
public class RecOrderDTO implements Serializable {
    private static final long serialVersionUID = -7764390491854570782L;

    @ApiModelProperty("客户收货地址号")
    private String recvAddrNo;

    @ApiModelProperty("客户归类")
    private String custType2;


    @ApiModelProperty(value = "内外部客户")
    private String inOutCust;

    @ApiModelProperty("关联公司编码")
    private String relevanceOuCode;
    private String relevanceOuName;

    private Long id;

    private String sourceNo;

    private String ouCode;

    private Long ouId;

    private String ouName;

    private Long arTypeId;

    private String arTypeName;

    private String arTypeCode;

    private Long recTypeId;

    private String recTypeCode;

    private String recTypeName;

    private String recOrderNo;

    private String currCode;

    private String currName;

    private String localCurrCode;

    private String localCurrName;

    private BigDecimal totalAmt;

    private BigDecimal totalCurAmt;

    private Long auditUserId;

    private String auditUser;

    private LocalDateTime auditDate;

    private String orderState;

    private BigDecimal exchangeRate;

    private Boolean initFlag;

    private BigDecimal realRecAmt;

    private BigDecimal realRecCurAmt;

    private LocalDateTime reDate;

    private Boolean reFlag;

    private String auditRejection;

    private String createMode;

    private String verState;

    private BigDecimal verAmt;

    private Long custId;

    private String custCode;

    private String custName;

    private Long buId;

    private String buCode;

    private String buName;

    private String recOuCode;

    private Long recOuId;

    private String recOuName;

    private String orgCode;

    private Long orgId;

    private String orgName;

    private BigDecimal taxAmt;

    private String recOrderType;

    private Long saleUserId;

    private String saleUser;

    private String remark;

    private String creator;

    private Long createUserId;

    private BigDecimal taxCurAmt;

    private LocalDateTime createTime;

    private String updater;

    private LocalDateTime modifyTime;

    private Integer auditDataVersion;

    private String procInstId;

    private ProcInstStatus procInstStatus;

    private LocalDateTime submitTime;

    private LocalDateTime approvedTime;

    private List<RecOrderDtlDTO> dtlDTOS;

    private String addrNo;

    private String suppAddrNo;

    private String docType;

    private String docType2;

    private String docCls;

    @ApiModelProperty("工作流-流程实例ID")
    private String workflowProcInstId;

    @ApiModelProperty("工作流-流程实例状态")
    private ProcInstStatus workflowProcInstStatus;

    @ApiModelProperty("红冲状态")
    private Boolean redState;

    @ApiModelProperty("红冲来源")
    private String redSourceNo;

    @ApiModelProperty("红冲来源")
    private Long redSourceId;

    @ApiModelProperty("拟定状态")
    private String proposedStatus;
    private String proposedStatusName;

    @ApiModelProperty("扩展信息字段")
    private Map<String, String> extensionInfo;
    public ProcInstStatus getProcInstStatus(){
        if(ObjectUtil.isNull(procInstStatus)){
            return workflowProcInstStatus;
        }else {
            return procInstStatus;
        }
    }

    public String getProcInstId(){
        if(StrUtil.isBlank(procInstId)){
            return workflowProcInstId;
        }else {
            return procInstId;
        }
    }

    @ApiModelProperty("支付凭证")
    private String applyFile;

}
