package com.elitesland.fin.application.facade.vo.account;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitesland.fin.application.facade.base.BaseModelParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
@Data
public class AccountIocParamVO extends AbstractOrderQueryParam implements Serializable {
    private static final long serialVersionUID = -3090471520631246842L;

    @ApiModelProperty("ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("事务码ID集合")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> idList;

    @ApiModelProperty("事务码")
    private String ioCode;

    @ApiModelProperty("事务码名称")
    private String ioName;

    @ApiModelProperty("事务码编码集合")
    private List<String> ioCodeList;

    @ApiModelProperty("事务类型编码 [UDC]FIN:IO_TYPE")
    private String ioType;

    @ApiModelProperty("是否启用，默认为启用 [UDC]FIN:ACTIVE_STATUS")
    private String status;

}
