package com.elitesland.fin.utils;

import com.elitescloud.boot.datasecurity.common.DataSecurityUtil;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;

/**
 * 业务对象权限工具类
 */
public class BusinessSecurityUtil {

    /**
     * 查询权限
     * @param jpaQuery
     * @param doClass
     */
    public static void where(JPAQuery jpaQuery,Class doClass) {
        Predicate securityPredicate = DataSecurityUtil.predicateForJPA(doClass);
        if (securityPredicate != null) {
            jpaQuery.where(securityPredicate);
        }
    }
}
