/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.web.invoice;

import com.alibaba.fastjson.JSON;
import com.cloudt.apm.common.response.ApiResult;
import com.elitesland.fin.application.facade.param.invoice.ApplyRePushParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplyParam;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvDtlVO;
import com.elitesland.fin.application.service.invoice.InvoiceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u53d1\u7968\u7533\u8bf7\u5355"})
@RestController
@RequestMapping(value={"/inv"}, produces={"application/json"})
public class InvoiceController {
    private static final Logger log = LoggerFactory.getLogger(InvoiceController.class);
    private final InvoiceService invoiceService;

    @ApiOperation(value="\u65b0\u589e\u53d1\u7968\u7533\u8bf7\u5355")
    @PostMapping(value={"/create"})
    public ApiResult<Long> create(@RequestBody @Validated InvoiceApplyParam param) {
        log.info("[FOS-INV] create apply, param={}", (Object)param);
        return ApiResult.ok((Object)this.invoiceService.create(param));
    }

    @ApiOperation(value="\u91cd\u65b0\u63a8\u9001")
    @PostMapping(value={"/rePushInvoice"})
    public ApiResult<String> rePushInvoice(@RequestBody List<Long> idList) {
        log.info("[FOS-INV] rePushInvoice apply, param={}", idList);
        try {
            this.invoiceService.rePushSaleInvDDtl(idList);
        }
        catch (Exception e) {
            return ApiResult.fail((String)e.getMessage());
        }
        return ApiResult.ok();
    }

    @ApiOperation(value="\u7ea2\u7968\u5f00\u5177")
    @PostMapping(value={"/redInvoiceOpen"})
    public ApiResult<String> redInvoiceOpen(@RequestBody List<Long> idList) {
        log.info("[FOS-INV] redInvoiceOpen apply, param={}", idList);
        try {
            this.invoiceService.getRedInvoiceResult(idList);
        }
        catch (Exception e) {
            return ApiResult.fail((String)e.getMessage());
        }
        return ApiResult.ok();
    }

    @ApiOperation(value="\u91cd\u65b0\u63a8\u9001")
    @PostMapping(value={"/rePush"})
    public ApiResult<String> rePush(@RequestBody @Validated ApplyRePushParam param) {
        log.info("[FOS-INV] rePush apply, param={}", (Object)param);
        try {
            this.invoiceService.rePushSaleInv(param);
        }
        catch (Exception e) {
            return ApiResult.fail((String)e.getMessage());
        }
        return ApiResult.ok();
    }

    @ApiOperation(value="\u91cd\u65b0\u5f00\u7968")
    @GetMapping(value={"/redraft"})
    public ApiResult<Long> redraft(String applyNo) {
        log.info("[FOS-INV] redraft apply, param={}", (Object)applyNo);
        Long redraftId = this.invoiceService.redraft(applyNo);
        return ApiResult.ok((Object)redraftId);
    }

    @ApiOperation(value="\u7ea2\u51b2\u7533\u8bf7")
    @PostMapping(value={"/red"})
    public ApiResult<String> red(@RequestBody @Validated InvoiceApplyParam param) {
        log.info("[FOS-INV] red apply, param={}", (Object)param);
        try {
            this.invoiceService.create(param);
        }
        catch (Exception e) {
            return ApiResult.fail((String)e.getMessage());
        }
        return ApiResult.ok();
    }

    @ApiOperation(value="\u5f00\u7968\u7ed3\u679c\u67e5\u8be2")
    @PostMapping(value={"/getBlueResult"})
    public ApiResult<?> getBlueResult(@RequestBody List<Long> saleInvDdtlIdList) {
        log.info("[FOS-INV] getBlueResult, saleInvDdtlIdList={}", saleInvDdtlIdList);
        try {
            this.invoiceService.getBlueInvoiceResult(saleInvDdtlIdList);
        }
        catch (Exception e) {
            log.error("[FOS-INV] getBlueResult error", (Throwable)e);
            return ApiResult.fail((String)e.getMessage());
        }
        return ApiResult.ok();
    }

    @ApiOperation(value="\u5f00\u7968\u7ed3\u679cBase64\u67e5\u8be2")
    @PostMapping(value={"/getBase64Result"})
    public ApiResult<?> getBase64Result(@RequestBody List<Long> saleInvDdtlIdList) {
        log.info("[FOS-INV] getBase64Result, saleInvDdtlIdList={}", saleInvDdtlIdList);
        try {
            this.invoiceService.getBase64Result(saleInvDdtlIdList, null);
        }
        catch (Exception e) {
            log.error("[FOS-INV] getBlueResult error", (Throwable)e);
            return ApiResult.fail((String)e.getMessage());
        }
        return ApiResult.ok();
    }

    @ApiOperation(value="\u91cd\u65b0\u63a8\u9001\u5f00\u7968\u5931\u8d25\u6570\u636e")
    @PostMapping(value={"/rePushFail"})
    public ApiResult<String> rePushFail(@RequestBody @Validated ApplyRePushParam param) {
        log.info("[FOS-INV] rePushFail apply, param={}", (Object)JSON.toJSONString((Object)param));
        try {
            this.invoiceService.rePushSaleInvDDtl(param);
        }
        catch (Exception e) {
            return ApiResult.fail((String)e.getMessage());
        }
        return ApiResult.ok();
    }

    @GetMapping(value={"/getDtlList"})
    @ApiOperation(value="\u67e5\u8be2\u5f00\u7968\u660e\u7ec6\u5217\u8868")
    public ApiResult<List<SaleInvDtlVO>> getList(Long masId) {
        List<SaleInvDtlVO> res = this.invoiceService.getDtlList(masId);
        return ApiResult.ok(res);
    }

    public InvoiceController(InvoiceService invoiceService) {
        this.invoiceService = invoiceService;
    }
}

