/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.service.paytype;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.fin.application.convert.paytype.PayTypeConvert;
import com.elitesland.fin.domain.entity.paytype.PayType;
import com.elitesland.fin.domain.entity.paytype.PayTypeDO;
import com.elitesland.fin.domain.param.paytype.PayTypePageParam;
import com.elitesland.fin.domain.service.paytype.PayTypeDomainService;
import com.elitesland.fin.infr.dto.paytype.PayTypeDTO;
import com.elitesland.fin.infr.factory.paytype.PayTypeFactory;
import com.elitesland.fin.infr.repo.paytype.PayTypeRepo;
import com.elitesland.fin.infr.repo.paytype.PayTypeRepoProc;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PayTypeDomainServiceImpl
implements PayTypeDomainService {
    private final PayTypeRepo payTypeRepo;
    private final PayTypeRepoProc payTypeRepoProc;
    private final PayTypeFactory payTypeFactory;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long makeDefault(Long id) {
        List<PayTypeDTO> dtos = this.payTypeRepoProc.findByIds(List.of(id));
        dtos.forEach(dto -> {
            if (dto.getDefaultFlag().booleanValue()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5df2\u9ed8\u8ba4\u72b6\u6001\u4e0d\u80fd\u5728\u9ed8\u8ba4");
            }
        });
        this.payTypeRepoProc.updateDefault();
        return this.payTypeRepoProc.updateDefaultById(id, true);
    }

    @Override
    public PagingVO<PayTypeDTO> page(PayTypePageParam payTypeParam) {
        return this.payTypeFactory.payTypePage(payTypeParam);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> stopEnable(List<Long> ids) {
        if (CollUtil.isEmpty(ids)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8bf7\u9009\u4e2d\u6570\u636e!");
        }
        List<PayTypeDTO> dtos = this.payTypeRepoProc.findByIds(ids);
        dtos.forEach(dto -> {
            if (!dto.getEnableFlag().booleanValue()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5df2\u505c\u7528\u72b6\u6001\u4e0d\u80fd\u5728\u505c\u7528");
            }
        });
        this.payTypeRepoProc.updateEnable(ids, false);
        return ids;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> enable(List<Long> ids) {
        this.payTypeRepoProc.updateEnable(ids, true);
        return ids;
    }

    @Override
    public List<PayTypeDTO> findAll() {
        return this.payTypeRepoProc.findAll();
    }

    @Override
    public PayTypeDTO defaultValue() {
        return this.payTypeRepoProc.defaultValue();
    }

    @Override
    public List<PayTypeDTO> queryByIds(Collection<Long> ids) {
        return this.payTypeRepoProc.findByIds(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(PayType payType) {
        payType.checkNotNull();
        Boolean existCode = this.payTypeRepoProc.existPayCode(payType.getPayTypeCode());
        if (existCode.booleanValue()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4ed8\u6b3e\u5355\u7c7b\u578b\u7f16\u7801\u5df2\u5b58\u5728");
        }
        Boolean existName = this.payTypeRepoProc.existPayName(payType.getPayTypeName());
        if (existName.booleanValue()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4ed8\u6b3e\u5355\u7c7b\u578b\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (this.payTypeRepoProc.isFirst().booleanValue()) {
            payType.setDefault(false);
        } else {
            payType.setDefault(true);
        }
        PayTypeDO typeDO = PayTypeConvert.INSTANCE.convert(payType);
        PayTypeDO typeDO1 = (PayTypeDO)this.payTypeRepo.save(typeDO);
        return typeDO1.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> delete(List<Long> ids) {
        List<PayTypeDTO> dtos = this.payTypeRepoProc.findByIds(ids);
        dtos.forEach(dto -> {
            if (dto.getEnableFlag().booleanValue()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53ea\u80fd\u5220\u9664\u672a\u542f\u7528\u7684\u6570\u636e");
            }
            if (dto.getDefaultFlag().booleanValue()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u9ed8\u8ba4\u7c7b\u578b\u4e0d\u80fd\u5220\u9664");
            }
        });
        this.payTypeRepoProc.deleteByIds(ids);
        return ids;
    }

    public PayTypeDomainServiceImpl(PayTypeRepo payTypeRepo, PayTypeRepoProc payTypeRepoProc, PayTypeFactory payTypeFactory) {
        this.payTypeRepo = payTypeRepo;
        this.payTypeRepoProc = payTypeRepoProc;
        this.payTypeFactory = payTypeFactory;
    }
}

