package com.elitesland.fin.application.facade.vo.writeoff;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.base.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 查询结果.
 *
 * @author shihao.ma
 * @since 2023/9/5
 */
@Getter
@Setter
@ApiModel(description = "查询结果")
public class FinArRecVerApplyRecVO extends BaseModelVO {

    private static final long serialVersionUID = 5122807305952975189L;

    /**
     * 主键
     */
    @ApiModelProperty(value = "主键")
    private Long id;

    /**
     * 主表ID
     */
    @ApiModelProperty(value = "主表ID")
    private Long masId;

    /**
     * 收款单ID
     */
    @ApiModelProperty(value = "收款单ID")
    private Long recId;

    /**
     * 收款单号
     */
    @ApiModelProperty(value = "应收单号")
    private String recDocNo;

    /**
     * 收款单明细ID
     */
    @ApiModelProperty(value = "收款单明细ID")
    private Long recDId;

    /**
     * 外部收款单明细ID
     */
    @ApiModelProperty(value = "外部收款单明细ID")
    private String outRecDId;

    /**
     * 第三方收款单号
     */
    @ApiModelProperty(value = "第三方收款单号")
    private String outRecDocNo;

    /**
     * 应收单类型ID
     */
    @ApiModelProperty(value = "收款单类型ID")
    private Long recTypeId;

    /**
     * 应收单类型编码
     */
    @ApiModelProperty(value = "收款单类型编码")
    private String recTypeCode;

    /**
     * 应收单类型名称
     */
    @ApiModelProperty(value = "收款单类型名称")
    private String recTypeName;

    /**
     * 公司ID
     */
    @ApiModelProperty(value = "公司ID")
    private Long ouId;

    /**
     * 公司编码
     */
    @ApiModelProperty(value = "公司编码")
    private String ouCode;

    /**
     * 公司名称
     */
    @ApiModelProperty(value = "公司名称")
    private String ouName;

    /**
     * 部门ID
     */
    @ApiModelProperty(value = "部门ID")
    private Long buId;

    /**
     * 部门编码
     */
    @ApiModelProperty(value = "部门编码")
    private String buCode;

    /**
     * 部门名称
     */
    @ApiModelProperty(value = "部门名称")
    private String buName;

    /**
     * 业务员ID
     */
    @ApiModelProperty(value = "业务员ID")
    private Long salesmanId;

    /**
     * 业务员编码
     */
    @ApiModelProperty(value = "业务员编码")
    private String salesmanCode;

    /**
     * 业务员名称
     */
    @ApiModelProperty(value = "业务员名称")
    private String salesmanName;

    /**
     * 发票号
     */
    @ApiModelProperty(value = "发票号")
    private String invoiceNumber;

    /**
     * 开票日期
     */
    @ApiModelProperty(value = "开票日期")
    private LocalDateTime invDate;

    /**
     * 发票类型
     */
    @ApiModelProperty(value = "发票类型")
    private String invType;

    /**
     * 客户ID
     */
    @ApiModelProperty(value = "客户ID")
    private Long custId;

    /**
     * 客户编码
     */
    @ApiModelProperty(value = "客户编码")
    private String custCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(value = "客户名称")
    private String custName;

    /**
     * 客户名称
     */
    @ApiModelProperty(value = "客户名称")
    private String recBuType;

    /**
     * 收款性质
     */
    @ApiModelProperty(value = "收款性质")
    private String recNat;

    /**
     * 含税总金额
     */
    @ApiModelProperty(value = "含税总金额")
    private BigDecimal totalAmt;

    /**
     * 收款银行账户
     */
    @ApiModelProperty(value = "收款银行账户")
    private String recBank;

    /**
     * 付款银行账户
     */
    @ApiModelProperty(value = "付款银行账户")
    private String payBank;

    /**
     * 收款单单据日期
     */
    @ApiModelProperty(value = "收款单单据日期")
    private LocalDateTime recDate;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 未核销金额
     */
    @ApiModelProperty(value = "未核销金额")
    private BigDecimal notVerAmt;

    /**
     * 本次核销金额
     */
    @ApiModelProperty(value = "本次核销金额")
    private BigDecimal verAmt;

    @ApiModelProperty(value = "收款单明细")
    private List<FinArRecVerApplyRecVO> recList;

    @ApiModelProperty(value = "内外部客户")
    @SysCode(sys = "yst-sale", mod = "CUST_IN_OUT")
    private String inOutCust;
    private String inOutCustName;

    @ApiModelProperty("关联公司编码")
    private String relevanceOuCode;
    @ApiModelProperty("关联公司名称")
    private String relevanceOuName;
}
