package com.elitesland.fin.application.service.creditaccount;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.creditaccount.CreditAccountDTO;
import com.elitesland.fin.application.facade.param.creditaccount.*;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountDetailVO;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountPageVO;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountSnapshotVo;
import com.elitesland.fin.entity.creditaccount.CreditAccountSnapshotDO;

import java.util.List;

public interface CreditAccountService {
    PagingVO<CreditAccountPageVO> pageSearch(CreditAccountPageParam accountPageParam);

    Object saveOrUpdate(CreditAccountSaveParam param);

    CreditAccountDetailVO queryDetailById(Long id);

    void updateStatus(CreditAccountStatusParam param);

    List<CreditAccountDTO> getAccountByAccountParam(CreditAccountParam param);

    PagingVO<CreditAccountSnapshotVo> querySnapshot(CreditAccountSnapshotParam param);

    void creditAccountSnapshot(String param);

    List<CreditAccountSnapshotDO> selectCreditAccountSnapshotByParam(CreditAccountSnapshotParam queryParam);

    void updateRelateAccountCodeById(Long id, String relateAccountCode);

    void updateRelateAccount(String objectCode, String relateAccountCode);
}
