package com.elitesland.fin.application.service.workflow.invoice;

import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.enums.ProcInstStatus;

import java.util.ArrayList;


public interface InvoiceRedraftCallbackService {

    /**
     * 回调
     *
     * @param businessKey    业务key
     * @param procInstStatus 业务状态
     */
    void processStatusChange(String businessKey, ProcInstStatus procInstStatus, CommentInfo commentInfo);

    /**
     * 根据公司和角色编码查找对应处理人
     *
     * @param businessKey  业务主键
     * @param customParams 自定义编码
     * @return 用户id
     */
    ArrayList<String> taskAssignee(String businessKey, String customParams);

}
