package com.elitesland.fin.application.web.account;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.vo.account.AccountIocParamVO;
import com.elitesland.fin.application.facade.vo.account.AccountIocRespVO;
import com.elitesland.fin.application.facade.vo.account.AccountIocSaveVO;
import com.elitesland.fin.application.service.account.AccountIocService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.val;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
@RestController
@RequestMapping("/account/ioc")
@RequiredArgsConstructor
@Api(value = "账户事务码", tags = {"账户事务码"})
public class AccountIocController {

    private final AccountIocService accountIocService;

    /**
     * 新增账户事务码数据
     *
     * @param saveVo 新增账户事务码数据
     * @return 新增账户事务码ID
     */
    @PostMapping("/createOne")
    @ApiOperation("新增账户事务码数据")
    public ApiResult<Long> createOne(@RequestBody AccountIocSaveVO saveVo) {
        return accountIocService.createOne(saveVo);
    }

    /**
     * 修改账户事务码数据
     *
     * @param saveVo 修改账户事务码对象
     * @return 账户事务码ID
     */
    @PutMapping("/update")
    @ApiOperation("修改账户事务码数据")
    public ApiResult<Long> update(@RequestBody AccountIocSaveVO saveVo) {
        return accountIocService.update(saveVo);
    }

    /**
     * 通过账户事务码ID查询单条数据
     *
     * @param id 账户事务码ID
     * @return 单条账户事务码数据
     */
    @GetMapping("/findIdOne/{id}")
    @ApiOperation("通过账户事务码ID查询单条数据")
    public ApiResult<AccountIocRespVO> findIdOne(@PathVariable Long id) {
        return accountIocService.findIdOne(id);
    }

    /**
     * 分页查询账户事务码
     *
     * @param param 分类查询、分页和排序对象
     * @return 多条账户事务码数据
     */
    @PostMapping("/search")
    @ApiOperation("分页查询账户事务码")
    public ApiResult<PagingVO<AccountIocRespVO>> search(@RequestBody AccountIocParamVO param) {
        val ret = accountIocService.search(param);
        return ApiResult.ok(ret);
    }

    /**
     * 根据入参查询账户事务码
     *
     * @param param 分类查询、分页和排序对象
     * @return 多条账户事务码数据
     */
    @PostMapping("/select")
    @ApiOperation("根据入参查询账户事务码")
    public ApiResult<List<AccountIocRespVO>> select(@RequestBody AccountIocParamVO param) {
        val ret = accountIocService.select(param);
        return ApiResult.ok(ret);
    }

    /**
     * 根据账户事务码ID批量逻辑删除
     *
     * @param ids 账户事务码ID集合
     * @return 账户事务码ID集合
     */
    @DeleteMapping("/deleteBatch")
    @ApiOperation("根据账户事务码ID批量逻辑删除")
    public ApiResult<String> deleteBatch(@RequestBody List<Long> ids) {
        return accountIocService.deleteBatch(ids);
    }

}
