package com.elitesland.fin.application.web.workflow;


import com.elitesland.fin.application.service.workflow.invoice.InvoiceRedraftCallbackService;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;

@Slf4j
@RestController
@RequestMapping(WorkflowConstant.WORKFLOW + "INVOICE_REDRAFT" + WorkflowConstant.CALLBACK)
@Transactional
@RequiredArgsConstructor
public class InvoiceRedraftCallbackController implements WorkflowCallBack {

    private final InvoiceRedraftCallbackService invoiceRedraftCallbackService;

    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("动态指定任务负责人参数: {}", payload);
        return WorkflowResult.success(new ArrayList<>());
    }

    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调:{}", payload.toString());
        return WorkflowResult.success(null);
    }

    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("流程状态变化回调参数:{}", payload);
        invoiceRedraftCallbackService.processStatusChange(payload.getBusinessKey(), payload.getProcInstStatus(), payload.getCommentInfo());
        return WorkflowResult.success(null);
    }
}
