package com.elitesland.fin.domain.entity.invoiceredraft;


import com.elitesland.fin.domain.entity.base.BaseWorkflowModel;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author gyj
 * @description
 * @Date 2023/7/14
 */
@Entity
@Table(name = "invoice_redraft")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "invoice_redraft", comment = "重新开票单")
@Data
@Accessors(chain = true)
@ApiModel(value = "invoice_redraft", description = "重新开票单")
public class InvoiceRedraftDO extends BaseWorkflowModel {

    @Column(name = "orig_apply_no", columnDefinition = "varchar(32) comment '换开申请单号'")
    private String origApplyNo;

    @Column(name = "invoice_no", columnDefinition = "varchar(32) comment '发票号码'")
    private String invoiceNo;

    @Column(name = "serial_no", columnDefinition = "varchar(32) comment '流水号'")
    private String serialNo;

    @Column(name = "invoice_amt", columnDefinition = "decimal(18,8) comment '开票金额'")
    private BigDecimal invoiceAmt;

    @Column(name = "invoice_date", columnDefinition = "datetime(6) comment '开票日期'")
    private LocalDateTime invoiceDate;

    @Column(name = "invoice_type", columnDefinition = "varchar(32) comment '发票类型'")
    private String invoiceType;

    @Column(name = "invoice_deduction", columnDefinition = "int(2) comment '发票是否抵扣 0-否 1-是'")
    private Integer invoiceDeduction;

    @Column(name = "redraft_reason", columnDefinition = "varchar(128) comment '换开理由'")
    private String redraftReason;

    @Column(name = "attachment_id", columnDefinition = "varchar(256) comment '附件id'")
    private String attachmentId;

    @Column(name = "doc_status", columnDefinition = "varchar(32) comment '单据状态'")
    private String docStatus;

    @Column(name = "redraft_apply_no", columnDefinition = "varchar(40) comment '新开票申请单号'")
    private String redraftApplyNo;

    @Column(name = "main_cust_code", columnDefinition = "varchar(32) comment '主客户编码'")
    private String mainCustCode;

    @Column(name = "main_cust_name", columnDefinition = "varchar(32) comment '主客户名称'")
    private String mainCustName;

    @Column(name = "main_cust_id", columnDefinition = "bigint(20) comment '主客户id'")
    private Long mainCustId;

    @Column(name = "cust_id", columnDefinition = "bigint(20) comment '客户ID'")
    private Long custId;

    @Column(name = "cust_code", columnDefinition = "varchar(32) comment '客户编码'")
    private String custCode;

    @Column(name = "cust_name", columnDefinition = "varchar(32) comment '客户名称'")
    private String custName;

    @Column(name = "inv_title", columnDefinition = "varchar(64) comment '开票抬头'")
    private String invTitle;

    @Column(name = "inv_title_type", columnDefinition = "varchar(64) comment '开票抬头类型'")
    private String invTitleType;

    @Column(name = "taxer_no", columnDefinition = "varchar(32) comment '纳税人识别号'")
    private String taxerNo;

}
