package com.elitesland.fin.repo.account;


import com.elitesland.fin.entity.account.AccountRuleConfigDtlDO;
import com.elitesland.fin.entity.account.QAccountRuleConfigDtlDO;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
@Slf4j
@Component
@AllArgsConstructor
public class AccountRuleConfigDtlRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    public void updateDynamically(List<AccountRuleConfigDtlDO> accountRuleConfigDtlDOList) {
        val jpaQDO = QAccountRuleConfigDtlDO.accountRuleConfigDtlDO;
        for (AccountRuleConfigDtlDO param : accountRuleConfigDtlDOList) {
            JPAUpdateClause updateClause = jpaQueryFactory.update(jpaQDO);
            if (StringUtils.isNotBlank(param.getIoCode())) {
                updateClause.set(jpaQDO.ioCode, param.getIoCode());
            }
            if (param.getPriorityNo() != null) {
                updateClause.set(jpaQDO.priorityNo, param.getPriorityNo());
            }
            updateClause.set(jpaQDO.modifyTime, LocalDateTime.now());
            updateClause.where(jpaQDO.id.eq(param.getId())).execute();
        }
    }

    public void deleteByParam(AccountRuleConfigDtlDO accountRuleConfigDtlDO) {
        val jpaQDO = QAccountRuleConfigDtlDO.accountRuleConfigDtlDO;
        JPADeleteClause jpaDeleteClause=jpaQueryFactory.delete(jpaQDO);
        if(accountRuleConfigDtlDO.getMasId() !=null){
            jpaDeleteClause.where(jpaQDO.masId.eq(accountRuleConfigDtlDO.getMasId()));
        }
        jpaDeleteClause.execute();


    }

}