package com.elitesland.fin.repo.writeoff;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.fin.domain.entity.writeoff.FinApPayVerApplySettleDO;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import com.elitesland.fin.domain.entity.writeoff.QFinApPayVerApplySettleDO;
import java.util.Collection;
import java.util.List;

/**
 * 核销申请.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Repository
public class FinApPayVerApplySettleRepoProc extends BaseRepoProc<FinApPayVerApplySettleDO> {

    private static final QFinApPayVerApplySettleDO QDO = QFinApPayVerApplySettleDO.finApPayVerApplySettleDO;

    protected FinApPayVerApplySettleRepoProc() {
        super(QDO);
    }

    public List<FinApPayVerApplySettleDO> listByMasIds(Collection<Long> masIds) {
        return jpaQueryFactory.select(QDO)
                .from(QDO)
                .where(QDO.masId.in(masIds))
                .fetch();
    }

    @Transactional(rollbackFor = Exception.class)
    public Long updateBatchNo(Collection<Long> masIds, String bachNo) {
        return super.updateValueByValue(QDO.batchNo, bachNo, QDO.masId, masIds);
    }

	@Transactional(rollbackFor = Exception.class)
	public Long updateVerFlag(Collection<Long> masIds, String verFlag) {
		return super.updateValueByValue(QDO.verFlag, verFlag, QDO.masId, masIds);
	}

/*
	*/
/**
	 * 更新核销批次号-应收
	 * @param arDid
	 * @param batchNo
	 * @return
	 *//*

	@Transactional(rollbackFor = Exception.class)
	public Long updateBatchNoByApDid(String apDid, String batchNo) {
		return super.updateValueByValue(QDO.batchNo, batchNo, QDO.outArDId, apDid);
	}
*/

	/**
	 * 更新核销批次号-应收
	 * @param rcDid
	 * @param batchNo
	 * @return
	 *//*
	@Transactional(rollbackFor = Exception.class)
	public Long updateBatchNoByRcDid(String rcDid, String batchNo) {
		return super.updateValueByValue(QDO.batchNo, batchNo, QDO.outRecDId, rcDid);
	}*/
}
