/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.invoice.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.el.coordinator.core.common.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitesland.fin.application.convert.saleinv.SaleInvConvert;
import com.elitesland.fin.application.facade.dto.mq.InvoiceRetryProcessMqMessageDTO;
import com.elitesland.fin.application.facade.param.invoice.ApplyRePushParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplyParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplySaveParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceRedApplySaveParam;
import com.elitesland.fin.application.facade.param.saleinv.SaleInvEmailParam;
import com.elitesland.fin.application.facade.param.saleinv.SaleInvStatusParam;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceRedApplyResult;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceRedSaveRespVO;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceSaveVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvDtlVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvdDtlVO;
import com.elitesland.fin.application.service.invoice.InvoiceApplyService;
import com.elitesland.fin.application.service.invoice.InvoiceDtlDomainService;
import com.elitesland.fin.application.service.invoice.InvoiceSaveService;
import com.elitesland.fin.application.service.invoice.InvoiceService;
import com.elitesland.fin.application.service.invoice.impl.AbstractInvoiceSaveServiceImpl;
import com.elitesland.fin.application.service.saleinv.SaleInvService;
import com.elitesland.fin.application.service.writeoff.RmiUdcService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.invoiceredraft.InvoiceRedraftDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDtlDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvdDtlDO;
import com.elitesland.fin.dto.invoice.InvoiceApplyRpcDTO;
import com.elitesland.fin.infinity.aisino.service.AisinoPayloadService;
import com.elitesland.fin.infinity.aisino.service.AisinoService;
import com.elitesland.fin.infinity.aisino.vo.param.AisinoCoverParamPayload;
import com.elitesland.fin.infinity.aisino.vo.param.AisinoRedInvoiceParam;
import com.elitesland.fin.infinity.aisino.vo.param.AisinoRedInvoiceResultParam;
import com.elitesland.fin.infinity.aisino.vo.resp.AisinoRedGetResultResp;
import com.elitesland.fin.infinity.aisino.vo.resp.AisinoRedInitialResultResp;
import com.elitesland.fin.infinity.aisino.vo.resp.AisinoRedOpenResultResp;
import com.elitesland.fin.infinity.aisino.vo.resp.AisinoRedSaveResultResp;
import com.elitesland.fin.infinity.aisino.vo.resp.InvoiceRedInitialRespVO;
import com.elitesland.fin.infinity.aisino.vo.resp.RedInvoiceOpenResp;
import com.elitesland.fin.infinity.aisino.vo.resp.RedInvoiceResultResp;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDtlDTO;
import com.elitesland.fin.infr.repo.invoiceredraft.InvoiceRedraftRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvDtlRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvdDtlRepo;
import com.elitesland.fin.param.saleinv.InvoiceDetailSaveParam;
import com.elitesland.fin.param.saleinv.InvoiceQueryParam;
import com.elitesland.fin.repo.invoice.InvoiceAwaitRepoProc;
import com.elitesland.order.param.SalDoUpdateInvoiceNoRpcDTO;
import com.elitesland.order.service.SalDoRpcService;
import com.elitesland.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.support.provider.item.service.ItmItemRpcService;
import com.elitesland.workflow.enums.ProcInstStatus;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class InvoiceServiceImpl
implements InvoiceService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceServiceImpl.class);
    private final InvoiceApplyService invoiceApplyService;
    private final InvoiceSaveService invoiceSaveService;
    private final InvoiceRedraftRepo invoiceRedraftRepo;
    private final SaleInvRepo saleInvRepo;
    private final SaleInvService saleInvService;
    private final InvoiceDtlDomainService invoiceDtlDomainService;
    private final SaleInvDtlRepo saleInvDtlRepo;
    private final ItmItemRpcService itmItemRpcService;
    @Autowired
    private AbstractInvoiceSaveServiceImpl abstractInvoiceSaveService;
    @Autowired
    private RmiUdcService rmiSysUdcRpcService;
    private final SaleInvdDtlRepo saleInvdDtlRepo;
    private final AisinoService aisinoService;
    private final AisinoPayloadService aisinoPayloadService;
    private final TaskExecutor taskExecutor;
    private final InvoiceAwaitRepoProc invoiceAwaitRepoProc;
    private final MessageQueueTemplate messageQueueTemplate;
    private final SalDoRpcService salDoRpcService;

    @Override
    public long create(InvoiceApplyParam param) {
        this.checeInvParam(param);
        InvoiceQueryParam queryParam = new InvoiceQueryParam();
        queryParam.setSourceDocId(param.getIds());
        List<InvoiceApplyRpcDTO> applyRpcDTO = this.invoiceApplyService.queryIdBySource(queryParam);
        if (CollUtil.isNotEmpty(applyRpcDTO)) {
            throw new BusinessException("\u5355\u636e\u5df2\u5f00\u7968\uff0c\u4e0d\u80fd\u91cd\u590d\u64cd\u4f5c");
        }
        List<InvoiceSaveVO> save = this.invoiceSaveService.save(param);
        if (!CollUtil.isEmpty(save)) {
            return save.get(0).getApplyId();
        }
        return 0L;
    }

    @Override
    @Transactional
    public Long redraft(String applyNo) {
        InvoiceRedraftDO invRedraftDO = this.invoiceRedraftRepo.findByOrigApplyNo(applyNo);
        if (!ObjectUtils.isEmpty((Object)((Object)invRedraftDO)) && !ObjectUtils.isEmpty((Object)invRedraftDO.getWorkflowProcInstStatus())) {
            throw new BusinessException("\u5b58\u5728\u672a\u5b8c\u7ed3\u7684\u91cd\u65b0\u5f00\u7968\u5ba1\u6279");
        }
        InvoiceApplyRpcDTO applyRpcDTO = this.invoiceApplyService.queryIdByApplyNo(applyNo);
        Assert.notNull((Object)applyRpcDTO.getApplyId(), (String)(applyNo + " \u5355\u636e\u4e0d\u5b58\u5728"));
        InvoiceRedraftDO invoiceRedraftDO = this.saveInvoiceRedraft(applyRpcDTO);
        return invoiceRedraftDO.getId();
    }

    @Override
    @Transactional
    public void rePushSaleInvDDtl(List<Long> idList) {
        log.info("\u91cd\u65b0\u63a8\u9001\u9500\u552e\u53d1\u7968\u660e\u7ec6:{}", idList);
        List allById = this.saleInvdDtlRepo.findAllById(idList);
        if (CollectionUtils.isEmpty((Collection)allById)) {
            throw new BusinessException("\u672a\u627e\u5230\u5355\u636e");
        }
        List<Long> list = allById.stream().filter(v -> Strings.isBlank((String)v.getOriginalContent())).map(SaleInvdDtlDO::getMasId).toList();
        Map<Object, Object> saleInvDOMap = new HashMap();
        Map<Object, Object> saleInvDtlMap = new HashMap();
        if (!CollectionUtils.isEmpty(list)) {
            List<SaleInvDtlDO> saleInvDtlDOS;
            List saleInvDOS = this.saleInvRepo.findAllById(list);
            if (!CollectionUtils.isEmpty((Collection)saleInvDOS)) {
                saleInvDOMap = saleInvDOS.stream().collect(Collectors.toMap(BaseModel::getId, v -> v));
            }
            if (!CollectionUtils.isEmpty(saleInvDtlDOS = this.saleInvDtlRepo.findAllByMasIdIn(list))) {
                saleInvDtlMap = saleInvDtlDOS.stream().collect(Collectors.groupingBy(SaleInvDtlDO::getMasId));
            }
        }
        for (SaleInvdDtlDO invdDtlDO : allById) {
            try {
                if (Strings.isNotBlank((String)invdDtlDO.getOriginalContent())) {
                    this.abstractInvoiceSaveService.invoiceReApply(invdDtlDO);
                    continue;
                }
                InvoiceApplySaveParam saveParam = new InvoiceApplySaveParam();
                Long masId = invdDtlDO.getMasId();
                SaleInvDO saleInvDO = (SaleInvDO)saleInvDOMap.get(masId);
                BeanUtils.copyProperties((Object)saleInvDO, (Object)saveParam);
                List saleInvDtlDOS = (List)saleInvDtlMap.get(masId);
                if (saleInvDtlDOS != null && !saleInvDtlDOS.isEmpty()) {
                    List<InvoiceDetailSaveParam> detailList = saleInvDtlDOS.stream().map(detail -> {
                        InvoiceDetailSaveParam invoiceDetail = new InvoiceDetailSaveParam();
                        BeanUtils.copyProperties((Object)detail, (Object)invoiceDetail);
                        return invoiceDetail;
                    }).toList();
                    saveParam.setDetails(detailList);
                }
                this.abstractInvoiceSaveService.invoiceApply(saveParam, invdDtlDO);
            }
            catch (Exception e) {
                log.error("\u53d1\u7968\u91cd\u63a8\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private void sendEmail(final List<SaleInvdDtlDO> emailList) {
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCommit() {
                CompletableFuture.supplyAsync(() -> {
                    emailList.forEach(saleInvdDtlDO -> {
                        SaleInvEmailParam param = new SaleInvEmailParam();
                        param.setIds((List<Long>)new ArrayList<Long>(){
                            {
                                this.add(saleInvdDtlDO.getMasId());
                            }
                        });
                        param.setEmail(null);
                        InvoiceServiceImpl.this.saleInvService.sendEmail(param);
                    });
                    return null;
                }, (Executor)InvoiceServiceImpl.this.taskExecutor);
            }
        });
    }

    @Override
    @Transactional
    public void rePushSaleInv(ApplyRePushParam param) {
        List<SaleInvDO> applyList = this.saleInvRepo.findByApplyNoIn(param.getApplyNoList());
        if (CollectionUtils.isEmpty(applyList)) {
            throw new BusinessException("\u672a\u627e\u5230\u5355\u636e");
        }
        List<Long> idList = applyList.stream().map(BaseModel::getId).toList();
        List<SaleInvdDtlDO> allByMasIdIn1 = this.saleInvdDtlRepo.findAllByMasIdIn(idList);
        Map<Object, Object> saleInvdDtlMap = CollectionUtil.isNotEmpty(allByMasIdIn1) ? allByMasIdIn1.stream().collect(Collectors.groupingBy(SaleInvdDtlDO::getMasId)) : new HashMap();
        List<SaleInvDtlDO> allByMasIdIn = this.saleInvDtlRepo.findAllByMasIdIn(idList);
        Map<Object, Object> saleInvDtlMap = CollectionUtil.isNotEmpty(allByMasIdIn) ? allByMasIdIn.stream().collect(Collectors.groupingBy(SaleInvDtlDO::getMasId)) : new HashMap();
        ArrayList invoiceApplySaveParamList = new ArrayList();
        ArrayList deleteSaleInvDDtlIdList = new ArrayList();
        applyList.forEach(apply -> {
            List saleInvdDtlDOS = (List)saleInvdDtlMap.get(apply.getId());
            if (CollectionUtil.isNotEmpty((Collection)saleInvdDtlDOS)) {
                saleInvdDtlDOS.forEach(saleInvdDtlDO -> {
                    if (Objects.equals(saleInvdDtlDO.getInvState(), UdcEnum.INV_STATE_SUCCESS.getValueCode())) {
                        throw new BusinessException("\u5355\u636e" + apply.getApplyNo() + "\u5df2\u5f00\u7968\u6210\u529f\uff0c\u4e0d\u80fd\u91cd\u590d\u64cd\u4f5c");
                    }
                    deleteSaleInvDDtlIdList.add(saleInvdDtlDO.getId());
                });
            }
            InvoiceApplySaveParam invoiceApplySaveParam = new InvoiceApplySaveParam();
            BeanUtils.copyProperties((Object)apply, (Object)invoiceApplySaveParam);
            ArrayList<InvoiceDetailSaveParam> detail = new ArrayList<InvoiceDetailSaveParam>();
            List saleInvDtlDOS = (List)saleInvDtlMap.get(apply.getId());
            saleInvDtlDOS.forEach(v -> {
                InvoiceDetailSaveParam invoiceDetailSaveParam = new InvoiceDetailSaveParam();
                BeanUtils.copyProperties((Object)v, (Object)invoiceDetailSaveParam);
                invoiceDetailSaveParam.setLineNo(v.getSourceLine());
                detail.add(invoiceDetailSaveParam);
            });
            invoiceApplySaveParam.setDetails(detail);
            invoiceApplySaveParamList.add(invoiceApplySaveParam);
        });
        if (CollectionUtil.isNotEmpty(invoiceApplySaveParamList)) {
            invoiceApplySaveParamList.forEach(invoiceApplySaveParam -> this.abstractInvoiceSaveService.invoiceApply((InvoiceApplySaveParam)invoiceApplySaveParam, null));
        }
    }

    @Override
    @Transactional
    public void getBlueInvoiceResult(List<Long> idList) {
        log.info("\u83b7\u53d6\u5f00\u7968\u7ed3\u679c\u5165\u53c2\u660e\u7ec6:{}", idList);
        List allById = this.saleInvdDtlRepo.findAllById(idList);
        if (CollectionUtils.isEmpty((Collection)allById)) {
            throw new BusinessException("\u672a\u627e\u5230\u5f00\u7968\u5355\u636e");
        }
        ArrayList<SaleInvdDtlDO> successInvoiceList = new ArrayList<SaleInvdDtlDO>();
        for (SaleInvdDtlDO invdDtlDO : allById) {
            Boolean success = null;
            try {
                success = this.abstractInvoiceSaveService.getInvoiceInfoByFlowNo(invdDtlDO);
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u5f00\u7968\u7ed3\u679c\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
                continue;
            }
            if (success == null || !success.booleanValue()) continue;
            List<SaleInvdDtlDO> saleInvdDtlDOS = this.getBase64Result(List.of(invdDtlDO.getId()), null);
            successInvoiceList.addAll(saleInvdDtlDOS);
        }
        if (CollectionUtil.isNotEmpty(successInvoiceList)) {
            Map<Long, String> applyIdAndInvNoMap = successInvoiceList.stream().collect(Collectors.toMap(SaleInvdDtlDO::getMasId, SaleInvdDtlDO::getInvNo));
            List<SaleInvDtlDO> saleInvDtlDOList = this.saleInvDtlRepo.findAllByMasIdIn(applyIdAndInvNoMap.keySet());
            Map<Object, Object> saleInvDtlMap = CollectionUtil.isNotEmpty(saleInvDtlDOList) ? saleInvDtlDOList.stream().collect(Collectors.groupingBy(SaleInvDtlDO::getMasId)) : new HashMap();
            List saleInvList = this.saleInvRepo.findAllById(applyIdAndInvNoMap.keySet());
            log.info("\u5f00\u7968\u6210\u529f\u56de\u5199\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)saleInvList));
            if (CollectionUtil.isNotEmpty((Collection)saleInvList)) {
                SaleInvStatusParam saleInvStatusParam = new SaleInvStatusParam();
                saleInvStatusParam.setApplyNoList(saleInvList.stream().map(SaleInvDO::getApplyNo).toList());
                saleInvStatusParam.setInvState(UdcEnum.INVOICE_AWAIT_STATUS_SUCCESS.getValueCode());
                this.invoiceAwaitRepoProc.updateInvState(saleInvStatusParam);
                for (SaleInvDO saleInvDO : saleInvList) {
                    List saleInvDtlDOS = (List)saleInvDtlMap.get(saleInvDO.getId());
                    if (!CollectionUtil.isNotEmpty((Collection)saleInvDtlDOS)) continue;
                    List<String> docNoList = saleInvDtlDOS.stream().map(SaleInvDtlDO::getDocNo).toList();
                    String invNo = applyIdAndInvNoMap.get(saleInvDO.getId());
                    SalDoUpdateInvoiceNoRpcDTO salDoUpdateInvoiceNoRpcDTO = new SalDoUpdateInvoiceNoRpcDTO();
                    salDoUpdateInvoiceNoRpcDTO.setDocNoList(docNoList);
                    salDoUpdateInvoiceNoRpcDTO.setInvoiceNo(invNo);
                    this.salDoRpcService.updateInvoiceNo(salDoUpdateInvoiceNoRpcDTO);
                }
            }
            this.sendEmail(successInvoiceList);
        }
    }

    @Override
    @Transactional
    public List<SaleInvdDtlDO> getBase64Result(List<Long> saleInvIdList, List<SaleInvdDtlDO> saleInvDtlDOList) {
        log.info("[FOS-INV] getBase64Result, saleInvIdList={}", saleInvIdList);
        List<Object> allById = new ArrayList();
        if (CollectionUtil.isNotEmpty(saleInvDtlDOList)) {
            allById = saleInvDtlDOList;
        } else if (CollectionUtil.isNotEmpty(saleInvIdList)) {
            allById = this.saleInvdDtlRepo.findAllById(saleInvIdList);
        }
        List<CompletableFuture> futures = allById.stream().map(saleInvdDtlDO -> CompletableFuture.supplyAsync(() -> {
            try {
                Boolean base64Result = this.abstractInvoiceSaveService.getBase64Result((SaleInvdDtlDO)saleInvdDtlDO);
                if (base64Result != null && base64Result.booleanValue()) {
                    return saleInvdDtlDO;
                }
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u53d1\u7968\u6587\u4ef6\u7ed3\u679c\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            }
            return null;
        }, (Executor)this.taskExecutor)).toList();
        List<SaleInvdDtlDO> result = futures.stream().map(CompletableFuture::join).filter(Objects::nonNull).collect(Collectors.toList());
        if (!result.isEmpty()) {
            this.saleInvdDtlRepo.saveAll(result);
        }
        return result;
    }

    @Override
    public InvoiceRedApplyResult redInvoice(InvoiceRedApplySaveParam saveParam) {
        InvoiceRedApplyResult result = new InvoiceRedApplyResult();
        AisinoRedInitialResultResp response = null;
        try {
            String aisinoRedPayload = this.aisinoPayloadService.convertRedInitial(saveParam);
            response = this.aisinoService.redInvoiceInitial(this.aisinoPayloadService.assembleAisinoPayload(aisinoRedPayload, saveParam.getSaleTaxNo()), aisinoRedPayload);
        }
        catch (Exception e) {
            result.setRedFailCause("\u7ea2\u7968\u521d\u59cb\u5316\u5931\u8d25:" + e.getMessage());
        }
        if (response != null && Objects.equals(response.getCODE(), "0000")) {
            InvoiceRedInitialRespVO invoiceRedInitialRespVO = null;
            AisinoRedSaveResultResp redSaveResp = null;
            try {
                invoiceRedInitialRespVO = response.getDATA();
                result.setRedInvoiceInitData(invoiceRedInitialRespVO);
                String redSaveParam = this.aisinoPayloadService.convertRedSave(invoiceRedInitialRespVO);
                AisinoCoverParamPayload redSavePayload = this.aisinoPayloadService.assembleAisinoPayload(redSaveParam, saveParam.getSaleTaxNo());
                redSaveResp = this.aisinoService.redInvoiceSave(redSavePayload, redSaveParam);
            }
            catch (Exception e) {
                result.setRedFailCause("\u7ea2\u7968\u4fdd\u5b58\u5931\u8d25:" + e.getMessage());
            }
            if (redSaveResp != null && Objects.equals(redSaveResp.getCODE(), "0000")) {
                InvoiceRedSaveRespVO data1 = redSaveResp.getDATA();
                InvoiceRedSaveRespVO.Qrjkpfpqx qrjkpfpxx = data1.getQRJKPFPXX();
                if (!Objects.equals(invoiceRedInitialRespVO.getQRJKPBZ(), "Y")) {
                    AisinoRedInvoiceParam aisinoRedInvoiceParam = new AisinoRedInvoiceParam();
                    aisinoRedInvoiceParam.setUUID(data1.getUUID());
                    String timestamp = String.valueOf(System.currentTimeMillis());
                    String randomStr = timestamp.substring(timestamp.length() - 5);
                    String randomFiveDigits = String.format("%05d", (int)(Math.random() * 100000.0));
                    aisinoRedInvoiceParam.setFPQQLSH(qrjkpfpxx.getXSFNSRSBH() + randomStr + randomFiveDigits);
                    aisinoRedInvoiceParam.setYFPHM(qrjkpfpxx.getFPHM());
                    aisinoRedInvoiceParam.setHZFPXXQRDBH(data1.getHZFPXXQRDBH());
                    aisinoRedInvoiceParam.setSFZZFP("N");
                    String redOpenParamStr = JSON.toJSONString((Object)aisinoRedInvoiceParam);
                    AisinoCoverParamPayload redOpenParam = this.aisinoPayloadService.assembleAisinoPayload(redOpenParamStr, saveParam.getSaleTaxNo());
                    AisinoRedOpenResultResp redOpenResp = this.aisinoService.redInvoiceOpen(redOpenParam, redOpenParamStr);
                    if (redOpenResp != null && Objects.equals(redOpenResp.getCODE(), "0000")) {
                        RedInvoiceOpenResp redInvoiceOpenResp = redOpenResp.getDATA();
                        RedInvoiceOpenResp.Data data = redInvoiceOpenResp.getDATA();
                        result.setRedInvoiceNo(data.getFPHM());
                        result.setRedInvoiceCode(data.getFPDM());
                    } else {
                        result.setRedFailCause(redOpenResp != null ? redOpenResp.getRETURNMESSAGE() : "\u7ea2\u7968\u5f00\u5177\u5931\u8d25");
                    }
                } else {
                    result.setRedInvoiceNo(qrjkpfpxx.getFPHM());
                    result.setRedInvoiceCode(qrjkpfpxx.getFPDM());
                    result.setUuid(data1.getUUID());
                    result.setRedInvoiceConfirmNo(data1.getHZFPXXQRDBH());
                }
            } else {
                result.setRedFailCause(redSaveResp != null ? redSaveResp.getRETURNMESSAGE() : "\u7ea2\u7968\u4fdd\u5b58\u5931\u8d25");
            }
        } else {
            result.setRedFailCause(response != null ? response.getRETURNMESSAGE() : "\u7ea2\u7968\u521d\u59cb\u5316\u5931\u8d25");
        }
        return result;
    }

    @Override
    public void rePushSaleInvDDtl(ApplyRePushParam param) {
        List<String> applyNoList = param.getApplyNoList();
        List<SaleInvDO> byApplyNoIn = this.saleInvRepo.findByApplyNoIn(applyNoList);
        if (CollectionUtil.isEmpty(byApplyNoIn)) {
            throw new BusinessException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u7533\u8bf7\u5355");
        }
        List<Long> masIdList = byApplyNoIn.stream().map(BaseModel::getId).toList();
        List<SaleInvdDtlDO> invStateAndMasIdIn = this.saleInvdDtlRepo.findAllByInvStateAndMasIdIn(UdcEnum.INV_STATE_FAIL.getValueCode(), masIdList);
        if (CollectionUtil.isEmpty(invStateAndMasIdIn)) {
            throw new BusinessException("\u672a\u627e\u5230\u5f00\u7968\u5931\u8d25\u7684\u53d1\u7968");
        }
        Map<String, List<SaleInvdDtlDO>> saleInvMap = invStateAndMasIdIn.stream().collect(Collectors.groupingBy(SaleInvdDtlDO::getSaleTaxNo));
        List<Long> masIds = invStateAndMasIdIn.stream().map(BaseModel::getId).toList();
        String orderState = UdcEnum.INV_STATE_ING.getValueCode();
        this.saleInvRepo.updateOrderStateByIdIn(orderState, masIds);
        saleInvMap.forEach((key, value) -> {
            List<Long> list = value.stream().map(BaseModel::getId).toList();
            InvoiceRetryProcessMqMessageDTO messageDTO = new InvoiceRetryProcessMqMessageDTO();
            messageDTO.setIdList(list);
            messageDTO.setBusinessKey((String)key);
            try {
                this.messageQueueTemplate.publishMessage("yst-fin", "invoice_retry_process", (Serializable)messageDTO);
            }
            catch (Exception e) {
                log.error("\u53d1\u9001mq\u6d88\u606f\uff0c\u91cd\u8bd5\u5931\u8d25\u5f00\u7968\u6570\u636e,\u540c\u6b65\u5185\u5bb9{}, \u5931\u8d25\u539f\u56e0\uff1a{}", (Object)messageDTO, (Object)e.getMessage());
            }
        });
    }

    @Override
    @Transactional
    public void getRedInvoiceResult(List<Long> idList) {
        List allById = this.saleInvdDtlRepo.findAllById(idList);
        if (CollectionUtils.isEmpty((Collection)allById)) {
            throw new BusinessException("\u672a\u627e\u5230\u5355\u636e");
        }
        ArrayList<SaleInvdDtlDO> emailList = new ArrayList<SaleInvdDtlDO>();
        for (SaleInvdDtlDO invdDtlDO : allById) {
            Boolean success;
            AisinoRedInvoiceResultParam aisinoRedInvoiceParam = new AisinoRedInvoiceResultParam();
            aisinoRedInvoiceParam.setHZQRXXUUID(invdDtlDO.getCheckCode());
            aisinoRedInvoiceParam.setXSFNSRSBH(invdDtlDO.getSaleTaxNo());
            String timestamp = String.valueOf(System.currentTimeMillis());
            String randomStr = timestamp.substring(timestamp.length() - 5);
            String randomFiveDigits = String.format("%05d", (int)(Math.random() * 100000.0));
            String redOpenParamStr = JSON.toJSONString((Object)aisinoRedInvoiceParam);
            AisinoRedGetResultResp redOpenResp = null;
            try {
                AisinoCoverParamPayload redOpenParam = this.aisinoPayloadService.assembleAisinoPayload(redOpenParamStr, invdDtlDO.getSaleTaxNo());
                redOpenResp = this.aisinoService.redInvoiceGetResult(redOpenParam, redOpenParamStr);
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u7ea2\u7968\u5f00\u7968\u7ed3\u679c\u5931\u8d25,\u53c2\u6570\uff1a{}", (Object)redOpenParamStr);
            }
            if ((success = this.saveRedSaleInvDDtl(invdDtlDO, redOpenResp)) == null || !success.booleanValue()) continue;
            List<SaleInvdDtlDO> base64Result = this.getBase64Result(List.of(invdDtlDO.getId()), null);
            emailList.addAll(base64Result);
        }
        this.sendEmail(emailList);
    }

    private Boolean saveRedSaleInvDDtl(SaleInvdDtlDO saleInvdDtlDO, AisinoRedGetResultResp response) {
        saleInvdDtlDO.setInvDate(LocalDateTime.now());
        String orderState = null;
        boolean result = false;
        if (response != null && Objects.equals(response.getCODE(), "0000")) {
            RedInvoiceResultResp data = response.getDATA();
            saleInvdDtlDO.setInvState(UdcEnum.INV_STATE_SUCCESS.getCode());
            saleInvdDtlDO.setInvNo(data.getFPHM());
            saleInvdDtlDO.setInvFailCause(null);
            saleInvdDtlDO.setRedState(null);
            if (Strings.isNotBlank((String)data.getKPRQ())) {
                LocalDateTime invoiceDate = LocalDateTime.parse(data.getKPRQ(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                saleInvdDtlDO.setInvDate(invoiceDate);
            }
            if (Objects.equals(data.getCODE(), "2")) {
                saleInvdDtlDO.setInvState(UdcEnum.INV_STATE_SUCCESS.getValueCode());
                orderState = UdcEnum.APPLY_STATUS_RED_SUCCESS.getValueCode();
                saleInvdDtlDO.setInvPdfUrl(null);
                saleInvdDtlDO.setInvFailCause(null);
                result = true;
            }
        } else {
            saleInvdDtlDO.setInvState(UdcEnum.INV_STATE_FAIL.getValueCode());
            saleInvdDtlDO.setInvFailCause(response != null ? response.getRETURNMESSAGE() : "\u5f00\u7968\u7533\u8bf7\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
        }
        this.saleInvdDtlRepo.save(saleInvdDtlDO);
        if (orderState != null) {
            this.saleInvRepo.updateOrderStateById(orderState, saleInvdDtlDO.getMasId());
        }
        return result;
    }

    @Override
    public List<SaleInvDtlVO> getDtlList(Long masId) {
        try {
            List<SaleInvDtlDTO> list = this.invoiceDtlDomainService.getList(masId);
            Set itemCodeList = list.stream().map(SaleInvDtlDTO::getItemCode).collect(Collectors.toSet());
            Set itemIdList = list.stream().map(SaleInvDtlDTO::getItemId).collect(Collectors.toSet());
            ItmItemRpcDtoParam itmItemParam = new ItmItemRpcDtoParam();
            itmItemParam.setItemCodes(new ArrayList(itemCodeList));
            itmItemParam.setItemIds(new ArrayList(itemIdList));
            List itmItemResps = this.itmItemRpcService.findItemRpcDtoByParam(itmItemParam);
            Map<String, String> itemCodeAndNameMap = itmItemResps.stream().collect(Collectors.toMap(ItmItemRpcDTO::getItemCode, ItmItemRpcDTO::getItemName));
            Map<String, String> itemNameAndCodeMap = itemCodeAndNameMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            Map udcValues = (Map)org.apache.commons.lang3.ObjectUtils.defaultIfNull(this.rmiSysUdcRpcService.getUdcMapByUdcCode("yst-supp", "TAXONOMY_CODE"), new HashMap());
            list = list.stream().peek(v -> {
                String taxName = udcValues.getOrDefault(v.getTaxCode(), "");
                v.setTaxName(taxName);
                if (!ObjectUtils.isEmpty((Object)v.getItemCode()) && ObjectUtils.isEmpty((Object)v.getItemName())) {
                    String itemName = itemCodeAndNameMap.getOrDefault(v.getItemCode(), v.getItemName());
                    v.setItemName(itemName);
                } else if (!ObjectUtils.isEmpty((Object)v.getItemName()) && ObjectUtils.isEmpty((Object)v.getItemCode())) {
                    String itemCode = itemNameAndCodeMap.getOrDefault(v.getItemName(), v.getItemCode());
                    v.setItemCode(itemCode);
                }
            }).collect(Collectors.toList());
            List<SaleInvDtlVO> res = SaleInvConvert.INSTANCE.convertListVO(list);
            return res;
        }
        catch (Exception e) {
            log.error("Fetching sale details failed" + e.getMessage(), (Throwable)e);
            throw new BusinessException("Fetching sale details failed", (Throwable)e);
        }
    }

    private InvoiceRedraftDO saveInvoiceRedraft(InvoiceApplyRpcDTO applyRpcDTO) {
        SaleInvDO saleInvDO = this.saleInvRepo.findByApplyNo(applyRpcDTO.getApplyNo());
        List<SaleInvdDtlVO> saleInvdDtlVOs = this.saleInvService.getInvdLists(saleInvDO.getId());
        if (!CollectionUtils.isEmpty(saleInvdDtlVOs)) {
            SaleInvdDtlVO saleInvdDtlVO = saleInvdDtlVOs.get(0);
            InvoiceRedraftDO invoiceRedraftDO = new InvoiceRedraftDO();
            invoiceRedraftDO.setOrigApplyNo(applyRpcDTO.getApplyNo());
            invoiceRedraftDO.setInvoiceNo(saleInvdDtlVO.getInvNo());
            invoiceRedraftDO.setSerialNo(saleInvdDtlVO.getFlowNo());
            invoiceRedraftDO.setInvoiceAmt(saleInvdDtlVO.getTotalAmt());
            invoiceRedraftDO.setInvoiceDate(saleInvdDtlVO.getInvDate());
            invoiceRedraftDO.setInvoiceType(saleInvDO.getInvType());
            invoiceRedraftDO.setWorkflowProcInstStatus(ProcInstStatus.NOTSUBMIT);
            invoiceRedraftDO.setCustCode(saleInvDO.getCustCode());
            invoiceRedraftDO.setCustName(saleInvDO.getCustName());
            invoiceRedraftDO.setCustId(saleInvDO.getCustId());
            invoiceRedraftDO.setMainCustCode(saleInvDO.getMainCustCode());
            invoiceRedraftDO.setMainCustName(saleInvDO.getMainCustName());
            invoiceRedraftDO.setMainCustId(saleInvDO.getMainCustId());
            this.invoiceRedraftRepo.save((Object)invoiceRedraftDO);
            return invoiceRedraftDO;
        }
        throw new BusinessException("\u5f53\u524d\u9500\u552e\u53d1\u7968\u65e0\u5f00\u7968\u660e\u7ec6" + applyRpcDTO.getApplyId());
    }

    public void checeInvParam(InvoiceApplyParam param) {
        Assert.notNull((Object)param.getInvType(), (String)"\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)param.getCustInvTitle(), (String)"\u5f00\u7968\u62ac\u5934\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public InvoiceServiceImpl(InvoiceApplyService invoiceApplyService, InvoiceSaveService invoiceSaveService, InvoiceRedraftRepo invoiceRedraftRepo, SaleInvRepo saleInvRepo, SaleInvService saleInvService, InvoiceDtlDomainService invoiceDtlDomainService, SaleInvDtlRepo saleInvDtlRepo, ItmItemRpcService itmItemRpcService, SaleInvdDtlRepo saleInvdDtlRepo, AisinoService aisinoService, AisinoPayloadService aisinoPayloadService, TaskExecutor taskExecutor, InvoiceAwaitRepoProc invoiceAwaitRepoProc, MessageQueueTemplate messageQueueTemplate, SalDoRpcService salDoRpcService) {
        this.invoiceApplyService = invoiceApplyService;
        this.invoiceSaveService = invoiceSaveService;
        this.invoiceRedraftRepo = invoiceRedraftRepo;
        this.saleInvRepo = saleInvRepo;
        this.saleInvService = saleInvService;
        this.invoiceDtlDomainService = invoiceDtlDomainService;
        this.saleInvDtlRepo = saleInvDtlRepo;
        this.itmItemRpcService = itmItemRpcService;
        this.saleInvdDtlRepo = saleInvdDtlRepo;
        this.aisinoService = aisinoService;
        this.aisinoPayloadService = aisinoPayloadService;
        this.taskExecutor = taskExecutor;
        this.invoiceAwaitRepoProc = invoiceAwaitRepoProc;
        this.messageQueueTemplate = messageQueueTemplate;
        this.salDoRpcService = salDoRpcService;
    }
}

