/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.account;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.account.AccountConvert;
import com.elitesland.fin.application.facade.dto.account.AccountDTO;
import com.elitesland.fin.application.facade.excel.account.AccountImportEntity;
import com.elitesland.fin.application.facade.param.account.AccountPageParam;
import com.elitesland.fin.application.facade.param.account.AccountParam;
import com.elitesland.fin.application.facade.vo.account.AccountBankInfoVo;
import com.elitesland.fin.application.facade.vo.account.AccountVO;
import com.elitesland.fin.application.service.account.AccountService;
import com.elitesland.fin.common.ExcelEntityDataListener;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.account.AccountDO;
import com.elitesland.fin.repo.account.AccountRepo;
import com.elitesland.fin.repo.account.AccountRepoProc;
import com.elitesland.fin.rpc.sale.RmiSaleRpcService;
import com.elitesland.fin.rpc.system.SystemRpcService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.sale.api.vo.resp.sal.RmiOrgBankAccRpcVO;
import com.elitesland.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.support.provider.org.param.OrgOuRpcDtoParam;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AccountServiceImpl
implements AccountService {
    private final AccountRepoProc accountRepoProc;
    private final AccountRepo accountRepo;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;
    private final SystemRpcService systemRpcService;
    private final UdcProvider udcProvider;
    private static final String ERROR_TEMPLATE = "\u7b2c {0} \u884c: {1} \u89e3\u6790\u5f02\u5e38: {2}; ";
    private final RmiSaleRpcService rmiSaleRpcService;

    @Override
    @Transactional
    public void save(AccountParam accountParam) {
        this.checkAccountSaveParam(accountParam);
        if (ObjectUtil.isNull((Object)accountParam.getId())) {
            Object accountCode = this.systemRpcService.sysNumberRuleGenerateCode("yst-fin", "ZH", new ArrayList<String>());
            accountCode = accountParam.getAccountHolderCode() + "-" + (String)accountCode;
            accountParam.setAccountCode((String)accountCode);
            if (this.accountRepo.existsByAccountCode((String)accountCode)) {
                throw new BusinessException("\u8d26\u6237\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4");
            }
            if (this.accountRepo.existsByAccountNameAndAccountType(accountParam.getAccountName(), accountParam.getAccountType())) {
                throw new BusinessException("\u8d26\u6237\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u63d0\u4ea4");
            }
            if (this.accountRepo.existsBySecOuCodeAndAccountHolderCodeAndAccountType(accountParam.getSecOuCode(), accountParam.getAccountHolderCode(), accountParam.getAccountType())) {
                throw new BusinessException("\u8be5\u5ba2\u6237\u5df2\u7ecf\u521b\u5efa\u8d26\u6237");
            }
            accountParam.setState(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        }
        AccountDO accountDO = AccountConvert.INSTANCE.p2En(accountParam);
        this.accountRepo.save((Object)accountDO);
    }

    private void checkAccountSaveParam(AccountParam accountParam) {
        Assert.notEmpty((CharSequence)accountParam.getSecOuCode(), (String)"\u5f52\u5c5e\u516c\u53f8\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)accountParam.getAccountHolderName(), (String)"\u5f00\u6237\u4e3b\u4f53\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)accountParam.getAccountType(), (String)"\u8d26\u6237\u7c7b\u578b\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)accountParam.getAccountHolderCode(), (String)"\u5f00\u6237\u4e3b\u4f53\u7f16\u7801\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notNull((Object)accountParam.getAccountAmount(), (String)"\u8d26\u6237\u91d1\u989d\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notNull((Object)accountParam.getAccountOccupancyAmount(), (String)"\u8d26\u6237\u5360\u7528\u91d1\u989d\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notNull((Object)accountParam.getAccountAvailableAmount(), (String)"\u8d26\u6237\u53ef\u7528\u91d1\u989d\u5fc5\u586b", (Object[])new Object[0]);
        Pattern pattern = Pattern.compile("^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,2})?$");
        if (!pattern.matcher(accountParam.getAccountAmount().toString()).matches()) {
            Assert.notNull((Object)accountParam.getAccountAmount(), (String)"\u8d26\u6237\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e,\u6700\u591a\u4e24\u4f4d\u5c0f\u6570", (Object[])new Object[0]);
        }
        if (!pattern.matcher(accountParam.getAccountOccupancyAmount().toString()).matches()) {
            Assert.notNull((Object)accountParam.getAccountAmount(), (String)"\u8d26\u6237\u5360\u7528\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e,\u6700\u591a\u4e24\u4f4d\u5c0f\u6570", (Object[])new Object[0]);
        }
        if (!pattern.matcher(accountParam.getAccountAvailableAmount().toString()).matches()) {
            Assert.notNull((Object)accountParam.getAccountAmount(), (String)"\u8d26\u6237\u53ef\u7528\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e,\u6700\u591a\u4e24\u4f4d\u5c0f\u6570", (Object[])new Object[0]);
        }
        Assert.isTrue((accountParam.getAccountAmount().compareTo(accountParam.getAccountOccupancyAmount().add(accountParam.getAccountAvailableAmount())) == 0 ? 1 : 0) != 0, (String)"\u8d26\u6237\u91d1\u989d\u4e0d\u7b49\u4e8e\u8d26\u6237\u5360\u7528\u91d1\u989d+\u8d26\u6237\u53ef\u7528\u91d1\u989d", (Object[])new Object[0]);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void accountImport(MultipartFile file) throws IOException {
        ArrayList<String> errorList = new ArrayList<String>();
        ExcelEntityDataListener dataInternalListener = new ExcelEntityDataListener();
        ((ExcelReaderSheetBuilder)EasyExcelFactory.read((InputStream)file.getInputStream(), AccountImportEntity.class, dataInternalListener).sheet(Integer.valueOf(0)).headRowNumber(Integer.valueOf(1))).doRead();
        List<AccountImportEntity> accountImportEntityList = dataInternalListener.getDatas();
        Assert.notEmpty(accountImportEntityList, (String)"excel\u4e3a\u7a7a", (Object[])new Object[0]);
        accountImportEntityList.stream().forEach(item -> {
            if ("\u662f".equals(item.getDefaultAccount())) {
                item.setDefaultAccount("true");
            }
            if ("\u5426".equals(item.getDefaultAccount())) {
                item.setDefaultAccount("false");
            }
        });
        List<AccountDO> accountDOList = AccountConvert.INSTANCE.accountImportEntityList2AccountDOList(accountImportEntityList);
        this.buildErrorMsg(accountDOList, errorList);
        if (CollectionUtils.isNotEmpty(errorList)) {
            throw new BusinessException(StringUtils.join(errorList, (String)"\n"));
        }
        this.buildDefaultValue(accountDOList);
        this.accountRepo.saveAll(accountDOList);
    }

    public void buildDefaultValue(List<AccountDO> accountDOList) {
        accountDOList.stream().forEach(item -> {
            if (StringUtils.isNotEmpty((CharSequence)item.getAccountHolderType())) {
                item.setAccountHolderType(UdcEnum.PRINCIPAL_TYPE_INVOICE.getValueCode());
            }
        });
    }

    public void buildErrorMsg(List<AccountDO> accountDOList, List<String> errorList) {
        this.checkImportMandatoryField(accountDOList, errorList);
        this.checkImportRepeatAccountCode(accountDOList, errorList);
        this.checkDataValid(accountDOList, errorList);
    }

    public void checkDataValid(List<AccountDO> accountDOList, List<String> errorList) {
        List secOuCodeList = accountDOList.stream().map(AccountDO::getSecOuCode).collect(Collectors.toList());
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        orgOuRpcDtoParam.setOuCodes(secOuCodeList);
        List<OrgOuRpcDTO> orgOuRpcDTOList = this.rmiOrgOuRpcServiceService.findOuDtoByParam(orgOuRpcDtoParam);
        Set ouCodeSet = orgOuRpcDTOList.stream().map(OrgOuRpcDTO::getOuCode).collect(Collectors.toSet());
        List secFranchiseeCodeList = accountDOList.stream().map(AccountDO::getSecFranchiseeCode).collect(Collectors.toList());
        Map principalTypeUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.PRINCIPAL_TYPE_INVOICE.getModel(), UdcEnum.PRINCIPAL_TYPE_INVOICE.getCode());
        Collection principalTypeList = principalTypeUdc.values();
        Map finAccountTypeUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.ACCOUNT_TYPE_STORE.getModel(), UdcEnum.ACCOUNT_TYPE_STORE.getCode());
        Collection finAccountTypeList = finAccountTypeUdc.values();
        for (int i = 0; i < accountDOList.size(); ++i) {
            if (StringUtils.isNotEmpty((CharSequence)accountDOList.get(i).getSecOuCode()) && !ouCodeSet.contains(accountDOList.get(i).getSecOuCode())) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, i + 2, "\u516c\u53f8\u7f16\u7801", "\u516c\u53f8\u7f16\u7801\u5728\u7cfb\u7edf\u4e0d\u5b58\u5728"));
            }
            if (StringUtils.isNotEmpty((CharSequence)accountDOList.get(i).getAccountHolderType()) && !principalTypeList.contains(accountDOList.get(i).getAccountHolderType())) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, i + 2, "\u5f00\u6237\u4e3b\u4f53\u7c7b\u578b", "\u5f00\u6237\u4e3b\u4f53\u7c7b\u578b\u5728\u7cfb\u7edf\u4e0d\u5b58\u5728"));
            }
            if (StringUtils.isNotEmpty((CharSequence)accountDOList.get(i).getAccountType()) && !finAccountTypeList.contains(accountDOList.get(i).getAccountType())) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, i + 2, "\u8d26\u6237\u7c7b\u578b", "\u8d26\u6237\u7c7b\u578b\u5728\u7cfb\u7edf\u4e0d\u5b58\u5728"));
            }
            Pattern pattern = Pattern.compile("^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,2})?$");
            if (accountDOList.get(i).getAccountAmount() != null && !pattern.matcher(accountDOList.get(i).getAccountAmount().toString()).matches()) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, i + 2, "\u8d26\u6237\u91d1\u989d", "\u8d26\u6237\u91d1\u989d\u683c\u5f0f\u6709\u8bef"));
            }
            if (accountDOList.get(i).getAccountOccupancyAmount() != null && !pattern.matcher(accountDOList.get(i).getAccountOccupancyAmount().toString()).matches()) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, i + 2, "\u8d26\u6237\u5360\u7528\u91d1\u989d", "\u8d26\u6237\u5360\u7528\u91d1\u989d\u683c\u5f0f\u6709\u8bef"));
            }
            if (accountDOList.get(i).getAccountAvailableAmount() != null && !pattern.matcher(accountDOList.get(i).getAccountAvailableAmount().toString()).matches()) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, i + 2, "\u8d26\u6237\u53ef\u7528\u91d1\u989d", "\u8d26\u6237\u53ef\u7528\u91d1\u989d\u683c\u5f0f\u6709\u8bef"));
            }
            if (accountDOList.get(i).getAccountAmount() == null || accountDOList.get(i).getAccountOccupancyAmount() == null || accountDOList.get(i).getAccountAvailableAmount() == null || accountDOList.get(i).getAccountAmount().compareTo(accountDOList.get(i).getAccountOccupancyAmount().add(accountDOList.get(i).getAccountAvailableAmount())) == 0) continue;
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, i + 2, "\u91d1\u989d", "\u8d26\u6237\u91d1\u989d\u4e0d\u7b49\u4e8e\u8d26\u6237\u5360\u7528\u91d1\u989d+\u8d26\u6237\u53ef\u7528\u91d1\u989d"));
        }
    }

    private void checkImportRepeatAccountCode(List<AccountDO> accountDOList, List<String> errorList) {
        List allAccountDOList = this.accountRepo.findAll();
        Set accountCodeSet = allAccountDOList.stream().map(AccountDO::getAccountCode).collect(Collectors.toSet());
        for (int i = 0; i < accountDOList.size(); ++i) {
            if (!accountCodeSet.contains(accountDOList.get(i).getAccountCode())) continue;
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, i + 2, "\u8d26\u6237\u7f16\u7801", "\u8d26\u6237\u7f16\u7801\u5728\u7cfb\u7edf\u5df2\u7ecf\u5b58\u5728"));
        }
        HashSet<String> excelAccountCodeSet = new HashSet<String>();
        for (int i = 0; i < accountDOList.size(); ++i) {
            if (!StringUtils.isNotEmpty((CharSequence)accountDOList.get(i).getAccountCode())) continue;
            if (excelAccountCodeSet.contains(accountDOList.get(i).getAccountCode())) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, i + 2, "\u8d26\u6237\u7f16\u7801", "\u8d26\u6237\u7f16\u7801\u91cd\u590d"));
            }
            excelAccountCodeSet.add(accountDOList.get(i).getAccountCode());
        }
    }

    private void checkImportMandatoryField(List<AccountDO> accountDOList, List<String> errorList) {
        for (int i = 0; i < accountDOList.size(); ++i) {
            if (StringUtils.isEmpty((CharSequence)accountDOList.get(i).getSecOuCode())) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, i + 2, "\u5f52\u5c5e\u516c\u53f8\u7f16\u7801", "\u5f52\u5c5e\u516c\u53f8\u7f16\u7801\u5fc5\u586b"));
            }
            if (StringUtils.isEmpty((CharSequence)accountDOList.get(i).getSecFranchiseeCode())) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, i + 2, "\u5f52\u5c5e\u52a0\u76df\u5546\u7f16\u7801", "\u5f52\u5c5e\u52a0\u76df\u5546\u7f16\u7801\u7f16\u7801\u5fc5\u586b"));
            }
            if (StringUtils.isEmpty((CharSequence)accountDOList.get(i).getAccountHolderName())) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, i + 2, "\u5f00\u6237\u4e3b\u4f53\u540d\u79f0", "\u5f00\u6237\u4e3b\u4f53\u540d\u79f0\u5fc5\u586b"));
            }
            if (StringUtils.isEmpty((CharSequence)accountDOList.get(i).getAccountCode())) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, i + 2, "\u8d26\u6237\u7f16\u7801", "\u8d26\u6237\u7f16\u7801\u5fc5\u586b"));
            }
            if (StringUtils.isEmpty((CharSequence)accountDOList.get(i).getAccountName())) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, i + 2, "\u8d26\u6237\u540d\u79f0", "\u8d26\u6237\u540d\u79f0\u5fc5\u586b"));
            }
            if (StringUtils.isEmpty((CharSequence)accountDOList.get(i).getAccountType())) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, i + 2, "\u8d26\u6237\u7c7b\u578b", "\u8d26\u6237\u7c7b\u578b\u5fc5\u586b"));
            }
            if (accountDOList.get(i).getAccountAmount() == null) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, i + 2, "\u8d26\u6237\u91d1\u989d", "\u8d26\u6237\u91d1\u989d\u5fc5\u586b"));
            }
            if (accountDOList.get(i).getAccountAvailableAmount() == null) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, i + 2, "\u8d26\u6237\u53ef\u7528\u91d1\u989d", "\u8d26\u6237\u53ef\u7528\u91d1\u989d\u5fc5\u586b"));
            }
            if (accountDOList.get(i).getAccountOccupancyAmount() != null) continue;
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, i + 2, "\u8d26\u6237\u5360\u7528\u91d1\u989d", "\u8d26\u6237\u5360\u7528\u91d1\u989d\u5fc5\u586b"));
        }
    }

    @Override
    @SysCodeProc
    public AccountVO get(Long id) {
        AccountVO res = this.accountRepoProc.get(id);
        return res;
    }

    @Override
    @SysCodeProc
    public PagingVO<AccountVO> page(AccountPageParam accountPageParam) {
        PagingVO<AccountVO> res = this.accountRepoProc.page(accountPageParam);
        if (CollectionUtils.isEmpty((Collection)res.getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        ArrayList ouCodes = new ArrayList();
        res.getRecords().stream().forEach(item -> ouCodes.add(item.getSecOuCode()));
        orgOuRpcDtoParam.setOuCodes(ouCodes);
        List<OrgOuRpcDTO> orgOuRpcDTOList = this.rmiOrgOuRpcServiceService.findOuDtoByParam(orgOuRpcDtoParam);
        res.getRecords().stream().forEach(item -> {
            OrgOuRpcDTO orgOuResult = orgOuRpcDTOList.stream().filter(orgOuRpcDTO -> StrUtil.equals((CharSequence)item.getSecOuCode(), (CharSequence)orgOuRpcDTO.getOuCode())).findFirst().orElse(null);
            if (orgOuResult != null) {
                item.setSecOuName(orgOuResult.getOuName());
            }
        });
        return res;
    }

    @Override
    public List<AccountDTO> getAccountByAccountParam(AccountParam param) {
        return this.accountRepoProc.getAccountByAccountParam(param);
    }

    @Override
    @Transactional
    public Long updateState(AccountParam accountParam) {
        if (null == accountParam.getIds()) {
            throw new BusinessException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long res = this.accountRepoProc.updateState(accountParam);
        return res;
    }

    @Override
    public List<AccountVO> queryAccount(List<String> accountCodes, String type, String state) {
        return this.accountRepoProc.queryByAccounts(accountCodes, type, state);
    }

    @Override
    public AccountVO getByCode(String accCode) {
        AccountVO res = this.accountRepoProc.getByCode(accCode);
        return res;
    }

    @Override
    @Transactional
    public Boolean updateAmtByCode(String accCode, BigDecimal accAmt, BigDecimal accOccAmt) {
        Assert.notEmpty((CharSequence)accCode, (String)"accCode\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AccountParam accountParam = new AccountParam();
        accountParam.setAccCode(accCode);
        accountParam.setAccAmt(accAmt);
        accountParam.setAccOccAmt(accOccAmt);
        if (null != accAmt && null != accOccAmt) {
            return this.accountRepoProc.updateAmtByCode(accountParam);
        }
        if (null != accAmt) {
            return this.accountRepoProc.updateAccAmtByCode(accountParam);
        }
        if (null != accOccAmt) {
            return this.accountRepoProc.updateOccAmtByCode(accountParam);
        }
        return true;
    }

    @Override
    public List<AccountBankInfoVo> getBankByCustCode(String custCode) {
        List<RmiOrgBankAccRpcVO> bankAccRpcVOS = this.rmiSaleRpcService.findBankAccByCustCode(custCode);
        if (CollectionUtil.isEmpty(bankAccRpcVOS)) {
            throw new BusinessException("\u67e5\u8be2\u5ba2\u6237\u94f6\u884c\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u914d\u7f6e");
        }
        List<RmiOrgBankAccRpcVO> bankVos = bankAccRpcVOS.stream().filter(item -> StrUtil.equals((CharSequence)item.getAccType(), (CharSequence)"OUT")).collect(Collectors.toList());
        return AccountConvert.INSTANCE.rpcBankVos2Vos(bankVos);
    }

    public AccountServiceImpl(AccountRepoProc accountRepoProc, AccountRepo accountRepo, RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService, SystemRpcService systemRpcService, UdcProvider udcProvider, RmiSaleRpcService rmiSaleRpcService) {
        this.accountRepoProc = accountRepoProc;
        this.accountRepo = accountRepo;
        this.rmiOrgOuRpcServiceService = rmiOrgOuRpcServiceService;
        this.systemRpcService = systemRpcService;
        this.udcProvider = udcProvider;
        this.rmiSaleRpcService = rmiSaleRpcService;
    }
}

