/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.invoice.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitesland.fin.application.convert.invoice.InvoiceAwaitConvert;
import com.elitesland.fin.application.convert.invoice.InvoiceAwaitDConvert;
import com.elitesland.fin.application.convert.invoice.InvoiceConvert;
import com.elitesland.fin.application.convert.saleinv.SaleInvConvert;
import com.elitesland.fin.application.facade.param.invoice.ApplyInvoiceParam;
import com.elitesland.fin.application.facade.param.invoice.ApplySaveParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplyParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplySaveParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceAwaitQueryParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceRuleConfigQueryParam;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceAwaitDVO;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceAwaitRespVO;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceAwaitVO;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceCustVO;
import com.elitesland.fin.application.service.invoice.InvoiceAwaitService;
import com.elitesland.fin.application.service.workflow.WorkFlowDefKey;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.saleinv.QSaleInvDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInv;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDtl;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDtlDO;
import com.elitesland.fin.dto.invoice.InvoiceApplyRpcDTO;
import com.elitesland.fin.entity.invoice.InvoiceAwaitDDO;
import com.elitesland.fin.infr.dto.invoice.InvoiceApplyDTO;
import com.elitesland.fin.infr.dto.invoice.InvoiceRuleConfigDTO;
import com.elitesland.fin.infr.repo.saleinv.SaleInvDtlRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvDtlRepoProc;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepo;
import com.elitesland.fin.param.saleinv.InvoiceDetailSaveParam;
import com.elitesland.fin.param.saleinv.InvoiceQueryParam;
import com.elitesland.fin.repo.invoice.InvoiceApplyRepoProc;
import com.elitesland.fin.repo.invoice.InvoiceAwaitDRepo;
import com.elitesland.fin.repo.invoice.InvoiceAwaitRepoProc;
import com.elitesland.fin.repo.invoice.InvoiceRuleConfigRepoProc;
import com.elitesland.fin.rpc.sale.RmiSaleRpcService;
import com.elitesland.fin.rpc.system.SystemRpcService;
import com.elitesland.fin.rpc.workflow.WorkflowRpcService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.fin.utils.FinIamUtil;
import com.elitesland.sale.api.vo.resp.crm.LmSaveCustRespVO;
import com.elitesland.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.support.provider.org.param.OrgOuRpcDtoParam;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class InvoiceAwaitServiceImpl
implements InvoiceAwaitService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceAwaitServiceImpl.class);
    private final InvoiceAwaitRepoProc invoiceAwaitRepoProc;
    private final InvoiceAwaitDRepo invoiceAwaitDRepo;
    private final RmiSaleRpcService rmiSaleRpcService;
    private final RmiOrgOuRpcServiceService orgRpcService;
    private final WorkflowRpcService workflowRpcService;
    private final JPAQueryFactory jpaQueryFactory;
    private final SaleInvRepo saleInvRepo;
    private final SaleInvDtlRepoProc saleInvDtlRepoProc;
    private final SaleInvDtlRepo saleInvDtlRepo;
    private final TransactionTemplate transactionTemplate;
    private final InvoiceRuleConfigRepoProc invoiceRuleConfigRepoProc;
    private final SystemRpcService systemRpcService;
    private final InvoiceApplyRepoProc invoiceApplyRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<InvoiceAwaitVO> queryInvoiceAwait(InvoiceAwaitQueryParam param) {
        return this.invoiceAwaitRepoProc.queryInvoiceAwait(param);
    }

    @Override
    @SysCodeProc
    public List<InvoiceAwaitDVO> queryInvoiceAwaitDetail(Long masId) {
        List<InvoiceAwaitDDO> list = this.invoiceAwaitDRepo.findAllByMasId(masId);
        return InvoiceAwaitDConvert.INSTANCE.dos2Vos(list);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Object invoiceApply(InvoiceApplyParam param) {
        List<InvoiceAwaitRespVO> records = this.getInvoiceAwait(param);
        Map<String, List<InvoiceAwaitRespVO>> optDocClsMap = this.queryInvoiceConfig(records);
        ArrayList saveParams = new ArrayList();
        optDocClsMap.forEach((key, value) -> {
            InvoiceApplySaveParam saveParam = this.getInvoiceApplySaveParam((List<InvoiceAwaitRespVO>)value);
            saveParams.add(saveParam);
        });
        ArrayList applyDtoList = new ArrayList();
        saveParams.stream().forEach(saveParam -> {
            saveParam.setInvType(param.getInvType());
            saveParam.setRemark(param.getRemark());
            InvoiceApplyDTO apply = this.create((InvoiceApplySaveParam)saveParam);
            Assert.notNull((Object)apply.getApplyNo(), (String)"\u5f00\u7968\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (Object[])new Object[0]);
            saveParam.setApplyNo(apply.getApplyNo());
            applyDtoList.add(apply);
        });
        return applyDtoList;
    }

    @NotNull
    private Map<String, List<InvoiceAwaitRespVO>> queryInvoiceConfig(List<InvoiceAwaitRespVO> records) {
        Map<String, List<InvoiceAwaitRespVO>> optDocClsMap = records.stream().collect(Collectors.groupingBy(InvoiceAwaitRespVO::getOptDocCls));
        Set<String> optDocClsSet = optDocClsMap.keySet();
        ArrayList<InvoiceRuleConfigQueryParam> queryParamList = new ArrayList<InvoiceRuleConfigQueryParam>();
        optDocClsSet.stream().forEach(cls -> {
            InvoiceRuleConfigQueryParam configQueryParam = new InvoiceRuleConfigQueryParam();
            configQueryParam.setOptDocCls((String)cls);
            queryParamList.add(configQueryParam);
        });
        List<InvoiceRuleConfigDTO> configDTOList = this.invoiceRuleConfigRepoProc.getList(queryParamList);
        if (CollectionUtil.isEmpty(configDTOList)) {
            optDocClsMap.forEach((key, value) -> value.forEach(vo -> vo.setAutoReview(Boolean.FALSE)));
        } else {
            configDTOList.stream().forEach(config -> {
                if (ObjUtil.equals((Object)config.getAutoReview(), (Object)0)) {
                    List voList = (List)optDocClsMap.get(config.getOptDocCls());
                    voList.stream().forEach(vo -> vo.setAutoReview(Boolean.FALSE));
                }
            });
        }
        return optDocClsMap;
    }

    public List<InvoiceAwaitRespVO> getInvoiceAwait(InvoiceApplyParam param) {
        Assert.notNull((Object)param.getCustInvTitle(), (String)"\u5f00\u7968\u62ac\u5934\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)param.getCustTaxNo(), (String)"\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty(param.getIds(), (String)"\u6ca1\u6709\u9009\u62e9\u5f85\u5f00\u53d1\u7968", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)param.getInvType(), (String)"\u6ca1\u6709\u9009\u62e9\u53d1\u7968\u7c7b\u578b", (Object[])new Object[0]);
        List<InvoiceAwaitRespVO> records = this.invoiceAwaitRepoProc.findByIds(param.getIds());
        if (CollUtil.isEmpty(records)) {
            throw new BusinessException("\u6ca1\u6709\u67e5\u8be2\u5230\u5f85\u5f00\u7968\u4fe1\u606f");
        }
        Set custCodeSet = records.stream().map(record -> record.getCustCode()).collect(Collectors.toSet());
        Assert.isTrue((custCodeSet.size() == 1 ? 1 : 0) != 0, (String)"\u6240\u9009\u5f85\u5f00\u53d1\u7968\u6240\u5c5e\u5ba2\u6237\u4fe1\u606f\u4e0d\u552f\u4e00", (Object[])new Object[0]);
        List docIdList = records.stream().map(record -> record.getMasId()).collect(Collectors.toList());
        InvoiceQueryParam invoiceQueryParam = new InvoiceQueryParam();
        invoiceQueryParam.setSourceDocId(docIdList);
        List<InvoiceApplyRpcDTO> dtos = this.invoiceApplyRepoProc.queryIdBySource(invoiceQueryParam);
        if (CollectionUtil.isNotEmpty(dtos)) {
            throw new BusinessException("\u5355\u636e\u5df2\u5f00\u7968\uff0c\u4e0d\u80fd\u91cd\u590d\u64cd\u4f5c");
        }
        return records;
    }

    public void setInvoice(InvoiceApplySaveParam saveParam, ApplySaveParam invoice) {
        saveParam.setCustTaxNo(invoice.getCustTaxNo());
        saveParam.setCustInvTitle(invoice.getCustInvTitle());
        saveParam.setCustAdd(invoice.getAddress());
        saveParam.setCustBank(invoice.getCustBank());
        saveParam.setCustBankAcc(invoice.getCustBankAcc());
        saveParam.setCustTel(invoice.getCustTel());
        saveParam.setInvType(invoice.getInvType());
    }

    private InvoiceApplySaveParam getInvoiceApplySaveParam(List<InvoiceAwaitRespVO> records) {
        InvoiceAwaitRespVO record = records.get(0);
        InvoiceApplySaveParam saveParam = new InvoiceApplySaveParam();
        saveParam.setInvoiceId(record.getMasId());
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        orgOuRpcDtoParam.setOuIds(List.of(record.getOuId()));
        List<OrgOuRpcDTO> ouRpcDTOS = this.orgRpcService.findOuDtoByParam(orgOuRpcDtoParam);
        OrgOuRpcDTO ouRpcDTO = ouRpcDTOS.get(0);
        saveParam.setAutoReview(record.getAutoReview());
        saveParam.setOuId(record.getOuId());
        saveParam.setOuCode(record.getOuCode());
        saveParam.setOuName(record.getOuName());
        saveParam.setSaleTaxNo(ouRpcDTO.getTaxerCode());
        saveParam.setSaleInvTitle(ouRpcDTO.getInvTitle());
        saveParam.setSaleAdd(ouRpcDTO.getInvAddress());
        saveParam.setSaleBank(ouRpcDTO.getInvBankName());
        saveParam.setSaleBankAcc(ouRpcDTO.getInvBankAcc());
        saveParam.setSaleTel(ouRpcDTO.getInvPicPhone());
        saveParam.setCurrCode(ouRpcDTO.getOuCurr());
        SysCurrencyRespDTO currByCode = this.systemRpcService.findCurrByCode(ouRpcDTO.getOuCurr());
        saveParam.setCurrName(currByCode.getCurrName());
        saveParam.setLocalCurrCode(ouRpcDTO.getOuCurr());
        saveParam.setLocalCurrName(currByCode.getCurrName());
        saveParam.setExchangeRate(BigDecimal.ONE);
        saveParam.setInvUser(FinIamUtil.currentUserName());
        saveParam.setRecUser(FinIamUtil.currentUserName());
        saveParam.setRevUser(FinIamUtil.currentUserName());
        saveParam.setCustId(record.getCustId());
        saveParam.setCustCode(record.getCustCode());
        saveParam.setCustName(record.getCustName());
        ApplyInvoiceParam param = new ApplyInvoiceParam();
        param.setCustCode(record.getCustCode());
        List<InvoiceCustVO> custVOS = this.invQuery(List.of(param));
        if (CollectionUtil.isNotEmpty(custVOS)) {
            InvoiceCustVO invoiceCustVO = custVOS.get(0);
            saveParam.setCustInvTitle(invoiceCustVO.getInvTitle());
            saveParam.setCustTaxNo(invoiceCustVO.getTaxNo());
            saveParam.setCustAdd(invoiceCustVO.getInvAddress());
            saveParam.setCustTel(invoiceCustVO.getInvTel());
            saveParam.setCustBankAcc(invoiceCustVO.getBankAccount());
            saveParam.setCustBank(invoiceCustVO.getInvBank());
            saveParam.setCustName(invoiceCustVO.getCustName());
        }
        saveParam.setInvMerge("1");
        BigDecimal total = records.stream().map(item -> ObjUtil.isNull((Object)item.getAmt()) ? BigDecimal.ZERO : item.getAmt()).reduce(BigDecimal.ZERO, BigDecimal::add);
        saveParam.setTotalAmt(total);
        saveParam.setInvType(record.getInvoiceType());
        saveParam.setCreateMode(record.getOptDocCls());
        ArrayList<InvoiceDetailSaveParam> details = new ArrayList<InvoiceDetailSaveParam>();
        for (int i = 0; i < records.size(); ++i) {
            InvoiceAwaitRespVO row = records.get(i);
            InvoiceDetailSaveParam detail = new InvoiceDetailSaveParam();
            detail.setLineNo(Integer.valueOf(i + 1));
            detail.setSourceId(row.getMasId());
            detail.setSourceNo(row.getDocNo());
            detail.setSourceLine(row.getLineNo());
            detail.setSourceLineId(row.getId());
            detail.setInvNature("\u9ed8\u8ba4\u901a\u7528\u5355");
            detail.setItemCode(row.getItemCode());
            detail.setItemName(row.getItemName());
            detail.setTaxCode(row.getTaxType());
            detail.setTaxName(record.getServiceName());
            detail.setItemType(record.getItemSpec());
            detail.setUom(row.getUom());
            detail.setQty(row.getQty());
            detail.setPrice(row.getAmt());
            detail.setTotalAmt(row.getAmt());
            detail.setTaxRate(row.getTaxRate());
            BigDecimal netAmt = row.getNetAmt();
            detail.setExclTaxAmt(netAmt);
            detail.setTaxAmt(NumberUtil.sub((Number)row.getAmt(), (Number)netAmt));
            details.add(detail);
        }
        saveParam.setDetails(details);
        return saveParam;
    }

    @Transactional(rollbackFor={Exception.class})
    public InvoiceApplyDTO create(InvoiceApplySaveParam param) {
        SaleInv saleInv = InvoiceConvert.INSTANCE.toSaleInv(param);
        if (ObjUtil.notEqual((Object)param.getAutoReview(), (Object)Boolean.FALSE)) {
            saleInv.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
        } else {
            saleInv.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        }
        param.setInvoiceAwaitStatus(UdcEnum.INVOICE_AWAIT_STATUS_ING.getValueCode());
        saleInv.check();
        saleInv.checkDtl();
        String applyNo = this.systemRpcService.sysNumberRuleGenerateCode("yst-fin", "XXFP", new ArrayList<String>());
        saleInv.setApplyNo(applyNo);
        log.info("[YST-FIN] saleInv: {}", (Object)saleInv);
        this.transactionTemplate.setPropagationBehavior(3);
        SaleInvDO saleInvDO = (SaleInvDO)this.transactionTemplate.execute(transactionStatus -> {
            SaleInvDO convertDO = SaleInvConvert.INSTANCE.convert(saleInv);
            log.info("[YST-FIN] convertDO: {}", (Object)convertDO);
            SaleInvDO save = (SaleInvDO)this.saleInvRepo.save(convertDO);
            this.saleInvDtlRepoProc.delByMasId(List.of(save.getId()));
            List<SaleInvDtl> saleInvDtls = saleInv.getSaleInvDtls();
            List<SaleInvDtlDO> details = SaleInvConvert.INSTANCE.convertListDO(saleInvDtls);
            log.info("[YST-FIN] convert details: {}", details);
            details.forEach(row -> {
                row.setMasId(save.getId());
                this.saleInvDtlRepo.save(row);
            });
            this.invoiceAwaitRepoProc.updateApplyNoById(param.getInvoiceId(), saleInv.getApplyNo(), param.getInvoiceAwaitStatus());
            return save;
        });
        if (ObjUtil.equals((Object)param.getAutoReview(), (Object)Boolean.FALSE)) {
            this.workFlow(saleInvDO);
        }
        InvoiceApplyDTO result = new InvoiceApplyDTO();
        result.setApplyId(saleInvDO.getId());
        result.setApplyNo(saleInvDO.getApplyNo());
        return result;
    }

    private void workFlow(SaleInvDO saleInvDO) {
        String applyNo = saleInvDO.getApplyNo();
        if (saleInvDO.getProcInstId() == null || WorkflowConstant.CAN_START_PROC_STATUSES.contains(saleInvDO.getProcInstStatus())) {
            String procInstName = "\u5f00\u7968\u7533\u8bf7(" + applyNo + ")\u5ba1\u6279";
            String businessKey = "" + saleInvDO.getId();
            ProcessInfo processInfo = this.workflowRpcService.startProcess(WorkFlowDefKey.FIN_SALE_INV.name(), procInstName, businessKey, new HashMap<String, Object>());
            QSaleInvDO qSaleInvDO = QSaleInvDO.saleInvDO;
            JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)qSaleInvDO).set((Path)qSaleInvDO.procInstId, (Object)processInfo.getProcInstId()).set(qSaleInvDO.submitTime, (Object)LocalDateTime.now()).where(new Predicate[]{qSaleInvDO.id.eq((Object)saleInvDO.getId())});
            if (!Objects.equals(processInfo.getProcInstStatus(), ProcInstStatus.APPROVED)) {
                jpaUpdateClause.set(qSaleInvDO.procInstStatus, (Object)ProcInstStatus.APPROVING);
                jpaUpdateClause.set((Path)qSaleInvDO.orderState, (Object)UdcEnum.APPLY_STATUS_DOING.getValueCode());
            }
            jpaUpdateClause.execute();
        }
    }

    @Override
    public List<InvoiceCustVO> invQuery(List<ApplyInvoiceParam> applyInvoiceParam) {
        Assert.notEmpty(applyInvoiceParam, (String)"\u5165\u53c2\u4e3a\u7a7a!", (Object[])new Object[0]);
        List<String> collect = applyInvoiceParam.stream().map(param -> param.getCustCode()).collect(Collectors.toList());
        List<LmSaveCustRespVO> invCust = this.rmiSaleRpcService.findInvCust(collect);
        return InvoiceAwaitConvert.INSTANCE.custVos2Dtos(invCust);
    }

    public InvoiceAwaitServiceImpl(InvoiceAwaitRepoProc invoiceAwaitRepoProc, InvoiceAwaitDRepo invoiceAwaitDRepo, RmiSaleRpcService rmiSaleRpcService, RmiOrgOuRpcServiceService orgRpcService, WorkflowRpcService workflowRpcService, JPAQueryFactory jpaQueryFactory, SaleInvRepo saleInvRepo, SaleInvDtlRepoProc saleInvDtlRepoProc, SaleInvDtlRepo saleInvDtlRepo, TransactionTemplate transactionTemplate, InvoiceRuleConfigRepoProc invoiceRuleConfigRepoProc, SystemRpcService systemRpcService, InvoiceApplyRepoProc invoiceApplyRepoProc) {
        this.invoiceAwaitRepoProc = invoiceAwaitRepoProc;
        this.invoiceAwaitDRepo = invoiceAwaitDRepo;
        this.rmiSaleRpcService = rmiSaleRpcService;
        this.orgRpcService = orgRpcService;
        this.workflowRpcService = workflowRpcService;
        this.jpaQueryFactory = jpaQueryFactory;
        this.saleInvRepo = saleInvRepo;
        this.saleInvDtlRepoProc = saleInvDtlRepoProc;
        this.saleInvDtlRepo = saleInvDtlRepo;
        this.transactionTemplate = transactionTemplate;
        this.invoiceRuleConfigRepoProc = invoiceRuleConfigRepoProc;
        this.systemRpcService = systemRpcService;
        this.invoiceApplyRepoProc = invoiceApplyRepoProc;
    }
}

