/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.web.account;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.account.AccountPageParam;
import com.elitesland.fin.application.facade.param.account.AccountParam;
import com.elitesland.fin.application.facade.vo.account.AccountBankInfoVo;
import com.elitesland.fin.application.facade.vo.account.AccountVO;
import com.elitesland.fin.application.service.account.AccountService;
import com.elitesland.fin.common.UdcEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/fin/account"})
@Api(value="\u8d26\u6237", tags={"\u8d26\u6237"})
public class AccountController {
    private final AccountService accountService;

    @PostMapping(value={"page"})
    @ApiOperation(value="\u8d26\u6237\u5217\u8868\u67e5\u8be2")
    public ApiResult<PagingVO<AccountVO>> page(@RequestBody AccountPageParam accountPageParam) {
        PagingVO<AccountVO> res = this.accountService.page(accountPageParam);
        return ApiResult.ok(res);
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539\u8d26\u6237\u4fe1\u606f")
    public ApiResult<Void> save(@RequestBody AccountParam accountParam) {
        this.accountService.save(accountParam);
        return ApiResult.ok();
    }

    @PostMapping(value={"enable"})
    @ApiOperation(value="\u542f\u7528\u8d26\u6237\u4fe1\u606f")
    public ApiResult<Long> enable(@RequestBody List<Long> ids) {
        AccountParam accountParam = new AccountParam();
        accountParam.setIds(ids);
        accountParam.setState(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        Long res = this.accountService.updateState(accountParam);
        return ApiResult.ok((Object)res);
    }

    @PostMapping(value={"disEnable"})
    @ApiOperation(value="\u7981\u7528\u8d26\u6237\u4fe1\u606f")
    public ApiResult<Long> disEnable(@RequestBody List<Long> ids) {
        AccountParam accountParam = new AccountParam();
        accountParam.setIds(ids);
        accountParam.setState(UdcEnum.FIN_ACTIVE_STATUS_CLOSED.getValueCode());
        Long res = this.accountService.updateState(accountParam);
        return ApiResult.ok((Object)res);
    }

    @GetMapping(value={"get"})
    @ApiOperation(value="\u8d26\u6237\u5217\u8868\u8be6\u60c5")
    public ApiResult<AccountVO> get(Long id) {
        AccountVO res = this.accountService.get(id);
        return ApiResult.ok((Object)res);
    }

    @ApiOperation(value="\u6839\u636e\u7f16\u7801\u67e5\u8be2\u8d26\u6237")
    @GetMapping(value={"getCode"})
    public ApiResult<AccountVO> getByCode(String accCode) {
        AccountVO res = this.accountService.getByCode(accCode);
        return ApiResult.ok((Object)res);
    }

    @ApiOperation(value="\u6839\u636e\u5ba2\u6237\u7f16\u7801\u67e5\u8be2\u94f6\u884c\u4fe1\u606f")
    @GetMapping(value={"/bank/{custCode}"})
    public ApiResult<List<AccountBankInfoVo>> getBankByCustCode(@PathVariable(value="custCode") String custCode) {
        return ApiResult.ok(this.accountService.getBankByCustCode(custCode));
    }

    public AccountController(AccountService accountService) {
        this.accountService = accountService;
    }
}

