/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.provider.refund;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.application.facade.param.creditaccountflow.CreditAccountFlowParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.fin.application.service.creditaccountflow.CreditAccountFlowService;
import com.elitesland.fin.application.service.flow.AccountFlowService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.dto.refund.RefundRpcDTO;
import com.elitesland.fin.param.refund.RefundRpcParam;
import com.elitesland.fin.service.refund.RefundRpcService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"rpc/refund"})
public class RefundRpcServiceImpl
implements RefundRpcService {
    private final AccountFlowService accountFlowService;
    private final CreditAccountFlowService creditAccountFlowService;

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<List<RefundRpcDTO>> refund(List<RefundRpcParam> param) {
        this.checkRefundParam(param);
        ArrayList refundRpcDTOList = new ArrayList();
        refundRpcDTOList.addAll(this.buildAccountFlowParam(param).stream().map(item -> {
            String flowNo = this.accountFlowService.generateAccountFlow((AccountFlowParam)((Object)item));
            RefundRpcDTO refundRpcDTO = new RefundRpcDTO();
            refundRpcDTO.setAccountType(item.getAccountType());
            refundRpcDTO.setAccountCode(item.getAccountCode());
            refundRpcDTO.setAccountName(item.getAccountName());
            refundRpcDTO.setTime(LocalDateTime.now());
            refundRpcDTO.setFlowNo(flowNo);
            refundRpcDTO.setRefundAmount(item.getSourceDocAmount());
            return refundRpcDTO;
        }).collect(Collectors.toList()));
        refundRpcDTOList.addAll(this.buildCreditAccountFlowParam(param).stream().map(item -> {
            String flowNo = this.creditAccountFlowService.generateCreditAccountFlow((CreditAccountFlowParam)((Object)item));
            RefundRpcDTO refundRpcDTO = new RefundRpcDTO();
            refundRpcDTO.setAccountType(item.getCreditAccountType());
            refundRpcDTO.setAccountCode(item.getCreditAccountCode());
            refundRpcDTO.setAccountName(item.getCreditAccountName());
            refundRpcDTO.setTime(LocalDateTime.now());
            refundRpcDTO.setFlowNo(flowNo);
            refundRpcDTO.setRefundAmount(item.getSourceDocAmount());
            return refundRpcDTO;
        }).collect(Collectors.toList()));
        return ApiResult.ok(refundRpcDTOList);
    }

    void checkRefundParam(List<RefundRpcParam> param) {
        Assert.notEmpty(param, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        param.stream().forEach(item -> {
            Assert.notEmpty((CharSequence)item.getAccountType(), (String)"\u8d26\u6237\u7c7b\u578b\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)item.getAccountName(), (String)"\u8d26\u6237\u540d\u79f0\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.isTrue((UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getValueCode().equals(item.getAccountType()) || UdcEnum.ACCOUNT_TYPE_STORE.getValueCode().equals(item.getAccountType()) || UdcEnum.ACCOUNT_TYPE_FLZH.getValueCode().equals(item.getAccountType()) ? 1 : 0) != 0, (String)"\u8d26\u6237\u7c7b\u578b\u9519\u8bef", (Object[])new Object[0]);
        });
    }

    private List<CreditAccountFlowParam> buildCreditAccountFlowParam(List<RefundRpcParam> param) {
        List<CreditAccountFlowParam> creditAccountFlowParamList = param.stream().filter(item -> UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getValueCode().equals(item.getAccountType())).map(item -> {
            CreditAccountFlowParam creditAccountFlowParam = new CreditAccountFlowParam();
            creditAccountFlowParam.setSourceDoc(item.getDoc());
            creditAccountFlowParam.setSourceDocType(item.getDocType());
            creditAccountFlowParam.setSourceDocStatus(item.getDocStatus());
            creditAccountFlowParam.setSourceDocAmount(item.getDocAmount());
            creditAccountFlowParam.setSourceId(item.getSourceId());
            creditAccountFlowParam.setSourceNo(item.getSourceNo());
            creditAccountFlowParam.setCreditAccountType(item.getAccountType());
            creditAccountFlowParam.setCreditAccountCode(item.getAccountCode());
            return creditAccountFlowParam;
        }).collect(Collectors.toList());
        return creditAccountFlowParamList;
    }

    private List<AccountFlowParam> buildAccountFlowParam(List<RefundRpcParam> param) {
        List<AccountFlowParam> accountFlowParamList = param.stream().filter(item -> UdcEnum.ACCOUNT_TYPE_STORE.getValueCode().equals(item.getAccountType()) || UdcEnum.ACCOUNT_TYPE_FLZH.getValueCode().equals(item.getAccountType())).map(item -> {
            AccountFlowParam accountFlowParam = new AccountFlowParam();
            accountFlowParam.setSourceDoc(item.getDoc());
            accountFlowParam.setSourceDocType(item.getDocType());
            accountFlowParam.setSourceDocStatus(item.getDocStatus());
            accountFlowParam.setSourceDocAmount(item.getDocAmount());
            accountFlowParam.setSourceId(item.getSourceId());
            accountFlowParam.setSourceNo(item.getSourceNo());
            accountFlowParam.setAccountCode(item.getAccountCode());
            accountFlowParam.setAccountType(item.getAccountType());
            return accountFlowParam;
        }).collect(Collectors.toList());
        return accountFlowParamList;
    }

    public RefundRpcServiceImpl(AccountFlowService accountFlowService, CreditAccountFlowService creditAccountFlowService) {
        this.accountFlowService = accountFlowService;
        this.creditAccountFlowService = creditAccountFlowService;
    }
}

