/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.repo.creditaccountflow;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.creditaccountflow.CreditAccountFlowDTO;
import com.elitesland.fin.application.facade.param.creditaccountflow.CreditAccountFlowParam;
import com.elitesland.fin.application.facade.vo.creditaccountflow.CreditAccountFlowVO;
import com.elitesland.fin.entity.creditaccountflow.QCreditAccountFlowDO;
import com.elitesland.fin.utils.StringUtil;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class CreditAccountFlowRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QCreditAccountFlowDO qCreditAccountFlowDO = QCreditAccountFlowDO.creditAccountFlowDO;

    public PagingVO<CreditAccountFlowDTO> page(CreditAccountFlowParam creditAccountFlowParam) {
        List<Predicate> where = this.where(creditAccountFlowParam);
        JPAQuery query = (JPAQuery)this.select(CreditAccountFlowDTO.class).where(ExpressionUtils.allOf(where));
        creditAccountFlowParam.setPaging(query);
        creditAccountFlowParam.fillOrders(query, this.qCreditAccountFlowDO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    public CreditAccountFlowVO selectByAccCode(String accCode) {
        return (CreditAccountFlowVO)((JPAQuery)((JPAQuery)((JPAQuery)this.select(CreditAccountFlowVO.class).where((Predicate)this.qCreditAccountFlowDO.creditAccountCode.eq((Object)accCode))).where((Predicate)this.qCreditAccountFlowDO.deleteFlag.eq((Object)0).or((Predicate)this.qCreditAccountFlowDO.deleteFlag.isNull()))).orderBy(this.qCreditAccountFlowDO.createTime.desc())).fetchFirst();
    }

    public List<CreditAccountFlowVO> selectListByParam(CreditAccountFlowParam creditAccountFlowParam) {
        List<Predicate> where = this.where(creditAccountFlowParam);
        JPAQuery query = (JPAQuery)this.select(CreditAccountFlowVO.class).where(ExpressionUtils.allOf(where));
        return query.fetch();
    }

    private List<Predicate> where(CreditAccountFlowParam creditAccountFlowParam) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (StringUtils.isNotEmpty((CharSequence)creditAccountFlowParam.getObjectName())) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.objectName.like(StringUtil.buildLikeString(creditAccountFlowParam.getObjectName())));
        }
        if (!StringUtils.isEmpty((CharSequence)creditAccountFlowParam.getCreditAccountName())) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.creditAccountName.like(StringUtil.buildLikeString(creditAccountFlowParam.getCreditAccountName())));
        }
        if (!StringUtils.isEmpty((CharSequence)creditAccountFlowParam.getTransactionType())) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.transactionType.eq((Object)creditAccountFlowParam.getTransactionType()));
        }
        if (creditAccountFlowParam.getTransactionTimeS() != null) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.transactionTime.goe((Comparable)creditAccountFlowParam.getTransactionTimeS()));
        }
        if (creditAccountFlowParam.getTransactionTimeE() != null) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.transactionTime.loe((Comparable)creditAccountFlowParam.getTransactionTimeE()));
        }
        if (creditAccountFlowParam.getAmountFrom() != null) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.amount.goe((Number)creditAccountFlowParam.getAmountFrom()));
        }
        if (creditAccountFlowParam.getAmountTo() != null) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.amount.loe((Number)creditAccountFlowParam.getAmountTo()));
        }
        if (StrUtil.isNotBlank((CharSequence)creditAccountFlowParam.getCreditAccountType())) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.creditAccountType.eq((Object)creditAccountFlowParam.getCreditAccountType()));
        }
        if (StrUtil.isNotBlank((CharSequence)creditAccountFlowParam.getSourceNo())) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.sourceNo.like("%" + creditAccountFlowParam.getSourceNo() + "%"));
        }
        if (StrUtil.isNotBlank((CharSequence)creditAccountFlowParam.getFlowNo())) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.flowNo.like("%" + creditAccountFlowParam.getFlowNo() + "%"));
        }
        if (CollectionUtil.isNotEmpty(creditAccountFlowParam.getSourceDocList())) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.sourceDoc.in(creditAccountFlowParam.getSourceDocList()));
        }
        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qCreditAccountFlowDO.id, this.qCreditAccountFlowDO.flowNo, this.qCreditAccountFlowDO.transactionType, this.qCreditAccountFlowDO.amount, this.qCreditAccountFlowDO.transactionTime, this.qCreditAccountFlowDO.creditAccountCode, this.qCreditAccountFlowDO.creditAccountName, this.qCreditAccountFlowDO.sourceNo, this.qCreditAccountFlowDO.sourceDoc, this.qCreditAccountFlowDO.remark, this.qCreditAccountFlowDO.createTime, this.qCreditAccountFlowDO.createUserId, this.qCreditAccountFlowDO.creator, this.qCreditAccountFlowDO.modifyTime, this.qCreditAccountFlowDO.modifyUserId, this.qCreditAccountFlowDO.updater, this.qCreditAccountFlowDO.deleteFlag, this.qCreditAccountFlowDO.ouCode, this.qCreditAccountFlowDO.creditAccountCode, this.qCreditAccountFlowDO.creditAccountName, this.qCreditAccountFlowDO.creditAccountLimit, this.qCreditAccountFlowDO.creditAccountUsedLimit, this.qCreditAccountFlowDO.creditAccountOccupancyLimit, this.qCreditAccountFlowDO.creditAccountAvailableLimit, this.qCreditAccountFlowDO.auditUserId, this.qCreditAccountFlowDO.auditUserName, this.qCreditAccountFlowDO.auditDate, this.qCreditAccountFlowDO.orderState, this.qCreditAccountFlowDO.creditAccountRuleCode, this.qCreditAccountFlowDO.priorityNo, this.qCreditAccountFlowDO.ouName, this.qCreditAccountFlowDO.objectCode, this.qCreditAccountFlowDO.objectName, this.qCreditAccountFlowDO.objectType, this.qCreditAccountFlowDO.buCode, this.qCreditAccountFlowDO.buName, this.qCreditAccountFlowDO.productLine, this.qCreditAccountFlowDO.saleUser, this.qCreditAccountFlowDO.sourceId, this.qCreditAccountFlowDO.sourceDocStatus, this.qCreditAccountFlowDO.creditAccountRuleName})).from((EntityPath)this.qCreditAccountFlowDO);
    }

    public PagingVO<CreditAccountFlowVO> dealerPage(CreditAccountFlowParam creditAccountFlowParam) {
        List<Predicate> where = this.where(creditAccountFlowParam);
        JPAQuery query = (JPAQuery)this.dealerSelect(CreditAccountFlowVO.class).where(ExpressionUtils.allOf(where));
        creditAccountFlowParam.setPaging(query);
        creditAccountFlowParam.fillOrders(query, this.qCreditAccountFlowDO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    private <T> JPAQuery<T> dealerSelect(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qCreditAccountFlowDO.id, this.qCreditAccountFlowDO.flowNo, this.qCreditAccountFlowDO.transactionType, this.qCreditAccountFlowDO.amount, this.qCreditAccountFlowDO.transactionTime, this.qCreditAccountFlowDO.creditAccountCode, this.qCreditAccountFlowDO.creditAccountName, this.qCreditAccountFlowDO.sourceNo, this.qCreditAccountFlowDO.sourceDoc})).from((EntityPath)this.qCreditAccountFlowDO);
    }

    public List<CreditAccountFlowVO> dealerSelectAmt(CreditAccountFlowParam creditAccountFlowParam) {
        List<Predicate> where = this.where(creditAccountFlowParam);
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CreditAccountFlowVO.class, (Expression[])new Expression[]{this.qCreditAccountFlowDO.id, this.qCreditAccountFlowDO.amount})).from((EntityPath)this.qCreditAccountFlowDO);
        jpaQuery.where(ExpressionUtils.allOf(where));
        return jpaQuery.fetch();
    }

    public void approveAccountFlow(CreditAccountFlowParam creditAccountFlowParam) {
        this.jpaQueryFactory.update((EntityPath)this.qCreditAccountFlowDO).set((Path)this.qCreditAccountFlowDO.orderState, (Object)creditAccountFlowParam.getOrderState()).set(this.qCreditAccountFlowDO.auditUserId, (Object)creditAccountFlowParam.getAuditUserId()).set((Path)this.qCreditAccountFlowDO.auditUserName, (Object)creditAccountFlowParam.getAuditUserName()).set(this.qCreditAccountFlowDO.auditDate, (Object)creditAccountFlowParam.getAuditDate()).where(new Predicate[]{this.qCreditAccountFlowDO.id.eq((Object)creditAccountFlowParam.getId())}).execute();
    }

    public List<CreditAccountFlowVO> queryCreditAccountFlowVO(CreditAccountFlowParam creditAccountFlowParam) {
        JPAQuery<CreditAccountFlowVO> query = this.select(CreditAccountFlowVO.class);
        if (creditAccountFlowParam.getSourceId() != null) {
            query.where((Predicate)this.qCreditAccountFlowDO.sourceId.eq((Object)creditAccountFlowParam.getSourceId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)creditAccountFlowParam.getSourceDoc())) {
            query.where((Predicate)this.qCreditAccountFlowDO.sourceDoc.eq((Object)creditAccountFlowParam.getSourceDoc()));
        }
        if (StringUtils.isNotEmpty((CharSequence)creditAccountFlowParam.getSourceDocStatus())) {
            query.where((Predicate)this.qCreditAccountFlowDO.sourceDocStatus.eq((Object)creditAccountFlowParam.getSourceDocStatus()));
        }
        if (StringUtils.isNotEmpty((CharSequence)creditAccountFlowParam.getCreditAccountType())) {
            query.where((Predicate)this.qCreditAccountFlowDO.creditAccountType.eq((Object)creditAccountFlowParam.getCreditAccountType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)creditAccountFlowParam.getSourceNo())) {
            query.where((Predicate)this.qCreditAccountFlowDO.sourceNo.eq((Object)creditAccountFlowParam.getSourceNo()));
        }
        return query.fetch();
    }

    public void updateCreditAccountFlowAmount(CreditAccountFlowParam creditAccountFlowParam) {
        this.jpaQueryFactory.update((EntityPath)this.qCreditAccountFlowDO).set(this.qCreditAccountFlowDO.creditAccountLimit, (Object)creditAccountFlowParam.getCreditAccountLimit()).set(this.qCreditAccountFlowDO.creditAccountUsedLimit, (Object)creditAccountFlowParam.getCreditAccountUsedLimit()).set(this.qCreditAccountFlowDO.creditAccountOccupancyLimit, (Object)creditAccountFlowParam.getCreditAccountOccupancyLimit()).set(this.qCreditAccountFlowDO.creditAccountAvailableLimit, (Object)creditAccountFlowParam.getCreditAccountAvailableLimit()).where(new Predicate[]{this.qCreditAccountFlowDO.creditAccountCode.eq((Object)creditAccountFlowParam.getCreditAccountCode()).and((Predicate)this.qCreditAccountFlowDO.orderState.eq((Object)creditAccountFlowParam.getOrderState()))}).execute();
    }

    public CreditAccountFlowRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

